package com.minecolonies.coremod.items;

import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

/**
 * Class used to handle the compost item.
 */
public class ItemCompost extends AbstractItemMinecolonies
{
    /**
     * Max stacksize of the item.
     */
    private static final int MAX_STACK_SIZE = 64;

    /**
     * Compost constructor, Set max stack size to 64 like all other items.
     */
    public ItemCompost()
    {
        super("compost");

        super.func_77637_a(ModCreativeTabs.MINECOLONIES);
        field_77777_bU = MAX_STACK_SIZE;
    }

    /**
     * /whenever player right click a block with this "compost item", call this method.
     * @param stack the right clicked stack.
     * @param playerIn the player doing it.
     * @param worldIn the world.
     * @param pos the position.
     * @param side the side he clicks it.
     * @param hitX the x hit position.
     * @param hitY the y hit position.
     * @param hitZ the z hit position.
     * @return true if succesful.
     */
    public boolean onItemUse(
                              final ItemStack stack,
                              final EntityPlayer playerIn,
                              final World worldIn,
                              final BlockPos pos,
                              final EnumFacing side,
                              final float hitX,
                              final float hitY,
                              final float hitZ)
    {

        final IBlockState iblockstate = worldIn.func_180495_p(pos);

        if (iblockstate.func_177230_c() instanceof IGrowable)
        {
            final IGrowable igrowable = (IGrowable) iblockstate.func_177230_c();

            if (igrowable.func_176473_a(worldIn, pos, iblockstate, worldIn.field_72995_K))
            {
                if (!worldIn.field_72995_K)
                {
                    if (igrowable.func_180670_a(worldIn, worldIn.field_73012_v, pos, iblockstate))
                    {
                        igrowable.func_176474_b(worldIn, worldIn.field_73012_v, pos, iblockstate);
                    }

                    --stack.field_77994_a;
                }
            }
        }
        return true;
    }
}


