package com.minecolonies.coremod.items;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.BuildingGuardTower;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.LanguageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

/**
 * Guard Scepter Item class. Used to give tasks to guards.
 */
public class ItemScepterGuard extends AbstractItemMinecolonies
{
    /**
     * The compound tag for the last pos the tool has been clicked.
     */
    private static final String TAG_LAST_POS = "lastPos";

    /**
     * Caliper constructor. Sets max stack to 1, like other tools.
     */
    public ItemScepterGuard()
    {
        super("scepterGuard");
        this.func_77656_e(2);

        field_77777_bU = 1;
    }

    @NotNull
    @Override
    public EnumActionResult func_180614_a(
                                       final ItemStack scepter,
                                       final EntityPlayer playerIn,
                                       final World worldIn,
                                       final BlockPos pos,
                                       final EnumHand hand,
                                       final EnumFacing facing,
                                       final float hitX,
                                       final float hitY,
                                       final float hitZ)
    {
        //todo watch how interaction with server is, might facilitate this.
        // if server world, do nothing
        if (worldIn.field_72995_K)
        {
            return EnumActionResult.FAIL;
        }

        if (!scepter.func_77942_o())
        {
            scepter.func_77982_d(new NBTTagCompound());
        }
        final NBTTagCompound compound = scepter.func_77978_p();

        if (compound.func_74764_b(TAG_LAST_POS))
        {
            final BlockPos lastPos = BlockPosUtil.readFromNBT(compound, TAG_LAST_POS);
            if (lastPos.equals(pos))
            {
                playerIn.field_71071_by.func_70304_b(playerIn.field_71071_by.field_70461_c);
                LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.job.guard.toolDoubleClick");
                return EnumActionResult.FAIL;
            }
        }
        return handleItemUsage(worldIn, pos, compound, playerIn);
    }

    /**
     * Handles the usage of the item.
     *
     * @param worldIn  the world it is used in.
     * @param pos      the position.
     * @param compound the compound.
     * @param playerIn the player using it.
     * @return if it has been successful.
     */
    @NotNull
    private static EnumActionResult handleItemUsage(final World worldIn, final BlockPos pos, final NBTTagCompound compound, final EntityPlayer playerIn)
    {
        final Colony colony = ColonyManager.getClosestColony(worldIn, pos);
        if (colony == null)
        {
            return EnumActionResult.FAIL;
        }

        final BlockPos guardTower = BlockPosUtil.readFromNBT(compound, "pos");
        final AbstractBuilding hut = colony.getBuilding(guardTower);
        if (hut == null || !(hut instanceof BuildingGuardTower))
        {
            return EnumActionResult.FAIL;
        }

        final BuildingGuardTower.Task task = BuildingGuardTower.Task.values()[compound.func_74762_e("task")];
        final CitizenData citizen = ((BuildingGuardTower) hut).getWorker();

        String name = "";
        if (citizen != null)
        {
            name = " " + citizen.getName();
        }

        if (task.equals(BuildingGuardTower.Task.GUARD))
        {
            LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.job.guard.toolClickGuard", pos, name);
            ((BuildingGuardTower) hut).setGuardTarget(pos);
            playerIn.field_71071_by.func_70304_b(playerIn.field_71071_by.field_70461_c);
        }
        else
        {
            if (!compound.func_74764_b(TAG_LAST_POS))
            {
                ((BuildingGuardTower) hut).resetPatrolTargets();
            }
            ((BuildingGuardTower) hut).addPatrolTargets(pos);
            LanguageHandler.sendPlayerMessage(playerIn, "com.minecolonies.coremod.job.guard.toolClickPatrol", pos, name);
        }
        BlockPosUtil.writeToNBT(compound, TAG_LAST_POS, pos);

        return EnumActionResult.SUCCESS;
    }
}
