package com.minecolonies.coremod.util;

import com.minecolonies.coremod.entity.EntityCitizen;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

/**
 * Helper class for teleporting citizens.
 */
public final class TeleportHelper
{
    private static final double MIDDLE_BLOCK_OFFSET = 0.5D;

    /**
     * Private constructor to hide the implicit public one.
     */
    private TeleportHelper()
    {
        // Intentionally left empty.
    }

    public static boolean teleportCitizen(EntityCitizen citizen, World world, BlockPos location)
    {
        if (citizen == null || world == null)
        {
            return false;
        }

        final BlockPos spawnPoint = EntityUtils.getSpawnPoint(world, location);
        if (spawnPoint == null)
        {
            return false;
        }

        citizen.func_70012_b(
                spawnPoint.func_177958_n() + MIDDLE_BLOCK_OFFSET,
                spawnPoint.func_177956_o(),
                spawnPoint.func_177952_p() + MIDDLE_BLOCK_OFFSET,
                citizen.field_70177_z,
                citizen.field_70125_A);
        citizen.func_70661_as().func_75499_g();

        return true;
    }
}
