/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockHut
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static final float HARDNESS = 10.0f;
    private static final float RESISTANCE = Float.POSITIVE_INFINITY;
    protected int workingRange;

    public AbstractBlockHut() {
        super(Material.WOOD);
        this.initBlock();
    }

    private void initBlock() {
        this.setRegistryName(this.getName());
        this.setUnlocalizedName("minecolonies".toLowerCase() + "." + this.getName());
        this.setCreativeTab(ModCreativeTabs.MINECOLONIES);
        this.setResistance(Float.POSITIVE_INFINITY);
        this.setHardness(10.0f);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public abstract String getName();

    @NotNull
    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileEntityColonyBuilding();
    }

    @Deprecated
    public boolean isFullBlock(IBlockState state) {
        return false;
    }

    @Deprecated
    @NotNull
    public IBlockState getStateFromMeta(int meta) {
        EnumFacing enumfacing = EnumFacing.getFront((int)meta);
        if (enumfacing.getAxis() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumfacing);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
    }

    @Deprecated
    @NotNull
    public IBlockState withRotation(@NotNull IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    @Deprecated
    @NotNull
    public IBlockState withMirror(@NotNull IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    @Deprecated
    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.SOLID;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        AbstractBuilding.View building;
        if (worldIn.isRemote && (building = ColonyManager.getBuildingView(pos)) != null && building.getColony() != null && building.getColony().getPermissions() != null && building.getColony().getPermissions().hasPermission(playerIn, Permissions.Action.ACCESS_HUTS)) {
            building.openGui();
        }
        return true;
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nullable EntityLivingBase placer) {
        EnumFacing enumFacing = placer == null ? EnumFacing.NORTH : EnumFacing.fromAngle((double)placer.rotationYaw);
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumFacing);
    }

    public void onBlockPlacedBy(@NotNull World worldIn, @NotNull BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityColonyBuilding hut;
        Colony colony;
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isRemote) {
            return;
        }
        TileEntity tileEntity = worldIn.getTileEntity(pos);
        if (placer instanceof EntityPlayer && tileEntity instanceof TileEntityColonyBuilding && (colony = ColonyManager.getColony(worldIn, (hut = (TileEntityColonyBuilding)tileEntity).getPosition())) != null) {
            colony.addNewBuilding(hut);
        }
    }

    public void onBlockPlacedByBuildTool(@NotNull World worldIn, @NotNull BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, boolean mirror) {
        TileEntity tileEntity = worldIn.getTileEntity(pos);
        if (tileEntity instanceof TileEntityColonyBuilding) {
            ((TileEntityColonyBuilding)tileEntity).setMirror(mirror);
        }
        this.onBlockPlacedBy(worldIn, pos, state, placer, stack);
    }

    @NotNull
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }
}

