/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks;

import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.util.Log;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.jetbrains.annotations.NotNull;

public class BlockBarrel
extends Block {
    private static final int MIN_FULLNESS = 0;
    private static final int MAX_FULLNESS = 16;
    private static final int BARRELSTATE_FILLING = 0;
    private static final int BARRELSTATE_COMPOSTING = 1;
    private static final int BARRELSTATE_DONE = 2;
    private static final PropertyInteger BARRELSTATE = PropertyInteger.create((String)"BARRELSTATE", (int)0, (int)2);
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "blockBarrel";
    private static final float RESISTANCE = 1.0f;
    private static final HashMap<BlockPos, Integer> timers = new HashMap();
    private static final HashMap<BlockPos, Integer> fillings = new HashMap();

    public BlockBarrel() {
        super(Material.WOOD);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(0)));
        this.setTickRandomly(true);
        this.initBlock();
    }

    private void initBlock() {
        this.setRegistryName(BLOCK_NAME);
        this.setUnlocalizedName(String.format("%s.%s", "minecolonies".toLowerCase(), BLOCK_NAME));
        this.setCreativeTab(ModCreativeTabs.MINECOLONIES);
        GameRegistry.registerBlock((Block)this, (String)BLOCK_NAME);
        this.setHardness(5.0f);
        this.setResistance(1.0f);
    }

    public void AddItemToBarrel(World worldIn, EntityPlayer playerIn, ItemStack itemStack, IBlockState state, BlockPos pos) {
        this.UseBarrel(worldIn, playerIn, itemStack, state, pos);
    }

    public boolean UseBarrel(World worldIn, EntityPlayer playerIn, ItemStack itemstack, IBlockState state, BlockPos pos) {
        Log.getLogger().info("block activated");
        int barrelState = (Integer)state.getValue((IProperty)BARRELSTATE);
        int fullness = fillings.getOrDefault(pos, 0);
        Log.getLogger().info("At this moment bs= " + barrelState + " and fl=" + fullness);
        if ((Integer)state.getValue((IProperty)BARRELSTATE) == 2) {
            worldIn.setBlockState(pos, state.withProperty((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(0)));
            fillings.put(pos, 0);
            Log.getLogger().info("Set Blockstate to " + worldIn.getBlockState(pos));
            return true;
        }
        if (itemstack == null) {
            return true;
        }
        Item item = itemstack.getItem();
        if (item == Items.ROTTEN_FLESH && barrelState == 0) {
            Log.getLogger().info("item Consumed");
            --itemstack.stackSize;
            if (++fullness >= 16) {
                fullness = 16;
                worldIn.setBlockState(pos, state.withProperty((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(1)));
            }
            fillings.put(pos, fullness);
            Log.getLogger().info("now FULLNESS = " + fullness);
            return true;
        }
        return true;
    }

    public void GetItemFromBarrel(World worldIn, EntityPlayer playerIn, ItemStack itemStack, IBlockState state, BlockPos pos) {
        int bs = (Integer)state.getValue((IProperty)BARRELSTATE);
        if (bs == 2) {
            this.UseBarrel(worldIn, playerIn, null, state, pos);
        }
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(meta));
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)BARRELSTATE);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return true;
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        Log.getLogger().info("UpdateTick called");
        int barrelState = (Integer)state.getValue((IProperty)BARRELSTATE);
        Log.getLogger().info("now BARRELSTATE = " + barrelState);
        switch ((Integer)state.getValue((IProperty)BARRELSTATE)) {
            case 0: {
                BlockBarrel.checkIfBarrelFull(worldIn, pos, state);
                break;
            }
            case 1: {
                BlockBarrel.doBarrelCompostTick(worldIn, pos, state);
                break;
            }
        }
    }

    private static void checkIfBarrelFull(World world, BlockPos pos, IBlockState state) {
        int fullness = fillings.getOrDefault(pos, 0);
        if (fullness >= 16) {
            Log.getLogger().info("Barrel is full.");
            world.setBlockState(pos, state.withProperty((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(1)));
        }
    }

    private static void doBarrelCompostTick(World world, BlockPos pos, IBlockState state) {
        int timer = timers.getOrDefault(pos, 0);
        if (++timer >= 20) {
            world.setBlockState(pos, state.withProperty((IProperty)BARRELSTATE, (Comparable)Integer.valueOf(2)));
            timer = 0;
        }
        timers.put(pos, timer);
    }

    @NotNull
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{BARRELSTATE});
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        Log.getLogger().info("block right-clicked");
        ItemStack itemstack = playerIn.inventory.getCurrentItem();
        this.UseBarrel(worldIn, playerIn, itemstack, state, pos);
        return true;
    }
}

