/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.network.messages.BuildToolPlaceMessage;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.structures.helpers.Settings;
import com.minecolonies.structures.helpers.Structure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowBuildTool
extends AbstractWindowSkeleton {
    private static final String BUTTON_TYPE_ID = "buildingType";
    private static final String BUTTON_HUT_DEC_ID = "hutDec";
    private static final String BUTTON_STYLE_ID = "style";
    private static final String BUTTON_LEVEL_ID = "level";
    private static final String BUTTON_CONFIRM = "confirm";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_ROTATE_LEFT = "rotateLeft";
    private static final String BUTTON_ROTATE_RIGHT = "rotateRight";
    private static final String BUTTON_UP = "up";
    private static final String BUTTON_DOWN = "down";
    private static final String BUTTON_FORWARD = "forward";
    private static final String BUTTON_BACK = "back";
    private static final String BUTTON_LEFT = "left";
    private static final String BUTTON_RIGHT = "right";
    private static final String BUTTON_MIRROR = "mirror";
    private static final String BUILD_TOOL_RESOURCE_SUFFIX = ":gui/windowBuildTool.xml";
    private static final String HUT_PREFIX = ":blockHut";
    private static final int POSSIBLE_ROTATIONS = 4;
    private static final int ROTATE_RIGHT = 1;
    private static final int ROTATE_180 = 2;
    private static final int ROTATE_LEFT = 3;
    private static final String NO_HUT_IN_INVENTORY = "com.minecolonies.coremod.gui.buildtool.nohutininventory";
    @NotNull
    private final List<String> hutDec = new ArrayList<String>();
    private int hutDecIndex = 0;
    private int styleIndex = 0;
    @NotNull
    private BlockPos pos = new BlockPos(0, 0, 0);
    private int rotation = 0;
    private int level = 0;

    public WindowBuildTool(@Nullable BlockPos pos) {
        super("minecolonies:gui/windowBuildTool.xml");
        Structure structure = Settings.instance.getActiveStructure();
        if (structure != null) {
            this.rotation = Settings.instance.getRotation();
            this.level = Settings.instance.getLevel();
        } else if (pos != null) {
            this.pos = pos;
            Settings.instance.pos = pos;
            Settings.instance.setRotation(0);
        }
        this.registerButton(BUTTON_TYPE_ID, this::placementModeClicked);
        this.registerButton(BUTTON_HUT_DEC_ID, this::hutDecClicked);
        this.registerButton(BUTTON_STYLE_ID, this::styleClicked);
        this.registerButton(BUTTON_LEVEL_ID, this::levelClicked);
        this.registerButton(BUTTON_CONFIRM, this::confirmClicked);
        this.registerButton(BUTTON_CANCEL, this::cancelClicked);
        this.registerButton(BUTTON_LEFT, this::moveLeftClicked);
        this.registerButton(BUTTON_RIGHT, this::moveRightClicked);
        this.registerButton(BUTTON_BACK, this::moveBackClicked);
        this.registerButton(BUTTON_FORWARD, this::moveForwardClicked);
        this.registerButton(BUTTON_UP, WindowBuildTool::moveUpClicked);
        this.registerButton(BUTTON_DOWN, WindowBuildTool::moveDownClicked);
        this.registerButton(BUTTON_ROTATE_RIGHT, this::rotateRightClicked);
        this.registerButton(BUTTON_ROTATE_LEFT, this::rotateLeftClicked);
        this.registerButton(BUTTON_MIRROR, WindowBuildTool::mirror);
    }

    private static boolean inventoryHasHut(@NotNull InventoryPlayer inventory, String hut) {
        return inventory.hasItemStack(new ItemStack(Block.getBlockFromName((String)("minecolonies:blockHut" + hut))));
    }

    private static void moveUpClicked() {
        Settings.instance.moveTo(new BlockPos(0, 1, 0));
    }

    private static void moveDownClicked() {
        Settings.instance.moveTo(new BlockPos(0, -1, 0));
    }

    @Override
    public void onOpened() {
        if (Settings.instance.isInHutMode()) {
            this.loadHutMode();
        } else {
            this.loadDecorationMode();
        }
    }

    @Override
    public void onClosed() {
        if (Settings.instance.getActiveStructure() != null) {
            Settings.instance.setSchematicInfo(this.findPaneOfTypeByID(BUTTON_HUT_DEC_ID, Button.class).getLabel(), this.findPaneOfTypeByID(BUTTON_STYLE_ID, Button.class).getLabel(), this.level, this.rotation);
        }
    }

    private void loadDecorationMode() {
        this.findPaneOfTypeByID(BUTTON_TYPE_ID, Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.buildtool.decoration", new Object[0]));
        this.hutDec.addAll(Structures.getDecorations());
        this.setupButtons();
    }

    private void loadHutMode() {
        this.findPaneOfTypeByID(BUTTON_TYPE_ID, Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.buildtool.hut", new Object[0]));
        InventoryPlayer inventory = this.mc.thePlayer.inventory;
        this.hutDec.addAll(Structures.getHuts().stream().filter(hut -> WindowBuildTool.inventoryHasHut(inventory, hut) && Structures.getStylesForHut(hut) != null).collect(Collectors.toList()));
        this.setupButtons();
    }

    private void setupButtons() {
        if (this.hutDec.isEmpty()) {
            Button buttonHutDec = this.findPaneOfTypeByID(BUTTON_HUT_DEC_ID, Button.class);
            buttonHutDec.setLabel(LanguageHandler.format(Settings.instance.isInHutMode() ? "com.minecolonies.coremod.gui.buildtool.nohut" : "com.minecolonies.coremod.gui.buildtool.nodecoration", new Object[0]));
            buttonHutDec.setEnabled(false);
            Button buttonStyle = this.findPaneOfTypeByID(BUTTON_STYLE_ID, Button.class);
            buttonStyle.setVisible(false);
            Settings.instance.setActiveSchematic(null);
        } else {
            if (Settings.instance.getActiveStructure() != null) {
                this.hutDecIndex = Math.max(0, this.hutDec.indexOf(Settings.instance.getHutDec()));
                this.styleIndex = Math.max(0, this.getStyles().indexOf(Settings.instance.getStyle()));
            }
            Button buttonHutDec = this.findPaneOfTypeByID(BUTTON_HUT_DEC_ID, Button.class);
            buttonHutDec.setLabel(this.hutDec.get(this.hutDecIndex));
            buttonHutDec.setEnabled(true);
            Button buttonStyle = this.findPaneOfTypeByID(BUTTON_STYLE_ID, Button.class);
            buttonStyle.setVisible(true);
            buttonStyle.setLabel(this.getStyles().get(this.styleIndex));
            if (Settings.instance.getActiveStructure() == null) {
                this.rotation = 0;
                this.level = 0;
                this.changeSchematic();
            }
            this.updateLevelButton();
        }
    }

    private void placementModeClicked() {
        Settings.instance.setActiveSchematic(null);
        this.hutDec.clear();
        this.hutDecIndex = 0;
        this.styleIndex = 0;
        if (Settings.instance.isInHutMode()) {
            Settings.instance.setInHutMode(false);
            this.loadDecorationMode();
        } else {
            Settings.instance.setInHutMode(true);
            this.loadHutMode();
        }
    }

    private void hutDecClicked(@NotNull Button button) {
        if (this.hutDec.size() == 1) {
            return;
        }
        this.hutDecIndex = (this.hutDecIndex + 1) % this.hutDec.size();
        this.styleIndex = 0;
        button.setLabel(this.hutDec.get(this.hutDecIndex));
        this.findPaneOfTypeByID(BUTTON_STYLE_ID, Button.class).setLabel(this.getStyles().get(this.styleIndex));
        this.changeSchematic();
    }

    private List<String> getStyles() {
        try {
            Structures.loadStyleMaps(new File(Minecraft.getMinecraft().mcDataDir, "minecolonies/decorations").toPath());
        }
        catch (IOException e) {
            Log.getLogger().warn("No additional files found", (Throwable)e);
        }
        if (this.hutDec.isEmpty()) {
            return Collections.emptyList();
        }
        if (Settings.instance.isInHutMode()) {
            return Structures.getStylesForHut(this.hutDec.get(this.hutDecIndex));
        }
        return Structures.getStylesForDecoration(this.hutDec.get(this.hutDecIndex));
    }

    private void changeSchematic() {
        String labelHutDec = this.findPaneOfTypeByID(BUTTON_HUT_DEC_ID, Button.class).getLabel();
        String labelHutStyle = this.findPaneOfTypeByID(BUTTON_STYLE_ID, Button.class).getLabel();
        Structure structure = Settings.instance.isInHutMode() ? new Structure(null, labelHutStyle + '/' + labelHutDec + (this.level + 1), new PlacementSettings().setRotation(BlockUtils.getRotation(Settings.instance.getRotation()))) : new Structure(null, labelHutDec + '/' + labelHutStyle, new PlacementSettings().setRotation(BlockUtils.getRotation(Settings.instance.getRotation())));
        Settings.instance.setActiveSchematic(structure);
        if (Settings.instance.pos == null) {
            Settings.instance.pos = this.pos;
        }
    }

    private void styleClicked(@NotNull Button button) {
        List<String> styles = this.getStyles();
        if (styles.size() == 1) {
            return;
        }
        this.styleIndex = (this.styleIndex + 1) % styles.size();
        button.setLabel(styles.get(this.styleIndex));
        this.changeSchematic();
    }

    private void levelClicked() {
        int maxLevel = Structures.getMaxLevelForHut(this.hutDec.get(this.hutDecIndex));
        if (maxLevel > 1) {
            this.level = (this.level + 1) % maxLevel;
            this.updateLevelButton();
            this.changeSchematic();
        }
    }

    private void updateLevelButton() {
        Button buttonLevel = this.findPaneOfTypeByID(BUTTON_LEVEL_ID, Button.class);
        if (Settings.instance.isInHutMode()) {
            buttonLevel.setVisible(true);
            buttonLevel.setLabel("Level: " + (this.level + 1));
        } else {
            buttonLevel.setVisible(false);
        }
    }

    private void confirmClicked() {
        if (this.hutDecIndex < this.hutDec.size()) {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildToolPlaceMessage(this.hutDec.get(this.hutDecIndex), this.getStyles().get(this.styleIndex), Settings.instance.pos, Settings.instance.getRotation(), Settings.instance.isInHutMode(), Settings.instance.getMirror()));
        } else {
            LanguageHandler.sendPlayerMessage((EntityPlayer)this.mc.thePlayer, NO_HUT_IN_INVENTORY, new Object[0]);
        }
        Settings.instance.reset();
        this.close();
    }

    private void cancelClicked() {
        Settings.instance.reset();
        this.close();
    }

    private void moveLeftClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).offset(this.mc.thePlayer.getHorizontalFacing().rotateYCCW()));
    }

    private void moveRightClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).offset(this.mc.thePlayer.getHorizontalFacing().rotateY()));
    }

    private void moveForwardClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).offset(this.mc.thePlayer.getHorizontalFacing()));
    }

    private void moveBackClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).offset(this.mc.thePlayer.getHorizontalFacing().getOpposite()));
    }

    private void rotateRightClicked() {
        this.rotation = (this.rotation + 1) % 4;
        WindowBuildTool.updateRotation(this.rotation);
    }

    private static void updateRotation(int rotation) {
        PlacementSettings settings = new PlacementSettings();
        switch (rotation) {
            case 1: {
                settings.setRotation(Rotation.CLOCKWISE_90);
                break;
            }
            case 2: {
                settings.setRotation(Rotation.CLOCKWISE_180);
                break;
            }
            case 3: {
                settings.setRotation(Rotation.COUNTERCLOCKWISE_90);
                break;
            }
            default: {
                settings.setRotation(Rotation.NONE);
            }
        }
        Settings.instance.setRotation(rotation);
        if (Settings.instance.getActiveStructure() != null) {
            Settings.instance.getActiveStructure().setPlacementSettings(settings.setMirror(Settings.instance.getMirror()));
        }
    }

    private void rotateLeftClicked() {
        this.rotation = (this.rotation + 3) % 4;
        WindowBuildTool.updateRotation(this.rotation);
    }

    private static void mirror() {
        Settings.instance.mirror();
    }
}

