/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.colony.TriggerColonyAchievements;
import com.minecolonies.coremod.colony.WorkManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.BuildingHome;
import com.minecolonies.coremod.colony.buildings.BuildingTownHall;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.entity.ai.citizen.farmer.Field;
import com.minecolonies.coremod.network.messages.ColonyViewBuildingViewMessage;
import com.minecolonies.coremod.network.messages.ColonyViewCitizenViewMessage;
import com.minecolonies.coremod.network.messages.ColonyViewMessage;
import com.minecolonies.coremod.network.messages.ColonyViewRemoveBuildingMessage;
import com.minecolonies.coremod.network.messages.ColonyViewRemoveCitizenMessage;
import com.minecolonies.coremod.network.messages.ColonyViewRemoveWorkOrderMessage;
import com.minecolonies.coremod.network.messages.ColonyViewWorkOrderMessage;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.permissions.ColonyPermissionEventHandler;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.util.AchievementUtils;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.ColonyUtils;
import com.minecolonies.coremod.util.EntityUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.MathUtils;
import com.minecolonies.coremod.util.ServerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Colony
implements IColony {
    private static final int CITIZEN_CLEANUP_TICK_INCREMENT = 100;
    private static final String TAG_ID = "id";
    private static final String TAG_NAME = "name";
    private static final String TAG_DIMENSION = "dimension";
    private static final String TAG_CENTER = "center";
    private static final String TAG_MAX_CITIZENS = "maxCitizens";
    private static final String TAG_BUILDINGS = "buildings";
    private static final String TAG_CITIZENS = "citizens";
    private static final String TAG_ACHIEVEMENT = "achievement";
    private static final String TAG_ACHIEVEMENT_LIST = "achievementlist";
    private static final String TAG_WORK = "work";
    private static final String TAG_MANUAL_HIRING = "manualHiring";
    private static final String TAG_WAYPOINT = "waypoints";
    private static final String TAG_STATISTICS = "statistics";
    private static final String TAG_MINER_STATISTICS = "minerStatistics";
    private static final String TAG_MINER_ORES = "ores";
    private int minedOres = 0;
    private static final String TAG_MINER_DIAMONDS = "diamonds";
    private int minedDiamonds = 0;
    private static final String TAG_FARMER_STATISTICS = "farmerStatistics";
    private static final String TAG_FARMER_WHEAT = "wheat";
    private int harvestedWheat = 0;
    private static final String TAG_FARMER_POTATOES = "potatoes";
    private int harvestedPotatoes = 0;
    private static final String TAG_FARMER_CARROTS = "carrots";
    private int harvestedCarrots = 0;
    private static final String TAG_GUARD_STATISTICS = "guardStatistics";
    private static final String TAG_GUARD_MOBS = "mobs";
    private int killedMobs = 0;
    private static final String TAG_BUILDER_STATISTICS = "builderStatistics";
    private static final String TAG_BUILDER_HUTS = "huts";
    private int builtHuts = 0;
    private static final String TAG_FISHERMAN_STATISTICS = "fishermanStatistics";
    private static final String TAG_FISHERMAN_FISH = "fish";
    private int caughtFish = 0;
    private static final String TAG_LUMBERJACK_STATISTICS = "lumberjackStatistics";
    private static final String TAG_LUMBERJACK_TREES = "trees";
    private int felledTrees = 0;
    private static final String TAG_LUMBERJACK_SAPLINGS = "saplings";
    private int plantedSaplings = 0;
    private static final int NUM_ACHIEVEMENT_FIRST = 1;
    private static final int NUM_ACHIEVEMENT_SECOND = 25;
    private static final int NUM_ACHIEVEMENT_THIRD = 100;
    private static final int NUM_ACHIEVEMENT_FOURTH = 500;
    private static final int NUM_ACHIEVEMENT_FIFTH = 1000;
    private static final String TAG_FIELDS = "fields";
    private static final int CHECK_WAYPOINT_EVERY = 100;
    private static final double MAX_SQ_DIST_SUBSCRIBER_UPDATE = MathUtils.square((double)Configurations.workingRangeTownHall + 16.0);
    private static final double MAX_SQ_DIST_OLD_SUBSCRIBER_UPDATE = MathUtils.square((double)Configurations.workingRangeTownHall * 2.0);
    private final int id;
    private final int dimensionId;
    private final Map<BlockPos, Field> fields = new HashMap<BlockPos, Field>();
    private final Map<BlockPos, IBlockState> wayPoints = new HashMap<BlockPos, IBlockState>();
    @NotNull
    private final List<Achievement> colonyAchievements;
    private final WorkManager workManager = new WorkManager(this);
    @NotNull
    private final Map<BlockPos, AbstractBuilding> buildings = new HashMap<BlockPos, AbstractBuilding>();
    @NotNull
    private final Map<Integer, CitizenData> citizens = new HashMap<Integer, CitizenData>();
    @Nullable
    private World world = null;
    @NotNull
    private Set<EntityPlayerMP> subscribers = new HashSet<EntityPlayerMP>();
    private boolean isDirty = false;
    private boolean isCitizensDirty = false;
    private boolean isBuildingsDirty = false;
    private boolean manualHiring = false;
    private boolean isFieldsDirty = false;
    private String name = "ERROR(Wasn't placed by player)";
    private BlockPos center;
    @NotNull
    private Permissions permissions;
    @Nullable
    private BuildingTownHall townHall;
    private int topCitizenId = 0;
    private int maxCitizens = Configurations.maxCitizens;

    Colony(int id, @NotNull World w, BlockPos c) {
        this(id, w.provider.getDimension());
        this.center = c;
        this.world = w;
        this.permissions = new Permissions(this);
    }

    protected Colony(int id, int dim) {
        this.id = id;
        this.dimensionId = dim;
        this.permissions = new Permissions(this);
        this.colonyAchievements = new ArrayList<Achievement>();
        MinecraftForge.EVENT_BUS.register((Object)new ColonyPermissionEventHandler(this));
    }

    @NotNull
    public static Colony loadColony(@NotNull NBTTagCompound compound) {
        int id = compound.getInteger(TAG_ID);
        int dimensionId = compound.getInteger(TAG_DIMENSION);
        Colony c = new Colony(id, dimensionId);
        c.readFromNBT(compound);
        return c;
    }

    private void readFromNBT(@NotNull NBTTagCompound compound) {
        this.name = compound.getString(TAG_NAME);
        this.center = BlockPosUtil.readFromNBT(compound, TAG_CENTER);
        this.manualHiring = compound.getBoolean(TAG_MANUAL_HIRING);
        this.maxCitizens = compound.getInteger(TAG_MAX_CITIZENS);
        this.permissions.loadPermissions(compound);
        NBTTagList citizenTagList = compound.getTagList(TAG_CITIZENS, 10);
        for (int i = 0; i < citizenTagList.tagCount(); ++i) {
            NBTTagCompound citizenCompound = citizenTagList.getCompoundTagAt(i);
            CitizenData data = CitizenData.createFromNBT(citizenCompound, this);
            this.citizens.put(data.getId(), data);
            this.topCitizenId = Math.max(this.topCitizenId, data.getId());
        }
        NBTTagList buildingTagList = compound.getTagList(TAG_BUILDINGS, 10);
        for (int i = 0; i < buildingTagList.tagCount(); ++i) {
            NBTTagCompound buildingCompound = buildingTagList.getCompoundTagAt(i);
            AbstractBuilding b = AbstractBuilding.createFromNBT(this, buildingCompound);
            if (b == null) continue;
            this.addBuilding(b);
        }
        NBTTagList fieldTagList = compound.getTagList(TAG_FIELDS, 10);
        for (int i = 0; i < fieldTagList.tagCount(); ++i) {
            NBTTagCompound fieldCompound = fieldTagList.getCompoundTagAt(i);
            Field f = Field.createFromNBT(this, fieldCompound);
            this.addField(f);
        }
        NBTTagList achievementTagList = compound.getTagList(TAG_ACHIEVEMENT_LIST, 10);
        for (int i = 0; i < achievementTagList.tagCount(); ++i) {
            NBTTagCompound achievementCompound = achievementTagList.getCompoundTagAt(i);
            String achievementKey = achievementCompound.getString(TAG_ACHIEVEMENT);
            StatBase statBase = StatList.getOneShotStat((String)achievementKey);
            if (!(statBase instanceof Achievement)) continue;
            this.colonyAchievements.add((Achievement)statBase);
        }
        this.workManager.readFromNBT(compound.getCompoundTag(TAG_WORK));
        NBTTagList wayPointTagList = compound.getTagList(TAG_WAYPOINT, 10);
        for (int i = 0; i < wayPointTagList.tagCount(); ++i) {
            NBTTagCompound blockAtPos = wayPointTagList.getCompoundTagAt(i);
            BlockPos pos = BlockPosUtil.readFromNBT(blockAtPos, TAG_WAYPOINT);
            IBlockState state = NBTUtil.readBlockState((NBTTagCompound)blockAtPos);
            this.wayPoints.put(pos, state);
        }
        NBTTagCompound statisticsCompound = compound.getCompoundTag(TAG_STATISTICS);
        NBTTagCompound minerStatisticsCompound = statisticsCompound.getCompoundTag(TAG_MINER_STATISTICS);
        NBTTagCompound farmerStatisticsCompound = statisticsCompound.getCompoundTag(TAG_FARMER_STATISTICS);
        NBTTagCompound guardStatisticsCompound = statisticsCompound.getCompoundTag(TAG_FARMER_STATISTICS);
        NBTTagCompound builderStatisticsCompound = statisticsCompound.getCompoundTag(TAG_BUILDER_STATISTICS);
        NBTTagCompound fishermanStatisticsCompound = statisticsCompound.getCompoundTag(TAG_FISHERMAN_STATISTICS);
        NBTTagCompound lumberjackStatisticsCompound = statisticsCompound.getCompoundTag(TAG_LUMBERJACK_STATISTICS);
        this.minedOres = minerStatisticsCompound.getInteger(TAG_MINER_ORES);
        this.minedDiamonds = minerStatisticsCompound.getInteger(TAG_MINER_DIAMONDS);
        this.harvestedCarrots = farmerStatisticsCompound.getInteger(TAG_FARMER_CARROTS);
        this.harvestedPotatoes = farmerStatisticsCompound.getInteger(TAG_FARMER_POTATOES);
        this.harvestedWheat = farmerStatisticsCompound.getInteger(TAG_FARMER_WHEAT);
        this.killedMobs = guardStatisticsCompound.getInteger(TAG_GUARD_MOBS);
        this.builtHuts = builderStatisticsCompound.getInteger(TAG_BUILDER_HUTS);
        this.caughtFish = fishermanStatisticsCompound.getInteger(TAG_FISHERMAN_FISH);
        this.felledTrees = lumberjackStatisticsCompound.getInteger(TAG_LUMBERJACK_TREES);
        this.plantedSaplings = lumberjackStatisticsCompound.getInteger(TAG_LUMBERJACK_SAPLINGS);
    }

    private void addBuilding(@NotNull AbstractBuilding building) {
        this.buildings.put(building.getID(), building);
        building.markDirty();
        if (building instanceof BuildingTownHall && this.townHall == null) {
            this.townHall = (BuildingTownHall)building;
        }
    }

    private void addField(@NotNull Field field) {
        this.fields.put(field.getID(), field);
    }

    protected void writeToNBT(@NotNull NBTTagCompound compound) {
        compound.setInteger(TAG_ID, this.id);
        compound.setInteger(TAG_DIMENSION, this.dimensionId);
        compound.setString(TAG_NAME, this.name);
        BlockPosUtil.writeToNBT(compound, TAG_CENTER, this.center);
        compound.setBoolean(TAG_MANUAL_HIRING, this.manualHiring);
        compound.setInteger(TAG_MAX_CITIZENS, this.maxCitizens);
        this.permissions.savePermissions(compound);
        NBTTagList buildingTagList = new NBTTagList();
        for (AbstractBuilding abstractBuilding : this.buildings.values()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            abstractBuilding.writeToNBT(nBTTagCompound);
            buildingTagList.appendTag((NBTBase)nBTTagCompound);
        }
        compound.setTag(TAG_BUILDINGS, (NBTBase)buildingTagList);
        NBTTagList fieldTagList = new NBTTagList();
        for (Field field : this.fields.values()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            field.writeToNBT(nBTTagCompound);
            fieldTagList.appendTag((NBTBase)nBTTagCompound);
        }
        compound.setTag(TAG_FIELDS, (NBTBase)fieldTagList);
        NBTTagList nBTTagList = new NBTTagList();
        for (CitizenData citizenData : this.citizens.values()) {
            NBTTagCompound citizenCompound = new NBTTagCompound();
            citizenData.writeToNBT(citizenCompound);
            nBTTagList.appendTag((NBTBase)citizenCompound);
        }
        compound.setTag(TAG_CITIZENS, (NBTBase)nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (Achievement achievement : this.colonyAchievements) {
            NBTTagCompound achievementCompound = new NBTTagCompound();
            achievementCompound.setString(TAG_ACHIEVEMENT, achievement.statId);
            nBTTagList2.appendTag((NBTBase)achievementCompound);
        }
        compound.setTag(TAG_ACHIEVEMENT_LIST, (NBTBase)nBTTagList2);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        this.workManager.writeToNBT(nBTTagCompound);
        compound.setTag(TAG_WORK, (NBTBase)nBTTagCompound);
        NBTTagList wayPointTagList = new NBTTagList();
        for (Map.Entry entry : this.wayPoints.entrySet()) {
            NBTTagCompound wayPointCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(wayPointCompound, TAG_WAYPOINT, (BlockPos)entry.getKey());
            NBTUtil.writeBlockState((NBTTagCompound)wayPointCompound, (IBlockState)((IBlockState)entry.getValue()));
            wayPointTagList.appendTag((NBTBase)wayPointCompound);
        }
        compound.setTag(TAG_WAYPOINT, (NBTBase)wayPointTagList);
        NBTTagCompound statisticsCompound = new NBTTagCompound();
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        NBTTagCompound farmerStatisticsCompound = new NBTTagCompound();
        NBTTagCompound guardStatisticsCompound = new NBTTagCompound();
        NBTTagCompound builderStatisticsCompound = new NBTTagCompound();
        NBTTagCompound fishermanStatisticsCompound = new NBTTagCompound();
        NBTTagCompound lumberjackStatisticsCompound = new NBTTagCompound();
        compound.setTag(TAG_STATISTICS, (NBTBase)statisticsCompound);
        statisticsCompound.setTag(TAG_MINER_STATISTICS, (NBTBase)nBTTagCompound2);
        nBTTagCompound2.setInteger(TAG_MINER_ORES, this.minedOres);
        nBTTagCompound2.setInteger(TAG_MINER_DIAMONDS, this.minedDiamonds);
        statisticsCompound.setTag(TAG_FARMER_STATISTICS, (NBTBase)farmerStatisticsCompound);
        farmerStatisticsCompound.setInteger(TAG_FARMER_CARROTS, this.harvestedCarrots);
        farmerStatisticsCompound.setInteger(TAG_FARMER_POTATOES, this.harvestedPotatoes);
        farmerStatisticsCompound.setInteger(TAG_FARMER_WHEAT, this.harvestedWheat);
        statisticsCompound.setTag(TAG_GUARD_STATISTICS, (NBTBase)guardStatisticsCompound);
        guardStatisticsCompound.setInteger(TAG_GUARD_MOBS, this.killedMobs);
        statisticsCompound.setTag(TAG_BUILDER_STATISTICS, (NBTBase)builderStatisticsCompound);
        builderStatisticsCompound.setInteger(TAG_BUILDER_HUTS, this.builtHuts);
        statisticsCompound.setTag(TAG_FISHERMAN_STATISTICS, (NBTBase)fishermanStatisticsCompound);
        fishermanStatisticsCompound.setInteger(TAG_FISHERMAN_FISH, this.caughtFish);
        statisticsCompound.setTag(TAG_LUMBERJACK_STATISTICS, (NBTBase)lumberjackStatisticsCompound);
        lumberjackStatisticsCompound.setInteger(TAG_LUMBERJACK_TREES, this.felledTrees);
        lumberjackStatisticsCompound.setInteger(TAG_LUMBERJACK_SAPLINGS, this.plantedSaplings);
    }

    public int getDimension() {
        return this.dimensionId;
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
        this.markDirty();
    }

    private void markDirty() {
        this.isDirty = true;
    }

    @Override
    @NotNull
    public Permissions getPermissions() {
        return this.permissions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCoordInColony(@NotNull World w, @NotNull BlockPos pos) {
        if (!w.equals(this.getWorld())) return false;
        BlockPos blockPos = new BlockPos(pos.getX(), this.center.getY(), pos.getZ());
        if (!((double)BlockPosUtil.getDistanceSquared(this.center, blockPos) <= MathUtils.square(Configurations.workingRangeTownHall))) return false;
        return true;
    }

    @Nullable
    public World getWorld() {
        return this.world;
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public int getID() {
        return this.id;
    }

    private int getStatisticAmount(@NotNull String statistic) {
        switch (statistic) {
            case "mobs": {
                return this.killedMobs;
            }
            case "ores": {
                return this.minedOres;
            }
            case "diamonds": {
                return this.minedDiamonds;
            }
            case "huts": {
                return this.builtHuts;
            }
            case "fish": {
                return this.caughtFish;
            }
            case "wheat": {
                return this.harvestedWheat;
            }
            case "potatoes": {
                return this.harvestedPotatoes;
            }
            case "carrots": {
                return this.harvestedCarrots;
            }
            case "saplings": {
                return this.plantedSaplings;
            }
            case "trees": {
                return this.felledTrees;
            }
        }
        return 0;
    }

    private void incrementStatisticAmount(@NotNull String statistic) {
        switch (statistic) {
            case "mobs": {
                ++this.killedMobs;
                break;
            }
            case "ores": {
                ++this.minedOres;
                break;
            }
            case "diamonds": {
                ++this.minedDiamonds;
                break;
            }
            case "huts": {
                ++this.builtHuts;
                break;
            }
            case "fish": {
                ++this.caughtFish;
                break;
            }
            case "wheat": {
                ++this.harvestedWheat;
                break;
            }
            case "potatoes": {
                ++this.harvestedPotatoes;
                break;
            }
            case "carrots": {
                ++this.harvestedCarrots;
                break;
            }
            case "saplings": {
                ++this.plantedSaplings;
                break;
            }
            case "trees": {
                ++this.felledTrees;
                break;
            }
        }
    }

    public void incrementStatistic(@NotNull String statistic) {
        int statisticAmount = this.getStatisticAmount(statistic);
        this.incrementStatisticAmount(statistic);
        if (statisticAmount >= 1) {
            TriggerColonyAchievements.triggerFirstAchievement(statistic, this);
        }
        if (statisticAmount >= 25) {
            TriggerColonyAchievements.triggerSecondAchievement(statistic, this);
        }
        if (statisticAmount >= 100) {
            TriggerColonyAchievements.triggerThirdAchievement(statistic, this);
        }
        if (statisticAmount >= 500) {
            TriggerColonyAchievements.triggerFourthAchievement(statistic, this);
        }
        if (statisticAmount >= 1000) {
            TriggerColonyAchievements.triggerFifthAchievement(statistic, this);
        }
    }

    public void triggerAchievement(@NotNull Achievement achievement) {
        if (this.colonyAchievements.contains(achievement)) {
            return;
        }
        this.colonyAchievements.add(achievement);
        AchievementUtils.syncAchievements(this);
    }

    public void markCitizensDirty() {
        this.isCitizensDirty = true;
    }

    public void markBuildingsDirty() {
        this.isBuildingsDirty = true;
    }

    public void onWorldLoad(@NotNull World w) {
        if (w.provider.getDimension() == this.dimensionId) {
            this.world = w;
        }
    }

    public void onWorldUnload(@NotNull World w) {
        if (!w.equals(this.world)) {
            throw new IllegalStateException("Colony's world does not match the event.");
        }
        this.world = null;
    }

    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        for (AbstractBuilding b : this.buildings.values()) {
            b.onServerTick(event);
        }
        if (event.phase == TickEvent.Phase.END) {
            this.updateSubscribers();
        }
    }

    private void updateSubscribers() {
        if (this.world == null || this.world.getMinecraftServer() == null) {
            return;
        }
        Set<EntityPlayerMP> oldSubscribers = this.subscribers;
        this.subscribers = new HashSet<EntityPlayerMP>();
        this.world.getMinecraftServer().getPlayerList().getPlayerList().stream().filter(this.permissions::isSubscriber).forEachOrdered(this.subscribers::add);
        for (EntityPlayer o : this.world.playerEntities) {
            double distance;
            EntityPlayerMP player;
            if (!(o instanceof EntityPlayerMP) || this.subscribers.contains(player = (EntityPlayerMP)o) || !((distance = player.getDistanceSq(this.center)) < MAX_SQ_DIST_SUBSCRIBER_UPDATE) && (!oldSubscribers.contains(player) || !(distance < MAX_SQ_DIST_OLD_SUBSCRIBER_UPDATE))) continue;
            this.subscribers.add(player);
        }
        if (!this.subscribers.isEmpty()) {
            boolean hasNewSubscribers = ColonyUtils.hasNewSubscribers(oldSubscribers, this.subscribers);
            this.sendColonyViewPackets(oldSubscribers, hasNewSubscribers);
            this.sendPermissionsPackets(oldSubscribers, hasNewSubscribers);
            this.sendWorkOrderPackets(oldSubscribers, hasNewSubscribers);
            this.sendCitizenPackets(oldSubscribers, hasNewSubscribers);
            this.sendBuildingPackets(oldSubscribers, hasNewSubscribers);
            if (!this.isBuildingsDirty) {
                this.sendFieldPackets(hasNewSubscribers);
            }
        }
        this.isFieldsDirty = false;
        this.isDirty = false;
        this.isCitizensDirty = false;
        this.isBuildingsDirty = false;
        this.permissions.clearDirty();
        this.buildings.values().forEach(AbstractBuilding::clearDirty);
        this.citizens.values().forEach(CitizenData::clearDirty);
    }

    private void sendColonyViewPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.isDirty || hasNewSubscribers) {
            for (EntityPlayerMP player : this.subscribers) {
                boolean isNewSubscriber;
                boolean bl = isNewSubscriber = !oldSubscribers.contains(player);
                if (!this.isDirty && !isNewSubscriber) continue;
                MineColonies.getNetwork().sendTo((IMessage)new ColonyViewMessage(this, isNewSubscriber), player);
            }
        }
    }

    private void sendPermissionsPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.permissions.isDirty() || hasNewSubscribers) {
            this.subscribers.stream().filter(player -> this.permissions.isDirty() || !oldSubscribers.contains(player)).forEach(player -> {
                Permissions.Rank rank = this.getPermissions().getRank((EntityPlayer)player);
                MineColonies.getNetwork().sendTo((IMessage)new PermissionsMessage.View(this, rank), player);
            });
        }
    }

    private void sendWorkOrderPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.getWorkManager().isDirty() || hasNewSubscribers) {
            for (AbstractWorkOrder workOrder : this.getWorkManager().getWorkOrders().values()) {
                this.subscribers.stream().filter(player -> this.workManager.isDirty() || !oldSubscribers.contains(player)).forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewWorkOrderMessage(this, workOrder), player));
            }
            this.getWorkManager().setDirty(false);
        }
    }

    private void sendCitizenPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.isCitizensDirty || hasNewSubscribers) {
            for (CitizenData citizen : this.citizens.values()) {
                if (!citizen.isDirty() && !hasNewSubscribers) continue;
                this.subscribers.stream().filter(player -> citizen.isDirty() || !oldSubscribers.contains(player)).forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewCitizenViewMessage(this, citizen), player));
            }
        }
    }

    private void sendBuildingPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.isBuildingsDirty || hasNewSubscribers) {
            for (AbstractBuilding building : this.buildings.values()) {
                if (!building.isDirty() && !hasNewSubscribers) continue;
                this.subscribers.stream().filter(player -> building.isDirty() || !oldSubscribers.contains(player)).forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewBuildingViewMessage(building), player));
            }
        }
    }

    private void sendFieldPackets(boolean hasNewSubscribers) {
        if (this.isFieldsDirty && !this.isBuildingsDirty || hasNewSubscribers) {
            for (AbstractBuilding building : this.buildings.values()) {
                if (!(building instanceof BuildingFarmer)) continue;
                this.subscribers.forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewBuildingViewMessage(building), player));
            }
        }
    }

    @NotNull
    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        int stopAt;
        Object[] entries;
        Object obj;
        if (event.world != this.getWorld()) {
            throw new IllegalStateException("Colony's world does not match the event.");
        }
        if (event.phase == TickEvent.Phase.START) {
            this.citizens.values().stream().filter(ColonyUtils::isCitizenMissingFromWorld).forEach(CitizenData::clearCitizenEntity);
            if (event.world.getWorldTime() % 100L == 0L && this.areAllColonyChunksLoaded(event) && this.townHall != null) {
                this.citizens.values().forEach(this::spawnCitizenIfNull);
            }
            this.cleanUpBuildings(event);
            if (this.townHall != null && this.citizens.size() < this.maxCitizens) {
                int respawnInterval = Configurations.citizenRespawnInterval * 20;
                if (event.world.getWorldTime() % (long)(respawnInterval -= 60 * this.townHall.getBuildingLevel()) == 0L) {
                    this.spawnCitizen();
                }
            }
        }
        for (AbstractBuilding building : this.buildings.values()) {
            building.onWorldTick(event);
        }
        Random rand = new Random();
        if (rand.nextInt(100) <= 1 && this.wayPoints.size() > 0 && (obj = (entries = this.wayPoints.entrySet().toArray())[stopAt = rand.nextInt(entries.length)]) instanceof Map.Entry && ((Map.Entry)obj).getKey() instanceof BlockPos && ((Map.Entry)obj).getValue() instanceof IBlockState) {
            BlockPos key = (BlockPos)((Map.Entry)obj).getKey();
            IBlockState value = (IBlockState)((Map.Entry)obj).getValue();
            if (this.world != null && this.world.getBlockState(key).getBlock() != value.getBlock()) {
                this.wayPoints.remove(key);
            }
        }
        this.workManager.onWorldTick(event);
    }

    private boolean areAllColonyChunksLoaded(@NotNull TickEvent.WorldTickEvent event) {
        int distanceFromCenter = Configurations.workingRangeTownHall + 48 + 15;
        for (int x = -distanceFromCenter; x <= distanceFromCenter; x += 16) {
            for (int z = -distanceFromCenter; z <= distanceFromCenter; z += 16) {
                if (event.world.isBlockLoaded(new BlockPos(this.getCenter().getX() + x, 128, this.getCenter().getZ() + z))) continue;
                return false;
            }
        }
        return true;
    }

    private void cleanUpBuildings(@NotNull TickEvent.WorldTickEvent event) {
        ArrayList<AbstractBuilding> removedBuildings = new ArrayList<AbstractBuilding>();
        ArrayList<AbstractBuilding> tempBuildings = new ArrayList<AbstractBuilding>(this.buildings.values());
        for (AbstractBuilding building : tempBuildings) {
            BlockPos loc = building.getLocation();
            if (!event.world.isBlockLoaded(loc) || building.isMatchingBlock(event.world.getBlockState(loc).getBlock())) continue;
            removedBuildings.add(building);
        }
        removedBuildings.forEach(AbstractBuilding::destroy);
        ArrayList<Field> tempFields = new ArrayList<Field>(this.fields.values());
        for (Field field : tempFields) {
            if (!event.world.isBlockLoaded(field.getLocation())) continue;
            ScarecrowTileEntity scarecrow = (ScarecrowTileEntity)event.world.getTileEntity(field.getID());
            if (scarecrow == null) {
                this.fields.remove(field.getID());
                continue;
            }
            field.setInventoryField(scarecrow.getInventoryField());
        }
        this.markFieldsDirty();
    }

    private void spawnCitizen() {
        this.spawnCitizen(null);
    }

    private void spawnCitizenIfNull(@NotNull CitizenData data) {
        if (data.getCitizenEntity() == null) {
            Log.getLogger().warn(String.format("Citizen #%d:%d has gone AWOL, respawning them!", this.getID(), data.getId()));
            this.spawnCitizen(data);
        }
    }

    public void spawnCitizen(CitizenData data) {
        BlockPos townHallLocation = this.townHall.getLocation();
        if (!this.world.isBlockLoaded(townHallLocation)) {
            return;
        }
        BlockPos spawnPoint = EntityUtils.getSpawnPoint(this.world, townHallLocation);
        if (spawnPoint != null) {
            EntityCitizen entity = new EntityCitizen(this.world);
            CitizenData citizenData = data;
            if (citizenData == null) {
                for (int i = 1; i <= this.getMaxCitizens(); ++i) {
                    if (this.getCitizen(i) != null) continue;
                    this.topCitizenId = i;
                    break;
                }
                citizenData = new CitizenData(this.topCitizenId, this);
                citizenData.initializeFromEntity(entity);
                this.citizens.put(citizenData.getId(), citizenData);
                if (this.getMaxCitizens() == this.getCitizens().size()) {
                    LanguageHandler.sendPlayersMessage(this.getMessageEntityPlayers(), "tile.blockHutTownHall.messageMaxSize", new Object[0]);
                }
            }
            entity.setColony(this, citizenData);
            entity.setPosition((double)spawnPoint.getX() + 0.5, (double)spawnPoint.getY() + 0.1, (double)spawnPoint.getZ() + 0.5);
            this.world.spawnEntityInWorld((Entity)entity);
            this.checkAchievements();
            this.markCitizensDirty();
        }
    }

    private void checkAchievements() {
        int size = this.citizens.size();
        if (size >= 5) {
            this.triggerAchievement(ModAchievements.achievementSizeSettlement);
        }
        if (size >= 10) {
            this.triggerAchievement(ModAchievements.achievementSizeTown);
        }
        if (size >= 20) {
            this.triggerAchievement(ModAchievements.achievementSizeCity);
        }
        if (size >= 50) {
            this.triggerAchievement(ModAchievements.achievementSizeMetropolis);
        }
    }

    @Nullable
    public BuildingTownHall getTownHall() {
        return this.townHall;
    }

    @NotNull
    public Map<BlockPos, Field> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public Field getField(BlockPos fieldId) {
        return this.fields.get(fieldId);
    }

    @Nullable
    public Field getFreeField(String owner) {
        for (Field field : this.fields.values()) {
            if (field.isTaken()) continue;
            field.setTaken(true);
            field.setOwner(owner);
            this.markFieldsDirty();
            return field;
        }
        return null;
    }

    private void markFieldsDirty() {
        this.isFieldsDirty = true;
    }

    public AbstractBuilding getBuilding(BlockPos buildingId) {
        return this.buildings.get(buildingId);
    }

    @Nullable
    public <B extends AbstractBuilding> B getBuilding(BlockPos buildingId, @NotNull Class<B> type) {
        try {
            return (B)((AbstractBuilding)type.cast(this.buildings.get(buildingId)));
        }
        catch (ClassCastException e) {
            Log.getLogger().warn("getBuilding called with wrong type: ", (Throwable)e);
            return null;
        }
    }

    public void addNewField(ScarecrowTileEntity tileEntity, InventoryPlayer inventoryPlayer, BlockPos pos, World world) {
        Field field = new Field(tileEntity, inventoryPlayer, world, pos);
        field.setCustomName(LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user.noone", new Object[0])));
        this.addField(field);
        field.calculateSize(world, pos);
        this.markFieldsDirty();
    }

    @Nullable
    public AbstractBuilding addNewBuilding(@NotNull TileEntityColonyBuilding tileEntity) {
        tileEntity.setColony(this);
        AbstractBuilding building = AbstractBuilding.create(this, tileEntity);
        if (building != null) {
            this.addBuilding(building);
            tileEntity.setBuilding(building);
            Log.getLogger().info(String.format("Colony %d - new AbstractBuilding for %s at %s", this.getID(), tileEntity.getBlockType().getClass(), tileEntity.getPosition()));
            if (tileEntity.isMirrored()) {
                building.setMirror();
            }
            ConstructionTapeHelper.placeConstructionTape(building, this.world);
        } else {
            Log.getLogger().error(String.format("Colony %d unable to create AbstractBuilding for %s at %s", this.getID(), tileEntity.getBlockType().getClass(), tileEntity.getPosition()));
        }
        this.calculateMaxCitizens();
        ColonyManager.markDirty();
        return building;
    }

    public void calculateMaxCitizens() {
        int newMaxCitizens = 0;
        for (AbstractBuilding b : this.buildings.values()) {
            if (!(b instanceof BuildingHome) || b.getBuildingLevel() <= 0) continue;
            newMaxCitizens += ((BuildingHome)b).getMaxInhabitants();
        }
        if (this.maxCitizens != (newMaxCitizens = Math.max(Configurations.maxCitizens, newMaxCitizens))) {
            this.maxCitizens = newMaxCitizens;
            this.markDirty();
        }
    }

    public void removeBuilding(@NotNull AbstractBuilding building) {
        if (this.buildings.remove(building.getID()) != null) {
            for (EntityPlayerMP player : this.subscribers) {
                MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveBuildingMessage(this, building.getID()), player);
            }
            Log.getLogger().info(String.format("Colony %d - removed AbstractBuilding %s of type %s", this.getID(), building.getID(), building.getSchematicName()));
        }
        if (building instanceof BuildingTownHall) {
            this.townHall = null;
        }
        for (CitizenData citizen : this.citizens.values()) {
            citizen.onRemoveBuilding(building);
        }
        this.calculateMaxCitizens();
        ColonyManager.markDirty();
    }

    public boolean isManualHiring() {
        return this.manualHiring;
    }

    public void setManualHiring(boolean manualHiring) {
        this.manualHiring = manualHiring;
        this.markDirty();
    }

    public int getMaxCitizens() {
        return this.maxCitizens;
    }

    @NotNull
    public Map<Integer, CitizenData> getCitizens() {
        return Collections.unmodifiableMap(this.citizens);
    }

    public void removeCitizen(@NotNull CitizenData citizen) {
        this.citizens.remove(citizen.getId());
        for (AbstractBuilding building : this.buildings.values()) {
            building.removeCitizen(citizen);
        }
        this.workManager.clearWorkForCitizen(citizen);
        for (EntityPlayerMP player : this.subscribers) {
            MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveCitizenMessage(this, citizen.getId()), player);
        }
    }

    public void removeWorkOrder(int orderId) {
        for (EntityPlayerMP player : this.subscribers) {
            MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveWorkOrderMessage(this, orderId), player);
        }
    }

    public CitizenData getCitizen(int citizenId) {
        return this.citizens.get(citizenId);
    }

    @Nullable
    public CitizenData getJoblessCitizen() {
        for (CitizenData citizen : this.citizens.values()) {
            if (citizen.getWorkBuilding() != null) continue;
            return citizen;
        }
        return null;
    }

    public List<BlockPos> getDeliverymanRequired() {
        return this.citizens.values().stream().filter(citizen -> citizen.getWorkBuilding() != null && citizen.getJob() != null).filter(citizen -> !citizen.getJob().isMissingNeededItem()).map(citizen -> citizen.getWorkBuilding().getLocation()).collect(Collectors.toList());
    }

    public void onBuildingUpgradeComplete(@NotNull AbstractBuilding building, int level) {
        building.onUpgradeComplete(level);
    }

    @NotNull
    public List<EntityPlayer> getMessageEntityPlayers() {
        return ServerUtils.getPlayersFromUUID(this.world, this.getPermissions().getMessagePlayers());
    }

    @NotNull
    public List<Achievement> getAchievements() {
        return Collections.unmodifiableList(this.colonyAchievements);
    }

    public void removeField(BlockPos pos) {
        this.markFieldsDirty();
        this.fields.remove(pos);
    }

    public void addWayPoint(BlockPos point, IBlockState block) {
        this.wayPoints.put(point, block);
    }

    @NotNull
    public List<BlockPos> getWayPoints(@NotNull BlockPos position, @NotNull BlockPos target) {
        ArrayList<BlockPos> tempWayPoints = new ArrayList<BlockPos>();
        tempWayPoints.addAll(this.wayPoints.keySet());
        tempWayPoints.addAll(this.getBuildings().keySet());
        double maxX = Math.max(position.getX(), target.getX());
        double maxZ = Math.max(position.getZ(), target.getZ());
        double minX = Math.min(position.getX(), target.getX());
        double minZ = Math.min(position.getZ(), target.getZ());
        ArrayList wayPointsCopy = new ArrayList(tempWayPoints);
        for (BlockPos p : wayPointsCopy) {
            int x = p.getX();
            int z = p.getZ();
            if (!((double)x < minX || (double)x > maxX || (double)z < minZ) && !((double)z > maxZ)) continue;
            tempWayPoints.remove(p);
        }
        return tempWayPoints;
    }

    @NotNull
    public Map<BlockPos, AbstractBuilding> getBuildings() {
        return Collections.unmodifiableMap(this.buildings);
    }
}

