/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.colony.jobs.JobFisherman;
import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.colony.jobs.JobLumberjack;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.jobs.JobPlaceholder;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJob {
    private static final String TAG_TYPE = "type";
    private static final String TAG_ITEMS_NEEDED = "itemsNeeded";
    private static final String MAPPING_PLACEHOLDER = "Placeholder";
    private static final String MAPPING_BUILDER = "Builder";
    private static final String MAPPING_DELIVERY = "Deliveryman";
    private static final String MAPPING_MINER = "Miner";
    private static final String MAPPING_LUMBERJACK = "Lumberjack";
    private static final String MAPPING_FARMER = "Farmer";
    private static final String MAPPING_FISHERMAN = "Fisherman";
    private static final String MAPPING_TOWER_GUARD = "GuardTower";
    private static final int TASK_PRIORITY = 3;
    @NotNull
    private static final Map<String, Class<? extends AbstractJob>> nameToClassMap = new HashMap<String, Class<? extends AbstractJob>>();
    @NotNull
    private static final Map<Class<? extends AbstractJob>, String> classToNameMap = new HashMap<Class<? extends AbstractJob>, String>();
    private final CitizenData citizen;
    @NotNull
    private final List<ItemStack> itemsNeeded = new ArrayList<ItemStack>();
    private String nameTag = "";

    public AbstractJob(CitizenData entity) {
        this.citizen = entity;
    }

    private static void addMapping(String name, @NotNull Class<? extends AbstractJob> jobClass) {
        if (nameToClassMap.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding Job class mapping");
        }
        try {
            if (jobClass.getDeclaredConstructor(CitizenData.class) != null) {
                nameToClassMap.put(name, jobClass);
                classToNameMap.put(jobClass, name);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding Job class mapping", exception);
        }
    }

    @Nullable
    public static AbstractJob createFromNBT(CitizenData citizen, @NotNull NBTTagCompound compound) {
        AbstractJob job = null;
        Class<? extends AbstractJob> oclass = null;
        try {
            oclass = nameToClassMap.get(compound.getString(TAG_TYPE));
            if (oclass != null) {
                Constructor<? extends AbstractJob> constructor = oclass.getDeclaredConstructor(CitizenData.class);
                job = constructor.newInstance(citizen);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.getLogger().trace((Object)e);
        }
        if (job != null) {
            try {
                job.readFromNBT(compound);
            }
            catch (RuntimeException ex) {
                Log.getLogger().error(String.format("A Job %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.getString(TAG_TYPE), oclass.getName()), (Throwable)ex);
                job = null;
            }
        } else {
            Log.getLogger().warn(String.format("Unknown Job type '%s' or missing constructor of proper format.", compound.getString(TAG_TYPE)));
        }
        return job;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList itemsNeededTag = compound.getTagList(TAG_ITEMS_NEEDED, 10);
        for (int i = 0; i < itemsNeededTag.tagCount(); ++i) {
            NBTTagCompound itemCompound = itemsNeededTag.getCompoundTagAt(i);
            this.itemsNeeded.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)itemCompound));
        }
    }

    public abstract String getName();

    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.CITIZEN;
    }

    public CitizenData getCitizen() {
        return this.citizen;
    }

    public Colony getColony() {
        return this.citizen.getColony();
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        String s = classToNameMap.get(this.getClass());
        if (s == null) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compound.setString(TAG_TYPE, s);
        if (!this.itemsNeeded.isEmpty()) {
            NBTTagList itemsNeededTag = new NBTTagList();
            for (ItemStack itemstack : this.itemsNeeded) {
                NBTTagCompound itemCompound = new NBTTagCompound();
                itemstack.writeToNBT(itemCompound);
                itemsNeededTag.appendTag((NBTBase)itemCompound);
            }
            compound.setTag(TAG_ITEMS_NEEDED, (NBTBase)itemsNeededTag);
        }
    }

    public boolean isMissingNeededItem() {
        return !this.itemsNeeded.isEmpty();
    }

    @NotNull
    public List<ItemStack> getItemsNeeded() {
        return Collections.unmodifiableList(this.itemsNeeded);
    }

    public void clearItemsNeeded() {
        this.itemsNeeded.clear();
    }

    public void addItemNeeded(@NotNull ItemStack stack) {
        for (ItemStack neededItem : this.itemsNeeded) {
            if ((!stack.getItem().isDamageable() || stack.getItem() != neededItem.getItem()) && !stack.isItemEqual(neededItem)) continue;
            neededItem.stackSize += stack.stackSize;
            return;
        }
        this.itemsNeeded.add(stack);
    }

    @Nullable
    public ItemStack removeItemNeeded(@NotNull ItemStack stack) {
        ItemStack stackCopy = stack.copy();
        for (ItemStack neededItem : this.itemsNeeded) {
            if ((!stack.getItem().isDamageable() || stack.getItem() != neededItem.getItem()) && !stack.isItemEqual(neededItem)) continue;
            int itemsToRemove = Math.min(neededItem.stackSize, stackCopy.stackSize);
            neededItem.stackSize -= itemsToRemove;
            stackCopy.stackSize -= itemsToRemove;
            this.itemsNeeded.remove(neededItem);
            break;
        }
        return stackCopy.stackSize == 0 ? null : stackCopy;
    }

    public void addTasks(@NotNull EntityAITasks tasks) {
        AbstractAISkeleton<? extends AbstractJob> aiTask = this.generateAI();
        if (aiTask != null) {
            tasks.addTask(3, aiTask);
        }
    }

    public abstract AbstractAISkeleton<? extends AbstractJob> generateAI();

    public String getNameTagDescription() {
        return this.nameTag;
    }

    public final void setNameTag(String nameTag) {
        this.nameTag = nameTag;
    }

    public SoundEvent getBedTimeSound() {
        return null;
    }

    public SoundEvent getBadWeatherSound() {
        return null;
    }

    static {
        AbstractJob.addMapping(MAPPING_PLACEHOLDER, JobPlaceholder.class);
        AbstractJob.addMapping(MAPPING_BUILDER, JobBuilder.class);
        AbstractJob.addMapping(MAPPING_DELIVERY, JobDeliveryman.class);
        AbstractJob.addMapping(MAPPING_MINER, JobMiner.class);
        AbstractJob.addMapping(MAPPING_LUMBERJACK, JobLumberjack.class);
        AbstractJob.addMapping(MAPPING_FARMER, JobFarmer.class);
        AbstractJob.addMapping(MAPPING_FISHERMAN, JobFisherman.class);
        AbstractJob.addMapping(MAPPING_TOWER_GUARD, JobGuard.class);
    }
}

