/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuild
extends AbstractWorkOrder {
    private static final String TAG_BUILDING = "building";
    private static final String TAG_UPGRADE_LEVEL = "upgradeLevel";
    private static final String TAG_UPGRADE_NAME = "upgrade";
    private static final String TAG_IS_CLEARED = "cleared";
    private static final String TAG_IS_REQUESTED = "requested";
    private static final String TAG_IS_MIRRORED = "mirrored";
    private static final String TAG_SCHEMATIC_NAME = "structureName";
    private static final String TAG_BUILDING_ROTATION = "buildingRotation";
    private static final String DEFAULT_STYLE = "wooden";
    protected boolean isMirrored;
    protected BlockPos buildingLocation;
    protected int buildingRotation;
    protected String structureName;
    protected boolean cleared;
    private int upgradeLevel;
    private String upgradeName;
    private boolean hasSentMessageForThisWorkOrder = false;
    private boolean requested;

    public WorkOrderBuild() {
    }

    public WorkOrderBuild(@NotNull AbstractBuilding building, int level) {
        this.buildingLocation = building.getID();
        this.upgradeLevel = level;
        this.upgradeName = building.getSchematicName() + level;
        this.buildingRotation = building.getRotation();
        this.isMirrored = building.getTileEntity() == null ? building.isMirrored() : building.getTileEntity().isMirrored();
        this.cleared = level > 1;
        this.requested = false;
        if (MinecraftServer.class.getResourceAsStream("/assets/minecolonies/schematics/" + building.getStyle() + '/' + this.getUpgradeName() + ".nbt") == null) {
            Log.getLogger().warn(String.format("StructureProxy in Style (%s) does not exist - switching to wooden", building.getStyle()));
            this.structureName = "wooden/" + this.getUpgradeName();
            return;
        }
        this.structureName = building.getStyle() + '/' + this.getUpgradeName();
    }

    private String getUpgradeName() {
        return this.upgradeName;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.buildingLocation = BlockPosUtil.readFromNBT(compound, TAG_BUILDING);
        if (!(this instanceof WorkOrderBuildDecoration)) {
            this.upgradeLevel = compound.getInteger(TAG_UPGRADE_LEVEL);
            this.upgradeName = compound.getString(TAG_UPGRADE_NAME);
        }
        this.cleared = compound.getBoolean(TAG_IS_CLEARED);
        this.structureName = compound.getString(TAG_SCHEMATIC_NAME);
        this.buildingRotation = compound.getInteger(TAG_BUILDING_ROTATION);
        this.requested = compound.getBoolean(TAG_IS_REQUESTED);
        this.isMirrored = compound.getBoolean(TAG_IS_MIRRORED);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        BlockPosUtil.writeToNBT(compound, TAG_BUILDING, this.buildingLocation);
        if (!(this instanceof WorkOrderBuildDecoration)) {
            compound.setInteger(TAG_UPGRADE_LEVEL, this.upgradeLevel);
            compound.setString(TAG_UPGRADE_NAME, this.upgradeName);
        }
        compound.setBoolean(TAG_IS_CLEARED, this.cleared);
        compound.setString(TAG_SCHEMATIC_NAME, this.structureName);
        compound.setInteger(TAG_BUILDING_ROTATION, this.buildingRotation);
        compound.setBoolean(TAG_IS_REQUESTED, this.requested);
        compound.setBoolean(TAG_IS_MIRRORED, this.isMirrored);
    }

    @Override
    public boolean isValid(@NotNull Colony colony) {
        return colony.getBuilding(this.buildingLocation) != null;
    }

    @Override
    public void attemptToFulfill(@NotNull Colony colony) {
        boolean sendMessage = true;
        boolean hasBuilder = false;
        for (CitizenData citizen : colony.getCitizens().values()) {
            JobBuilder job = citizen.getJob(JobBuilder.class);
            if (job == null || citizen.getWorkBuilding() == null) continue;
            hasBuilder = true;
            int builderLevel = citizen.getWorkBuilding().getBuildingLevel();
            if (this.canBuildHut(builderLevel, citizen, colony)) {
                sendMessage = false;
            }
            if (job.hasWorkOrder() || !this.canBuildHut(builderLevel, citizen, colony)) continue;
            job.setWorkOrder(this);
            this.setClaimedBy(citizen);
            return;
        }
        this.sendBuilderMessage(colony, hasBuilder, sendMessage);
    }

    @Override
    @NotNull
    protected AbstractWorkOrder.WorkOrderType getType() {
        return AbstractWorkOrder.WorkOrderType.BUILD;
    }

    @Override
    protected String getValue() {
        return this.upgradeName;
    }

    private boolean canBuildHut(int builderLevel, @NotNull CitizenData citizen, @NotNull Colony colony) {
        return builderLevel >= this.upgradeLevel || builderLevel == 5 || citizen.getWorkBuilding() != null && citizen.getWorkBuilding().getID().equals((Object)this.buildingLocation) || WorkOrderBuild.isLocationTownhall(colony, this.buildingLocation);
    }

    private void sendBuilderMessage(@NotNull Colony colony, boolean hasBuilder, boolean sendMessage) {
        if (this.hasSentMessageForThisWorkOrder) {
            return;
        }
        if (hasBuilder && sendMessage) {
            this.hasSentMessageForThisWorkOrder = true;
            LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "entity.builder.messageBuilderNecessary", Integer.toString(this.upgradeLevel));
        }
        if (!hasBuilder) {
            this.hasSentMessageForThisWorkOrder = true;
            LanguageHandler.sendPlayersMessage(colony.getMessageEntityPlayers(), "entity.builder.messageNoBuilder", new Object[0]);
        }
    }

    private static boolean isLocationTownhall(@NotNull Colony colony, BlockPos buildingLocation) {
        return colony.hasTownHall() && colony.getTownHall() != null && colony.getTownHall().getID().equals((Object)buildingLocation);
    }

    public int getUpgradeLevel() {
        return this.upgradeLevel;
    }

    public BlockPos getBuildingLocation() {
        return this.buildingLocation;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public int getRotation() {
        return this.buildingRotation;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public void setCleared(boolean cleared) {
        this.cleared = cleared;
    }

    public boolean isRequested() {
        return this.requested;
    }

    public void setRequested(boolean requested) {
        this.requested = requested;
    }

    public boolean isMirrored() {
        return this.isMirrored;
    }
}

