/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.compatibility.Compatibility;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.MathUtils;
import com.minecolonies.coremod.util.Utils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIInteract<J extends AbstractJob>
extends AbstractEntityAICrafting<J> {
    private static final double XP_PER_BLOCK = 0.05;
    private static final double LEVEL_MODIFIER = 0.85;
    private static final int HAND_MINING_MODIFIER = 10;
    private static final int MIN_WORKING_RANGE = 12;

    public AbstractEntityAIInteract(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget[0]);
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine) {
        return this.mineBlock(blockToMine, new BlockPos((int)this.worker.posX, (int)this.worker.posY, (int)this.worker.posZ));
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        IBlockState curBlockState = this.world.getBlockState(blockToMine);
        Block curBlock = curBlockState.getBlock();
        if (curBlock == null || curBlock.equals(Blocks.AIR) || BlockUtils.shouldNeverBeMessedWith(curBlock)) {
            if (curBlock != null && curBlockState.getMaterial().isLiquid()) {
                this.world.setBlockToAir(blockToMine);
            }
            return true;
        }
        if (this.checkMiningLocation(blockToMine, safeStand)) {
            return false;
        }
        ItemStack tool = this.worker.getHeldItemMainhand();
        int fortune = Utils.getFortuneOf(tool);
        List<ItemStack> items = BlockPosUtil.getBlockDrops(this.world, blockToMine, fortune);
        this.triggerMinedBlock(blockToMine);
        this.worker.breakBlockWithToolInHand(blockToMine);
        for (ItemStack item : items) {
            InventoryUtils.setStack(this.worker.getInventoryCitizen(), item);
        }
        if (tool != null) {
            tool.getItem().onUpdate(tool, this.world, (Entity)this.worker, this.worker.findFirstSlotInInventoryWith(tool.getItem(), tool.getItemDamage()), true);
        }
        this.worker.addExperience(0.05);
        this.incrementActionsDone();
        return true;
    }

    private void triggerMinedBlock(@NotNull BlockPos blockToMine) {
        if (this.world.getBlockState(blockToMine).getBlock() == Blocks.COAL_ORE || this.world.getBlockState(blockToMine).getBlock() == Blocks.IRON_ORE || this.world.getBlockState(blockToMine).getBlock() == Blocks.LAPIS_ORE || this.world.getBlockState(blockToMine).getBlock() == Blocks.GOLD_ORE || this.world.getBlockState(blockToMine).getBlock() == Blocks.REDSTONE_ORE || this.world.getBlockState(blockToMine).getBlock() == Blocks.EMERALD_ORE) {
            this.getOwnBuilding().getColony().incrementStatistic("ores");
        }
        if (this.world.getBlockState(blockToMine).getBlock().equals(Blocks.DIAMOND_ORE)) {
            this.getOwnBuilding().getColony().incrementStatistic("diamonds");
        }
        if (this.world.getBlockState(blockToMine).getBlock().equals(Blocks.CARROTS)) {
            this.getOwnBuilding().getColony().incrementStatistic("carrots");
        }
        if (this.world.getBlockState(blockToMine).getBlock().equals(Blocks.POTATOES)) {
            this.getOwnBuilding().getColony().incrementStatistic("potatoes");
        }
        if (this.world.getBlockState(blockToMine).getBlock().equals(Blocks.WHEAT)) {
            this.getOwnBuilding().getColony().incrementStatistic("wheat");
        }
    }

    private boolean checkMiningLocation(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        Block curBlock = this.world.getBlockState(blockToMine).getBlock();
        if (!this.holdEfficientTool(curBlock)) {
            return true;
        }
        ItemStack tool = this.worker.getHeldItemMainhand();
        if (!(tool == null || ForgeHooks.canToolHarvestBlock((IBlockAccess)this.world, (BlockPos)blockToMine, (ItemStack)tool) || curBlock == Blocks.BEDROCK || Compatibility.isSlimeBlock(curBlock) || Compatibility.isSlimeLeaf(curBlock))) {
            Log.getLogger().info(String.format("ForgeHook not in sync with EfficientTool for %s and %s\nPlease report to MineColonies with this text to add support!", curBlock, tool));
        }
        if (this.walkToBlock(safeStand) && MathUtils.twoDimDistance(this.worker.getPosition(), safeStand) > 12.0) {
            return true;
        }
        this.currentWorkingLocation = blockToMine;
        this.currentStandingLocation = safeStand;
        return this.hasNotDelayed(this.getBlockMiningDelay(curBlock, blockToMine));
    }

    private int getBlockMiningDelay(@NotNull Block block, @NotNull BlockPos pos) {
        if (this.worker.getHeldItemMainhand() == null) {
            return (int)this.world.getBlockState(pos).getBlockHardness(this.world, pos);
        }
        return (int)((double)Configurations.blockMiningDelayModifier * Math.pow(0.85, this.worker.getLevel()) * (double)this.world.getBlockState(pos).getBlockHardness(this.world, pos) / (double)this.worker.getHeldItemMainhand().getItem().getStrVsBlock(this.worker.getHeldItemMainhand(), block.getDefaultState()));
    }
}

