/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingGuardTower;
import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIGuard
extends AbstractEntityAISkill<JobGuard> {
    public static final int PATROL_DISTANCE = 40;
    public static final int FOLLOW_RANGE = 10;
    protected static final int START_SEARCH_DISTANCE = 5;
    private static final double MAX_ATTACK_DISTANCE = 20.0;
    private static final int BASE_DELAY = 1;
    private static final int BASE_MAX_ATTACKS = 25;
    private static final double HEIGHT_DETECTION_RANGE = 10.0;
    private static final int PATH_CLOSE = 2;
    private static final double RANGE_HORIZONTAL_PICKUP = 20.0;
    private static final double RANGE_VERTICAL_PICKUP = 2.0;
    private static final int STUCK_WAIT_TICKS = 20;
    private static final int WAIT_WHILE_WALKING = 5;
    private static final int ITEM_PICKUP_RANGE = 3;
    private static final int DUMP_BASE = 20;
    private static final int ADDITIONAL_MAX_ATTACKS_PER_LEVEL = 5;
    protected EntityLivingBase targetEntity;
    protected int attacksExecuted = 0;
    protected int currentSearchDistance = 5;
    private int dumpAfterActions = 20;
    private BlockPos currentPathTarget;
    private List<Entity> entityList;
    @Nullable
    private List<BlockPos> items;
    private int stillTicks = 0;
    private int previousIndex = 0;

    protected AbstractEntityAIGuard(@NotNull JobGuard job) {
        super(job);
        super.registerTargets(new AITarget(this::checkIfExecute, this::getState), new AITarget(AIState.IDLE, () -> AIState.START_WORKING), new AITarget(AIState.START_WORKING, () -> AIState.GUARD_RESTOCK), new AITarget(AIState.GUARD_GATHERING, this::gathering));
    }

    private boolean checkIfExecute() {
        AbstractBuildingWorker building = this.getOwnBuilding();
        if (!(building instanceof BuildingGuardTower)) {
            return true;
        }
        if (!((BuildingGuardTower)building).shallRetrieveOnLowHealth()) {
            return false;
        }
        if (this.worker.getHealth() > 2.0f) {
            return false;
        }
        this.worker.isWorkerAtSiteWithMove(building.getLocation(), 2);
        return true;
    }

    protected AIState goToBuilding() {
        if (this.walkToBuilding()) {
            return AIState.GUARD_RESTOCK;
        }
        AbstractBuildingWorker workBuilding = this.getOwnBuilding();
        if (workBuilding != null) {
            TileEntityColonyBuilding chest = workBuilding.getTileEntity();
            for (int i = 0; i < workBuilding.getTileEntity().getSizeInventory(); ++i) {
                int emptySlot;
                ItemStack stack = chest.getStackInSlot(i);
                if (stack == null) continue;
                if (stack.getItem() instanceof ItemArmor && this.worker.getItemStackFromSlot(((ItemArmor)stack.getItem()).armorType) == null && (emptySlot = this.worker.getInventoryCitizen().getFirstEmptySlot()) != -1) {
                    this.worker.getInventoryCitizen().setInventorySlotContents(emptySlot, stack);
                    chest.setInventorySlotContents(i, null);
                }
                this.dumpAfterActions = 20 * workBuilding.getBuildingLevel();
            }
        }
        this.attacksExecuted = 0;
        return AIState.GUARD_SEARCH_TARGET;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return this.dumpAfterActions;
    }

    @Override
    protected void updateRenderMetaData() {
        this.updateArmor();
    }

    protected void updateArmor() {
        this.worker.setItemStackToSlot(EntityEquipmentSlot.CHEST, null);
        this.worker.setItemStackToSlot(EntityEquipmentSlot.FEET, null);
        this.worker.setItemStackToSlot(EntityEquipmentSlot.HEAD, null);
        this.worker.setItemStackToSlot(EntityEquipmentSlot.LEGS, null);
        for (int i = 0; i < this.worker.getInventoryCitizen().getSizeInventory(); ++i) {
            ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(i);
            if (stack == null || stack.stackSize == 0) {
                this.worker.getInventoryCitizen().setInventorySlotContents(i, null);
                continue;
            }
            if (!(stack.getItem() instanceof ItemArmor) || this.worker.getItemStackFromSlot(((ItemArmor)stack.getItem()).armorType) != null) continue;
            this.worker.setItemStackToSlot(((ItemArmor)stack.getItem()).armorType, stack);
        }
    }

    protected AIState getTarget() {
        if (this.entityList.isEmpty()) {
            return AIState.GUARD_PATROL;
        }
        Entity entity = this.entityList.get(0);
        BlockPos buildingLocation = this.getOwnBuilding().getLocation();
        if (BlockPosUtil.getDistance2D(entity.getPosition(), buildingLocation) < (long)this.getPatrolDistance()) {
            if (entity instanceof EntityPlayer) {
                if (this.worker.getColony() != null && this.worker.getColony().getPermissions().hasPermission((EntityPlayer)entity, Permissions.Action.GUARDS_ATTACK)) {
                    this.targetEntity = (EntityLivingBase)entity;
                    this.worker.getNavigator().clearPathEntity();
                    return AIState.GUARD_HUNT_DOWN_TARGET;
                }
                this.entityList.remove(0);
                this.setDelay(1);
                return AIState.GUARD_GET_TARGET;
            }
            if (this.worker.getEntitySenses().canSee(entity) && this.entityList.get(0).isEntityAlive()) {
                this.worker.getNavigator().clearPathEntity();
                this.targetEntity = (EntityLivingBase)entity;
                return AIState.GUARD_HUNT_DOWN_TARGET;
            }
        }
        this.entityList.remove(0);
        this.setDelay(1);
        return AIState.GUARD_GET_TARGET;
    }

    private int getPatrolDistance() {
        return this.getOwnBuilding().getBuildingLevel() * 40;
    }

    protected AIState searchTarget() {
        this.entityList = this.worker.worldObj.getEntitiesWithinAABB(EntityMob.class, this.getTargetableArea(this.currentSearchDistance));
        this.entityList.addAll(this.worker.worldObj.getEntitiesWithinAABB(EntitySlime.class, this.getTargetableArea(this.currentSearchDistance)));
        this.entityList.addAll(this.worker.worldObj.getEntitiesWithinAABB(EntityPlayer.class, this.getTargetableArea(this.currentSearchDistance)));
        if (this.targetEntity != null && this.targetEntity.isEntityAlive() && this.worker.getEntitySenses().canSee((Entity)this.targetEntity)) {
            return AIState.GUARD_HUNT_DOWN_TARGET;
        }
        this.setDelay(1);
        if (this.entityList.isEmpty()) {
            if ((double)this.currentSearchDistance < this.getMaxVision()) {
                this.currentSearchDistance += 5;
            } else {
                this.currentSearchDistance = 5;
                return AIState.GUARD_PATROL;
            }
            return AIState.GUARD_SEARCH_TARGET;
        }
        return AIState.GUARD_GET_TARGET;
    }

    private AxisAlignedBB getTargetableArea(double range) {
        return this.worker.getEntityBoundingBox().expand(range, 10.0, range);
    }

    private double getMaxVision() {
        BuildingGuardTower guardTower = (BuildingGuardTower)this.worker.getWorkBuilding();
        return guardTower == null ? 0.0 : 20.0 + (double)guardTower.getBonusVision();
    }

    protected int getMaxAttacksUntilRestock() {
        BuildingGuardTower guardTower = (BuildingGuardTower)this.worker.getWorkBuilding();
        return guardTower == null ? 0 : 25 + guardTower.getBuildingLevel() * 5;
    }

    protected AIState patrol() {
        this.worker.setAIMoveSpeed(1.0f);
        AbstractBuildingWorker building = this.getOwnBuilding();
        if (building instanceof BuildingGuardTower) {
            if (this.currentPathTarget == null || BlockPosUtil.getDistance2D(building.getColony().getCenter(), this.currentPathTarget) > (long)(Configurations.workingRangeTownHall + Configurations.townHallPadding) || this.currentPathTarget.getY() < 2) {
                return this.getNextPatrollingTarget((BuildingGuardTower)building);
            }
            if (this.worker.isWorkerAtSiteWithMove(this.currentPathTarget, 2) || ((BuildingGuardTower)building).getTask().equals((Object)BuildingGuardTower.Task.FOLLOW)) {
                return this.getNextPatrollingTarget((BuildingGuardTower)building);
            }
        }
        return AIState.GUARD_SEARCH_TARGET;
    }

    private AIState getNextPatrollingTarget(BuildingGuardTower building) {
        if (building.shallPatrolManually() && building.getTask().equals((Object)BuildingGuardTower.Task.PATROL)) {
            BlockPos pos = building.getNextPatrolTarget(this.currentPathTarget);
            if (pos != null) {
                this.currentPathTarget = pos;
                return AIState.GUARD_SEARCH_TARGET;
            }
        } else {
            if (building.getTask().equals((Object)BuildingGuardTower.Task.GUARD)) {
                BlockPos pos = building.getGuardPos();
                if (pos == null) {
                    pos = building.getLocation();
                }
                this.currentPathTarget = pos;
                return AIState.GUARD_SEARCH_TARGET;
            }
            if (building.getTask().equals((Object)BuildingGuardTower.Task.FOLLOW)) {
                BlockPos pos = building.getPlayerToFollow();
                if (pos == null || BlockPosUtil.getDistance2D(pos, building.getColony().getCenter()) > (long)(Configurations.workingRangeTownHall + Configurations.townHallPadding)) {
                    EntityPlayer player;
                    if (pos != null) {
                        Log.getLogger().info((Object)BlockPosUtil.getDistance2D(pos, building.getColony().getCenter()));
                    }
                    if ((player = building.getPlayer()) != null) {
                        LanguageHandler.sendPlayerMessage(building.getPlayer(), "com.minecolonies.coremod.job.guard.switch", new Object[0]);
                    }
                    pos = building.getLocation();
                    building.setTask(BuildingGuardTower.Task.GUARD);
                }
                this.currentPathTarget = pos;
                return AIState.GUARD_SEARCH_TARGET;
            }
        }
        this.currentPathTarget = this.getRandomBuilding();
        return AIState.GUARD_SEARCH_TARGET;
    }

    private BlockPos getRandomBuilding() {
        int random;
        if (this.worker.getColony() == null || this.getOwnBuilding() == null) {
            return this.worker.getPosition();
        }
        Collection<AbstractBuilding> buildingList = this.worker.getColony().getBuildings().values();
        Object[] buildingArray = buildingList.toArray();
        AbstractBuilding building = (AbstractBuilding)buildingArray[random = this.worker.getRandom().nextInt(buildingArray.length)];
        if (building instanceof BuildingGuardTower || BlockPosUtil.getDistance2D(building.getLocation(), this.getOwnBuilding().getLocation()) > (long)this.getPatrolDistance()) {
            return this.getOwnBuilding().getLocation();
        }
        return building.getLocation();
    }

    public boolean shouldReturnToTarget(BlockPos target, double range) {
        AbstractBuildingWorker building = this.getOwnBuilding();
        if (this.currentPathTarget == null && building instanceof BuildingGuardTower) {
            this.getNextPatrollingTarget((BuildingGuardTower)building);
        }
        return building instanceof BuildingGuardTower && (double)BlockPosUtil.getDistance2D(target, this.currentPathTarget) > range;
    }

    protected void onKilledEntity(EntityLivingBase killedEntity) {
        Colony colony = this.getOwnBuilding().getColony();
        colony.incrementStatistic("mobs");
        this.incrementActionsDone();
        this.worker.getNavigator().clearPathEntity();
    }

    private AIState gathering() {
        if (this.items == null) {
            this.searchForItems();
        }
        if (!this.items.isEmpty()) {
            this.gatherItems();
            return this.getState();
        }
        this.items = null;
        return AIState.GUARD_PATROL;
    }

    private void searchForItems() {
        this.items = new ArrayList<BlockPos>();
        this.items = this.world.getEntitiesWithinAABB(EntityItem.class, this.worker.getEntityBoundingBox().expand(20.0, 2.0, 20.0)).stream().filter(item -> item != null && !item.isDead).map(BlockPosUtil::fromEntity).collect(Collectors.toList());
    }

    private void gatherItems() {
        this.worker.setCanPickUpLoot(true);
        if (this.worker.getNavigator().noPath()) {
            BlockPos pos = this.getAndRemoveClosestItem();
            this.worker.isWorkerAtSiteWithMove(pos, 3);
            return;
        }
        if (this.worker.getNavigator().getPath() == null) {
            this.setDelay(5);
            return;
        }
        int currentIndex = this.worker.getNavigator().getPath().getCurrentPathIndex();
        if (currentIndex != this.previousIndex) {
            this.stillTicks = 0;
            this.previousIndex = currentIndex;
            return;
        }
        ++this.stillTicks;
        if (this.stillTicks > 20) {
            this.worker.getNavigator().clearPathEntity();
        }
    }

    private BlockPos getAndRemoveClosestItem() {
        if (this.items == null) {
            return this.worker.getPosition();
        }
        int index = 0;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < this.items.size(); ++i) {
            double tempDistance = this.items.get(i).distanceSq((Vec3i)this.worker.getPosition());
            if (!(tempDistance < distance)) continue;
            index = i;
            distance = tempDistance;
        }
        return this.items.remove(index);
    }
}

