/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.Log;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class GuardArrow
extends EntityTippedArrow {
    private static final String TAG_COLONY = "colony";
    private Colony colony;

    public GuardArrow(World worldin) {
        super(worldin);
    }

    public GuardArrow(World worldIn, EntityCitizen shooter) {
        super(worldIn, (EntityLivingBase)shooter);
        this.colony = shooter.getColony();
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setInteger(TAG_COLONY, this.colony.getID());
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        int colonyID = compound.getInteger(TAG_COLONY);
        this.colony = ColonyManager.getColony(colonyID);
    }

    protected void arrowHit(EntityLivingBase targetEntity) {
        super.arrowHit(targetEntity);
        Log.getLogger().info("Arrow hit " + targetEntity + " with " + targetEntity.getHealth());
        if (targetEntity.getHealth() <= 0.0f) {
            if (targetEntity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)targetEntity;
                if (this.colony.getPermissions().isColonyMember(player)) {
                    this.colony.triggerAchievement(ModAchievements.achievementPlayerDeathGuard);
                }
            }
            this.colony.incrementStatistic("mobs");
        }
    }
}

