/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.lumberjack;

import com.minecolonies.compatibility.Compatibility;
import com.minecolonies.coremod.util.BlockPosUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tree {
    private static final String TAG_LOCATION = "Location";
    private static final String TAG_LOGS = "Logs";
    private static final String TAG_STUMPS = "Stumps";
    private static final String TAG_TOP_LOG = "topLog";
    private static final int NUMBER_OF_LEAVES = 3;
    private static final int LEAVES_WIDTH = 4;
    private static final int MAX_TREE_SIZE = 256;
    private BlockPos location;
    private BlockPos topLog;
    private LinkedList<BlockPos> woodBlocks;
    private LinkedList<BlockPos> leaves;
    private boolean isTree;
    private ArrayList<BlockPos> stumpLocations;
    private BlockPlanks.EnumType variant;

    private Tree() {
        this.isTree = true;
    }

    public Tree(@NotNull World world, @NotNull BlockPos log) {
        Block block = BlockPosUtil.getBlock(world, log);
        if (block.isWood((IBlockAccess)world, log) || Compatibility.isSlimeBlock(block)) {
            this.variant = block instanceof BlockOldLog ? (BlockPlanks.EnumType)world.getBlockState(log).getValue((IProperty)BlockOldLog.VARIANT) : (block instanceof BlockNewLog ? (BlockPlanks.EnumType)world.getBlockState(log).getValue((IProperty)BlockNewLog.VARIANT) : BlockPlanks.EnumType.OAK);
            this.woodBlocks = new LinkedList();
            this.leaves = new LinkedList();
            this.location = log;
            this.topLog = log;
            this.addAndSearch(world, log);
            this.addAndSearch(world);
            this.checkTree(world, this.topLog);
            this.stumpLocations = new ArrayList();
            this.woodBlocks.clear();
        }
    }

    public static boolean checkTree(@NotNull IBlockAccess world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        if (!block.isWood(world, pos) && !Compatibility.isSlimeBlock(block)) {
            return false;
        }
        Tuple<BlockPos, BlockPos> baseAndTOp = Tree.getBottomAndTopLog(world, pos, new LinkedList<BlockPos>(), null, null);
        BlockPos basePos = (BlockPos)baseAndTOp.getFirst();
        return world.getBlockState(basePos.down()).getMaterial().isSolid() && world.getBlockState(basePos.down()).getBlock() != Blocks.COBBLESTONE && Tree.hasEnoughLeaves(world, (BlockPos)baseAndTOp.getSecond());
    }

    @NotNull
    private static Tuple<BlockPos, BlockPos> getBottomAndTopLog(@NotNull IBlockAccess world, @NotNull BlockPos log, @NotNull LinkedList<BlockPos> woodenBlocks, BlockPos bottomLog, BlockPos topLog) {
        BlockPos top;
        BlockPos bottom = bottomLog == null ? log : bottomLog;
        BlockPos blockPos = top = topLog == null ? log : topLog;
        if (woodenBlocks.size() >= 256) {
            return new Tuple((Object)bottom, (Object)top);
        }
        if (log.getY() < bottom.getY()) {
            bottom = log;
        }
        if (log.getY() > top.getY()) {
            top = log;
        }
        woodenBlocks.add(log);
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos temp = log.add(x, y, z);
                    Block block = world.getBlockState(temp).getBlock();
                    if (!block.isWood(null, temp) && !Compatibility.isSlimeBlock(block) || woodenBlocks.contains(temp)) continue;
                    return Tree.getBottomAndTopLog(world, temp, woodenBlocks, bottom, top);
                }
            }
        }
        return new Tuple((Object)bottom, (Object)top);
    }

    private static boolean hasEnoughLeaves(@NotNull IBlockAccess world, BlockPos pos) {
        int leafCount = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -1; dy <= 1; ++dy) {
                    if (!world.getBlockState(pos.add(dx, dy, dz)).getMaterial().equals(Material.LEAVES) || ++leafCount < 3) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    public static Tree readFromNBT(@NotNull NBTTagCompound compound) {
        Tree tree = new Tree();
        tree.location = BlockPosUtil.readFromNBT(compound, TAG_LOCATION);
        tree.woodBlocks = new LinkedList();
        NBTTagList logs = compound.getTagList(TAG_LOGS, 10);
        for (int i = 0; i < logs.tagCount(); ++i) {
            tree.woodBlocks.add(BlockPosUtil.readFromNBTTagList(logs, i));
        }
        tree.stumpLocations = new ArrayList();
        NBTTagList stumps = compound.getTagList(TAG_STUMPS, 10);
        for (int i = 0; i < stumps.tagCount(); ++i) {
            tree.stumpLocations.add(BlockPosUtil.readFromNBTTagList(stumps, i));
        }
        tree.topLog = BlockPosUtil.readFromNBT(compound, TAG_TOP_LOG);
        return tree;
    }

    private void checkTree(@NotNull World world, @NotNull BlockPos topLog) {
        if (!world.getBlockState(new BlockPos(this.location.getX(), this.location.getY() - 1, this.location.getZ())).getMaterial().isSolid()) {
            return;
        }
        int leafCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    if (!world.getBlockState(new BlockPos(topLog.getX() + x, topLog.getY() + y, topLog.getZ() + z)).getMaterial().equals(Material.LEAVES) || ++leafCount < 3) continue;
                    this.isTree = true;
                    return;
                }
            }
        }
    }

    public void findLogs(@NotNull World world) {
        this.addAndSearch(world, this.location);
        Collections.sort(this.woodBlocks, (c1, c2) -> (int)(c1.distanceSq((Vec3i)this.location) - c2.distanceSq((Vec3i)this.location)));
        if (this.getStumpLocations().isEmpty()) {
            this.fillTreeStumps(this.location.getY());
        }
    }

    public void fillTreeStumps(int yLevel) {
        for (BlockPos pos : this.woodBlocks) {
            if (pos.getY() != yLevel) continue;
            this.stumpLocations.add(pos);
        }
    }

    private void addAndSearch(@NotNull World world, @NotNull BlockPos log) {
        if (this.woodBlocks.size() >= 256) {
            return;
        }
        if (log.getY() < this.location.getY()) {
            this.location = log;
        }
        if (log.getY() > this.topLog.getY()) {
            this.topLog = log;
        }
        this.woodBlocks.add(log);
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos temp = log.add(x, y, z);
                    Block block = BlockPosUtil.getBlock(world, temp);
                    if (!block.isWood(null, temp) && !Compatibility.isSlimeBlock(block) || this.woodBlocks.contains(temp)) continue;
                    this.addAndSearch(world, temp);
                }
            }
        }
    }

    private void addAndSearch(@NotNull World world) {
        int temp;
        int locXMin = this.location.getX() - 4;
        int locXMax = this.location.getX() + 4;
        int locYMin = this.location.getY() + 2;
        int locZMin = this.location.getZ() - 4;
        int locZMax = this.location.getZ() + 4;
        if (locXMin > locXMax) {
            temp = locXMax;
            locXMax = locXMin;
            locXMin = temp;
        }
        if (locZMin > locZMax) {
            temp = locZMax;
            locZMax = locZMin;
            locZMin = temp;
        }
        for (int locX = locXMin; locX <= locXMax; ++locX) {
            for (int locY = locYMin; locY <= 256; ++locY) {
                for (int locZ = locZMin; locZ <= locZMax; ++locZ) {
                    BlockPos leaf = new BlockPos(locX, locY, locZ);
                    if (world.getBlockState(leaf).getMaterial() != Material.LEAVES) continue;
                    this.leaves.add(leaf);
                }
            }
        }
    }

    public BlockPos pollNextLog() {
        return this.woodBlocks.pollLast();
    }

    public BlockPos pollNextLeaf() {
        return this.leaves.pollLast();
    }

    public BlockPos peekNextLog() {
        return this.woodBlocks.peekLast();
    }

    public BlockPos peekNextLeaf() {
        return this.leaves.peekLast();
    }

    public boolean hasLeaves() {
        return !this.leaves.isEmpty();
    }

    public boolean hasLogs() {
        return !this.woodBlocks.isEmpty();
    }

    @NotNull
    public List<BlockPos> getStumpLocations() {
        return new ArrayList<BlockPos>(this.stumpLocations);
    }

    public void removeStump(BlockPos pos) {
        this.stumpLocations.remove(pos);
    }

    public BlockPlanks.EnumType getVariant() {
        return this.variant;
    }

    public double squareDistance(@NotNull Tree other) {
        return this.getLocation().distanceSq((Vec3i)other.getLocation());
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(@Nullable Object tree) {
        return tree != null && tree.getClass() == this.getClass() && ((Tree)tree).getLocation().equals((Object)this.location);
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        if (!this.isTree) {
            return;
        }
        BlockPosUtil.writeToNBT(compound, TAG_LOCATION, this.location);
        NBTTagList logs = new NBTTagList();
        for (BlockPos log : this.woodBlocks) {
            BlockPosUtil.writeToNBTTagList(logs, log);
        }
        compound.setTag(TAG_LOGS, (NBTBase)logs);
        NBTTagList stumps = new NBTTagList();
        for (BlockPos stump : this.stumpLocations) {
            BlockPosUtil.writeToNBTTagList(stumps, stump);
        }
        compound.setTag(TAG_STUMPS, (NBTBase)stumps);
        BlockPosUtil.writeToNBT(compound, TAG_TOP_LOG, this.topLog);
    }
}

