/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.coremod.entity.EntityCitizen;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

public class EntityAICitizenWander
extends EntityAIBase {
    private final EntityCitizen citizen;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private final double speed;

    public EntityAICitizenWander(EntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        if (this.isToOld() || this.checkForRandom() || this.citizen.getDesiredActivity() == EntityCitizen.DesiredActivity.SLEEP) {
            return false;
        }
        Vec3d Vec3d2 = RandomPositionGenerator.findRandomTarget((EntityCreature)this.citizen, (int)10, (int)7);
        if (Vec3d2 == null) {
            return false;
        }
        Vec3d2 = new Vec3d(Vec3d2.xCoord, this.getValidHeight(Vec3d2), Vec3d2.zCoord);
        this.xPosition = Vec3d2.xCoord;
        this.yPosition = Vec3d2.yCoord;
        this.zPosition = Vec3d2.zCoord;
        return true;
    }

    private boolean isToOld() {
        return this.citizen.getAge() >= 100;
    }

    private boolean checkForRandom() {
        return this.citizen.getRNG().nextInt(120) != 0;
    }

    private double getValidHeight(@NotNull Vec3d position) {
        double returnHeight = position.yCoord;
        if (position.yCoord < 0.0) {
            returnHeight = 0.0;
        }
        while (returnHeight >= 1.0 && this.citizen.worldObj.isAirBlock(new BlockPos(MathHelper.floor_double((double)position.xCoord), (int)returnHeight, MathHelper.floor_double((double)position.zCoord)))) {
            returnHeight -= 1.0;
        }
        while (!this.citizen.worldObj.isAirBlock(new BlockPos(MathHelper.floor_double((double)position.xCoord), (int)returnHeight, MathHelper.floor_double((double)position.zCoord)))) {
            returnHeight += 1.0;
        }
        return returnHeight;
    }

    public boolean continueExecuting() {
        return !this.citizen.getNavigator().noPath();
    }

    public void startExecuting() {
        this.citizen.getNavigator().tryMoveToXYZ(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }
}

