/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIGateInteract
extends EntityAIBase {
    private static final int HEIGHT_TO_CHECK = 2;
    private static final int LENGTH_TO_CHECK = 2;
    private static final double HALF_BLOCK = 0.5;
    private static final double MIN_DISTANCE = 2.25;
    protected EntityLiving theEntity;
    protected BlockPos gatePosition = BlockPos.ORIGIN;
    @Nullable
    protected BlockFenceGate gateBlock;
    private boolean hasStoppedFenceInteraction;
    private double entityPositionX;
    private double entityPositionZ;

    public EntityAIGateInteract(@NotNull EntityLiving entityIn) {
        this.theEntity = entityIn;
        if (!(entityIn.getNavigator() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for DoorInteractGoal");
        }
    }

    public boolean shouldExecute() {
        return this.theEntity.isCollidedHorizontally && this.checkPath();
    }

    private boolean checkPath() {
        PathNavigateGround pathnavigateground = (PathNavigateGround)this.theEntity.getNavigator();
        Path path = pathnavigateground.getPath();
        return path != null && !path.isFinished() && pathnavigateground.getEnterDoors() && this.checkFenceGate(path);
    }

    private boolean checkFenceGate(@NotNull Path path) {
        int maxLengthToCheck = Math.min(path.getCurrentPathIndex() + 2, path.getCurrentPathLength());
        for (int i = 0; i < maxLengthToCheck; ++i) {
            PathPoint pathpoint = path.getPathPointFromIndex(i);
            for (int level = 0; level < 2; ++level) {
                this.gatePosition = new BlockPos(pathpoint.xCoord, pathpoint.yCoord + level, pathpoint.zCoord);
                if (!(this.theEntity.getDistanceSq((double)this.gatePosition.getX(), this.theEntity.posY, (double)this.gatePosition.getZ()) <= 2.25)) continue;
                this.gateBlock = this.getBlockFence(this.gatePosition);
                if (this.gateBlock == null) continue;
                return true;
            }
        }
        this.gatePosition = new BlockPos((Entity)this.theEntity).up();
        this.gateBlock = this.getBlockFence(this.gatePosition);
        return this.gateBlock != null;
    }

    private BlockFenceGate getBlockFence(@NotNull BlockPos pos) {
        IBlockState blockState = this.theEntity.worldObj.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!(block instanceof BlockFenceGate) || blockState.getMaterial() != Material.WOOD) {
            block = this.theEntity.worldObj.getBlockState(this.theEntity.getPosition()).getBlock();
            this.gatePosition = this.theEntity.getPosition();
        }
        return block instanceof BlockFenceGate && blockState.getMaterial() == Material.WOOD ? (BlockFenceGate)block : null;
    }

    public boolean continueExecuting() {
        return !this.hasStoppedFenceInteraction;
    }

    public void startExecuting() {
        this.hasStoppedFenceInteraction = false;
        this.entityPositionX = (double)this.gatePosition.getX() + 0.5 - this.theEntity.posX;
        this.entityPositionZ = (double)this.gatePosition.getZ() + 0.5 - this.theEntity.posZ;
    }

    public void updateTask() {
        double entityDistZ;
        double entityDistX = (double)this.gatePosition.getX() + 0.5 - this.theEntity.posX;
        double totalDist = this.entityPositionX * entityDistX + this.entityPositionZ * (entityDistZ = (double)this.gatePosition.getZ() + 0.5 - this.theEntity.posZ);
        if (totalDist < 0.0) {
            this.hasStoppedFenceInteraction = true;
        }
    }
}

