/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.coremod.entity.ai.minimal.EntityAIGateInteract;
import com.minecolonies.coremod.util.SoundUtils;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;

public class EntityAIOpenFenceGate
extends EntityAIGateInteract {
    private static final int TIME_TO_CLOSE_DOOR = 20;
    private final boolean closeDoor;
    private int closeDoorTemporisation;

    public EntityAIOpenFenceGate(@NotNull EntityLiving entityLivingIn, boolean shouldClose) {
        super(entityLivingIn);
        this.theEntity = entityLivingIn;
        this.closeDoor = shouldClose;
    }

    @Override
    public boolean continueExecuting() {
        return this.closeDoor && this.closeDoorTemporisation > 0 && super.continueExecuting();
    }

    @Override
    public void startExecuting() {
        this.closeDoorTemporisation = 20;
        this.toggleDoor(true);
    }

    private void toggleDoor(boolean open) {
        IBlockState iblockstate = this.theEntity.worldObj.getBlockState(this.gatePosition);
        if (iblockstate.getBlock() == this.gateBlock && (Boolean)iblockstate.getValue((IProperty)BlockFenceGate.OPEN) != open) {
            this.theEntity.worldObj.setBlockState(this.gatePosition, iblockstate.withProperty((IProperty)BlockFenceGate.OPEN, (Comparable)Boolean.valueOf(open)), 2);
            SoundEvent openCloseSound = open ? SoundEvents.BLOCK_FENCE_GATE_OPEN : SoundEvents.BLOCK_FENCE_GATE_CLOSE;
            SoundUtils.playSoundAtCitizen(this.theEntity.worldObj, this.gatePosition, openCloseSound);
        }
    }

    @Override
    public void updateTask() {
        --this.closeDoorTemporisation;
        super.updateTask();
    }

    public void resetTask() {
        if (this.closeDoor) {
            this.toggleDoor(false);
        }
    }
}

