/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.coremod.blocks.BlockConstructionTape;
import com.minecolonies.coremod.blocks.BlockConstructionTapeCorner;
import com.minecolonies.coremod.blocks.BlockHutField;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.PathPointExtended;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPathJob
implements Callable<Path> {
    protected static final int DEBUG_VERBOSITY_NONE = 0;
    protected static final int DEBUG_VERBOSITY_BASIC = 1;
    protected static final int DEBUG_VERBOSITY_FULL = 2;
    protected static final Object debugNodeMonitor = new Object();
    private static final int SHIFT_SOUTH = 1;
    private static final int SHIFT_WEST = 2;
    private static final int SHIFT_NORTH = 3;
    private static final int SHIFT_EAST = 4;
    private static final BlockPos BLOCKPOS_IDENTITY = new BlockPos(0, 0, 0);
    private static final BlockPos BLOCKPOS_UP = new BlockPos(0, 1, 0);
    private static final BlockPos BLOCKPOS_DOWN = new BlockPos(0, -1, 0);
    private static final BlockPos BLOCKPOS_NORTH = new BlockPos(0, 0, -1);
    private static final BlockPos BLOCKPOS_SOUTH = new BlockPos(0, 0, 1);
    private static final BlockPos BLOCKPOS_EAST = new BlockPos(1, 0, 0);
    private static final BlockPos BLOCKPOS_WEST = new BlockPos(-1, 0, 0);
    private static final int MAX_Y = 256;
    private static final int MIN_Y = 0;
    private static final double JUMP_DROP_COST = 1.1;
    private static final double ON_PATH_COST = 0.75;
    private static final double SWIM_COST = 5.0;
    private static final double TOO_CLOSE_TO_FENCE = 0.1;
    private static final double TOO_FAR_FROM_FENCE = 0.9;
    private static final int SHIFT_X_BY = 20;
    private static final int SHIFT_Y_BY = 12;
    @Nullable
    protected static Set<Node> lastDebugNodesVisited;
    @Nullable
    protected static Set<Node> lastDebugNodesNotVisited;
    @Nullable
    protected static Set<Node> lastDebugNodesPath;
    @NotNull
    protected final BlockPos start;
    @NotNull
    protected final IBlockAccess world;
    protected final PathResult result;
    private final int maxRange;
    private final Queue<Node> nodesOpen = new PriorityQueue<Node>(500);
    private final Map<Integer, Node> nodesVisited = new HashMap<Integer, Node>();
    protected boolean debugDrawEnabled = false;
    protected int debugSleepMs = 0;
    @Nullable
    protected Set<Node> debugNodesVisited = null;
    @Nullable
    protected Set<Node> debugNodesNotVisited = null;
    @Nullable
    protected Set<Node> debugNodesPath = null;
    private boolean allowSwimming = true;
    private boolean allowJumpPointSearchTypeWalk = false;
    private int totalNodesAdded = 0;
    private int totalNodesVisited = 0;

    public AbstractPathJob(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range) {
        this(world, start, end, range, new PathResult());
    }

    public AbstractPathJob(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range, PathResult result) {
        int minX = Math.min(start.getX(), end.getX()) - range / 2;
        int minZ = Math.min(start.getZ(), end.getZ()) - range / 2;
        int maxX = Math.max(start.getX(), end.getX()) + range / 2;
        int maxZ = Math.max(start.getZ(), end.getZ()) + range / 2;
        this.world = new ChunkCache(world, new BlockPos(minX, 0, minZ), new BlockPos(maxX, 256, maxZ), range);
        this.start = new BlockPos((Vec3i)start);
        this.maxRange = range;
        this.result = result;
        this.allowJumpPointSearchTypeWalk = false;
        if (Configurations.pathfindingDebugDraw) {
            this.debugDrawEnabled = true;
            this.debugSleepMs = 0;
            this.debugNodesVisited = new HashSet<Node>();
            this.debugNodesNotVisited = new HashSet<Node>();
            this.debugNodesPath = new HashSet<Node>();
        }
    }

    private static boolean onLadderGoingUp(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        return currentNode.isLadder() && (dPos.getY() >= 0 || dPos.getX() != 0 || dPos.getZ() != 0);
    }

    public static BlockPos prepareStart(@NotNull EntityLiving entity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(MathHelper.floor_double((double)entity.posX), (int)entity.posY, MathHelper.floor_double((double)entity.posZ));
        IBlockState bs = entity.worldObj.getBlockState((BlockPos)pos);
        Block b = bs.getBlock();
        if (entity.isInWater()) {
            while (bs.getMaterial().isLiquid()) {
                pos.setPos(pos.getX(), pos.getY() + 1, pos.getZ());
                bs = entity.worldObj.getBlockState((BlockPos)pos);
            }
        } else if (b instanceof BlockFence || b instanceof BlockWall || b instanceof BlockHutField) {
            double dX = entity.posX - Math.floor(entity.posX);
            double dZ = entity.posZ - Math.floor(entity.posZ);
            if (dX < 0.1) {
                pos.setPos(pos.getX() - 1, pos.getY(), pos.getZ());
            } else if (dX > 0.9) {
                pos.setPos(pos.getX() + 1, pos.getY(), pos.getZ());
            }
            if (dZ < 0.1) {
                pos.setPos(pos.getX(), pos.getY(), pos.getZ() - 1);
            } else if (dZ > 0.9) {
                pos.setPos(pos.getX(), pos.getY(), pos.getZ() + 1);
            }
        }
        return pos.toImmutable();
    }

    private static void setLadderFacing(@NotNull IBlockAccess world, BlockPos pos, @NotNull PathPointExtended p) {
        if (world.getBlockState(pos).getBlock() instanceof BlockVine) {
            int meta = world.getBlockState(pos).getBlock().getMetaFromState(world.getBlockState(pos));
            if ((meta >>> 1 & 1) != 0) {
                p.setLadderFacing(EnumFacing.SOUTH);
            } else if ((meta >>> 2 & 1) != 0) {
                p.setLadderFacing(EnumFacing.WEST);
            } else if ((meta >>> 3 & 1) != 0) {
                p.setLadderFacing(EnumFacing.NORTH);
            } else if ((meta >>> 4 & 1) != 0) {
                p.setLadderFacing(EnumFacing.EAST);
            }
        } else {
            p.setLadderFacing((EnumFacing)world.getBlockState(pos).getValue((IProperty)BlockLadder.FACING));
        }
    }

    private static boolean onALadder(@NotNull Node node, @Nullable Node nextInPath, @NotNull BlockPos pos) {
        return nextInPath != null && node.isLadder() && nextInPath.pos.getX() == pos.getX() && nextInPath.pos.getZ() == pos.getZ();
    }

    private static int computeNodeKey(@NotNull BlockPos pos) {
        return (pos.getX() & 0xFFF) << 20 | (pos.getY() & 0xFF) << 12 | pos.getZ() & 0xFFF;
    }

    protected static double computeCost(@NotNull BlockPos dPos, boolean isSwimming, boolean onPath) {
        double cost = 1.0;
        if (dPos.getY() != 0 && (dPos.getX() != 0 || dPos.getZ() != 0)) {
            cost *= 1.1;
        }
        if (onPath) {
            cost *= 0.75;
        }
        if (isSwimming) {
            cost *= 5.0;
        }
        return cost;
    }

    private static boolean checkPreconditions(Node node, int newY) {
        if (AbstractPathJob.nodeClosed(node)) {
            return true;
        }
        return newY < 0;
    }

    private static boolean nodeClosed(@Nullable Node node) {
        return node != null && node.isClosed();
    }

    private static boolean calculateSwimming(@NotNull IBlockAccess world, @NotNull BlockPos pos, @Nullable Node node) {
        return node == null ? world.getBlockState(pos.down()).getMaterial().isLiquid() : node.isSwimming();
    }

    public PathResult getResult() {
        return this.result;
    }

    @Override
    public final Path call() {
        try {
            return this.search();
        }
        catch (RuntimeException e) {
            Log.getLogger().debug((Object)e);
            return null;
        }
    }

    @Nullable
    protected Path search() {
        Node bestNode = this.getAndSetupStartNode();
        double bestNodeResultScore = this.getNodeResultScore(bestNode);
        while (!this.nodesOpen.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Node currentNode = this.nodesOpen.poll();
            ++this.totalNodesVisited;
            currentNode.setCounterVisited(this.totalNodesVisited);
            this.handleDebugOptions(currentNode);
            if (this.isAtDestination(currentNode)) {
                bestNode = currentNode;
                this.result.setPathReachesDestination(true);
                break;
            }
            double nodeResultScore = this.getNodeResultScore(currentNode);
            if (nodeResultScore > bestNodeResultScore) {
                bestNode = currentNode;
                bestNodeResultScore = nodeResultScore;
            }
            if (currentNode.getSteps() <= this.maxRange) {
                this.walkCurrentNode(currentNode);
            }
            if (!this.doDebugSleep()) continue;
            return null;
        }
        Path path = this.finalizePath(bestNode);
        this.handleDebugDraw();
        return path;
    }

    private void handleDebugOptions(Node currentNode) {
        if (this.debugDrawEnabled) {
            this.addNodeToDebug(currentNode);
        }
        currentNode.setClosed();
        if (Configurations.pathfindingDebugVerbosity == 2) {
            Log.getLogger().info(String.format("Examining node [%d,%d,%d] ; g=%f ; f=%f", currentNode.pos.getX(), currentNode.pos.getY(), currentNode.pos.getZ(), currentNode.getCost(), currentNode.getScore()));
        }
    }

    private void addNodeToDebug(Node currentNode) {
        this.debugNodesNotVisited.remove(currentNode);
        this.debugNodesVisited.add(currentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDebugSleep() {
        if (this.debugDrawEnabled && this.debugSleepMs != 0) {
            Object object = debugNodeMonitor;
            synchronized (object) {
                lastDebugNodesNotVisited = new HashSet<Node>(this.debugNodesNotVisited);
                lastDebugNodesVisited = new HashSet<Node>(this.debugNodesVisited);
                lastDebugNodesPath = null;
            }
            if (this.debugSleepMs != 0) {
                try {
                    Thread.sleep(this.debugSleepMs);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return true;
                }
            }
        }
        return false;
    }

    private void walkCurrentNode(@NotNull Node currentNode) {
        BlockPos dPos = BLOCKPOS_IDENTITY;
        if (currentNode.parent != null) {
            dPos = currentNode.pos.subtract((Vec3i)currentNode.parent.pos);
        }
        if (AbstractPathJob.onLadderGoingUp(currentNode, dPos)) {
            this.walk(currentNode, BLOCKPOS_UP);
        }
        if (this.onLadderGoingDown(currentNode, dPos)) {
            this.walk(currentNode, BLOCKPOS_DOWN);
        }
        if (dPos.getZ() <= 0) {
            this.walk(currentNode, BLOCKPOS_NORTH);
        }
        if (dPos.getX() >= 0) {
            this.walk(currentNode, BLOCKPOS_EAST);
        }
        if (dPos.getZ() >= 0) {
            this.walk(currentNode, BLOCKPOS_SOUTH);
        }
        if (dPos.getX() <= 0) {
            this.walk(currentNode, BLOCKPOS_WEST);
        }
    }

    private boolean onLadderGoingDown(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        return (dPos.getY() <= 0 || dPos.getX() != 0 || dPos.getZ() != 0) && this.isLadder(currentNode.pos.down());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDebugDraw() {
        if (this.debugDrawEnabled) {
            Object object = debugNodeMonitor;
            synchronized (object) {
                lastDebugNodesNotVisited = this.debugNodesNotVisited;
                lastDebugNodesVisited = this.debugNodesVisited;
                lastDebugNodesPath = this.debugNodesPath;
            }
        }
    }

    @NotNull
    private Node getAndSetupStartNode() {
        Node startNode = new Node(this.start, this.computeHeuristic(this.start));
        if (this.isLadder(this.start)) {
            startNode.setLadder();
        } else if (this.world.getBlockState(this.start).getMaterial().isLiquid()) {
            startNode.setSwimming();
        }
        this.nodesOpen.offer(startNode);
        this.nodesVisited.put(AbstractPathJob.computeNodeKey(this.start), startNode);
        ++this.totalNodesAdded;
        return startNode;
    }

    @NotNull
    private Path finalizePath(Node targetNode) {
        int pathLength = 0;
        Node node = targetNode;
        while (node.parent != null) {
            ++pathLength;
            node = node.parent;
        }
        PathPoint[] points = new PathPoint[pathLength];
        Node nextInPath = null;
        node = targetNode;
        while (node.parent != null) {
            if (this.debugDrawEnabled) {
                this.addNodeToDebug(node);
            }
            --pathLength;
            BlockPos pos = node.pos;
            if (node.isSwimming()) {
                pos.add((Vec3i)BLOCKPOS_DOWN);
            }
            PathPointExtended p = new PathPointExtended(pos);
            if (nextInPath != null && AbstractPathJob.onALadder(node, nextInPath, pos)) {
                p.setOnLadder(true);
                if (nextInPath.pos.getY() > pos.getY()) {
                    AbstractPathJob.setLadderFacing(this.world, pos, p);
                }
            } else if (AbstractPathJob.onALadder(node.parent, node.parent, pos)) {
                p.setOnLadder(true);
            }
            points[pathLength] = p;
            nextInPath = node;
            node = node.parent;
        }
        this.doDebugPrinting(points);
        return new Path(points);
    }

    private void doDebugPrinting(@NotNull PathPoint[] points) {
        if (Configurations.pathfindingDebugVerbosity > 0) {
            Log.getLogger().info("Path found:");
            for (PathPoint p : points) {
                Log.getLogger().info(String.format("Step: [%d,%d,%d]", p.xCoord, p.yCoord, p.zCoord));
            }
            Log.getLogger().info(String.format("Total Nodes Visited %d / %d", this.totalNodesVisited, this.totalNodesAdded));
        }
    }

    protected abstract double computeHeuristic(BlockPos var1);

    protected abstract boolean isAtDestination(Node var1);

    protected abstract double getNodeResultScore(Node var1);

    protected final boolean walk(@NotNull Node parent, @NotNull BlockPos dPos) {
        int newY;
        BlockPos pos = parent.pos.add((Vec3i)dPos);
        int nodeKey = AbstractPathJob.computeNodeKey(pos);
        Node node = this.nodesVisited.get(nodeKey);
        if (AbstractPathJob.checkPreconditions(node, newY = this.getGroundHeight(parent, pos))) {
            return false;
        }
        if (pos.getY() != newY && AbstractPathJob.nodeClosed(node = this.nodesVisited.get(nodeKey = AbstractPathJob.computeNodeKey(pos = new BlockPos(pos.getX(), newY, pos.getZ()))))) {
            return false;
        }
        boolean isSwimming = AbstractPathJob.calculateSwimming(this.world, pos, node);
        boolean onRoad = BlockUtils.isPathBlock(this.world.getBlockState(pos).getBlock());
        double stepCost = AbstractPathJob.computeCost(dPos, isSwimming, onRoad);
        double heuristic = this.computeHeuristic(pos);
        double cost = parent.getCost() + stepCost;
        double score = cost + heuristic;
        if (node == null) {
            node = this.createNode(parent, pos, nodeKey, isSwimming, heuristic, cost, score);
        } else if (this.updateCurrentNode(parent, node, heuristic, cost, score)) {
            return false;
        }
        this.nodesOpen.offer(node);
        this.performJumpPointSearch(parent, dPos, node);
        return true;
    }

    private void performJumpPointSearch(@NotNull Node parent, @NotNull BlockPos dPos, @NotNull Node node) {
        if (this.allowJumpPointSearchTypeWalk && node.getHeuristic() <= parent.getHeuristic()) {
            this.walk(node, dPos);
        }
    }

    @NotNull
    private Node createNode(Node parent, @NotNull BlockPos pos, int nodeKey, boolean isSwimming, double heuristic, double cost, double score) {
        Node node = new Node(parent, pos, cost, heuristic, score);
        this.nodesVisited.put(nodeKey, node);
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.add(node);
        }
        if (this.isLadder(pos)) {
            node.setLadder();
        } else if (isSwimming) {
            node.setSwimming();
        }
        ++this.totalNodesAdded;
        node.setCounterAdded(this.totalNodesAdded);
        return node;
    }

    private boolean updateCurrentNode(@NotNull Node parent, @NotNull Node node, double heuristic, double cost, double score) {
        if (score >= node.getScore()) {
            return true;
        }
        if (!this.nodesOpen.remove(node)) {
            return true;
        }
        node.parent = parent;
        node.setSteps(parent.getSteps() + 1);
        node.setCost(cost);
        node.setHeuristic(heuristic);
        node.setScore(score);
        return false;
    }

    protected int getGroundHeight(Node parent, @NotNull BlockPos pos) {
        if (this.checkHeadBlock(parent, pos)) {
            return -1;
        }
        IBlockState target = this.world.getBlockState(pos);
        if (!this.isPassable(target)) {
            return this.handleTargeNotPassable(parent, pos, target);
        }
        IBlockState below = this.world.getBlockState(pos.down());
        SurfaceType walkability = this.isWalkableSurface(below);
        if (walkability == SurfaceType.WALKABLE) {
            return pos.getY();
        }
        if (walkability == SurfaceType.NOT_PASSABLE) {
            return -1;
        }
        return this.handleNotStanding(parent, pos, below);
    }

    private int handleNotStanding(@Nullable Node parent, @NotNull BlockPos pos, @NotNull IBlockState below) {
        boolean isSwimming;
        boolean bl = isSwimming = parent != null && parent.isSwimming();
        if (below.getMaterial().isLiquid()) {
            return this.handleInLiquid(pos, below, isSwimming);
        }
        if (this.isLadder(below.getBlock(), pos.down())) {
            return pos.getY();
        }
        return this.checkDrop(parent, pos, isSwimming);
    }

    private int checkDrop(@Nullable Node parent, @NotNull BlockPos pos, boolean isSwimming) {
        boolean canDrop;
        boolean bl = canDrop = parent != null && !parent.isLadder();
        if (!canDrop || isSwimming) {
            return -1;
        }
        BlockPos down = pos.down(2);
        IBlockState below = this.world.getBlockState(down);
        if (this.isWalkableSurface(below) == SurfaceType.WALKABLE) {
            return pos.getY() - 1;
        }
        return -1;
    }

    private int handleInLiquid(@NotNull BlockPos pos, @NotNull IBlockState below, boolean isSwimming) {
        if (isSwimming) {
            return pos.getY();
        }
        if (this.allowSwimming && below.getMaterial() == Material.WATER) {
            return pos.getY();
        }
        return -1;
    }

    private int handleTargeNotPassable(@Nullable Node parent, @NotNull BlockPos pos, @NotNull IBlockState target) {
        boolean canJump;
        boolean bl = canJump = parent != null && !parent.isLadder() && !parent.isSwimming();
        if (!canJump || this.isWalkableSurface(target) != SurfaceType.WALKABLE) {
            return -1;
        }
        if (!this.isPassable(pos.up(2))) {
            return -1;
        }
        if (!this.isPassable(parent.pos.up(2))) {
            return -1;
        }
        return pos.getY() + 1;
    }

    private boolean checkHeadBlock(@Nullable Node parent, @NotNull BlockPos pos) {
        IBlockState hereState;
        if (!this.isPassable(pos.up())) {
            return true;
        }
        return parent != null && (hereState = this.world.getBlockState(parent.pos.down())).getMaterial().isLiquid() && !this.isPassable(pos);
    }

    protected boolean isPassable(@NotNull IBlockState block) {
        if (block.getMaterial() != Material.AIR) {
            if (block.getMaterial().blocksMovement()) {
                return block.getBlock() instanceof BlockDoor || block.getBlock() instanceof BlockFenceGate || block.getBlock() instanceof BlockConstructionTape || block.getBlock() instanceof BlockConstructionTapeCorner;
            }
            if (block.getMaterial().isLiquid()) {
                return false;
            }
        }
        return true;
    }

    protected boolean isPassable(BlockPos pos) {
        return this.isPassable(this.world.getBlockState(pos));
    }

    @NotNull
    protected SurfaceType isWalkableSurface(@NotNull IBlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof BlockFence || block instanceof BlockFenceGate || block instanceof BlockWall || block instanceof BlockHutField) {
            return SurfaceType.NOT_PASSABLE;
        }
        if (block instanceof BlockConstructionTape || block instanceof BlockConstructionTapeCorner) {
            return SurfaceType.DROPABLE;
        }
        if (blockState.getMaterial().isSolid()) {
            return SurfaceType.WALKABLE;
        }
        return SurfaceType.DROPABLE;
    }

    protected boolean isLadder(@NotNull Block block, BlockPos pos) {
        return block.isLadder(this.world.getBlockState(pos), this.world, pos, null);
    }

    protected boolean isLadder(BlockPos pos) {
        return this.isLadder(this.world.getBlockState(pos).getBlock(), pos);
    }

    protected boolean isAllowedSwimming() {
        return this.allowSwimming;
    }

    protected void setAllowedSwimming(boolean allowSwimming) {
        this.allowSwimming = allowSwimming;
    }

    private static enum SurfaceType {
        WALKABLE,
        DROPABLE,
        NOT_PASSABLE;

    }
}

