/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.inventory;

import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.entity.EntityCitizen;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryCitizen
implements IInventory {
    private static final int INVENTORY_SIZE = 27;
    private static final int MAX_STACK_SIZE = 64;
    private static final String TAG_INVENTORY = "Inventory";
    private static final String TAG_CUSTOM_NAME = "CustomName";
    private static final String TAG_ITEMS = "Items";
    private static final String TAG_SLOT = "Slot";
    private static final int NO_SLOT = -1;
    private static final int HOTBAR_SIZE = 0;
    @NotNull
    private ItemStack[] stacks = new ItemStack[27];
    private String customName;
    private int heldItem;
    private boolean inventoryChanged = false;
    private EntityCitizen citizen;

    public InventoryCitizen(String title, boolean localeEnabled, EntityCitizen citizen) {
        this.citizen = citizen;
        if (localeEnabled) {
            this.customName = title;
        }
    }

    public InventoryCitizen(String title, boolean localeEnabled) {
        if (localeEnabled) {
            this.customName = title;
        }
    }

    public int getHotbarSize() {
        return 0;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public boolean hasInventoryChanged() {
        if (this.inventoryChanged) {
            this.inventoryChanged = false;
            return true;
        }
        return false;
    }

    public ItemStack getHeldItemMainhand() {
        return this.getStackInSlot(this.heldItem);
    }

    public void setHeldItem(int slot) {
        this.heldItem = slot;
    }

    public boolean consumeInventoryItem(Item itemIn) {
        int i = this.getInventorySlotContainItem(itemIn);
        if (i < 0) {
            return false;
        }
        --this.stacks[i].stackSize;
        if (this.stacks[i].stackSize <= 0) {
            this.stacks[i] = null;
        }
        return true;
    }

    private int getInventorySlotContainItem(Item itemIn) {
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null || this.stacks[i].getItem() != itemIn) continue;
            return i;
        }
        return -1;
    }

    public boolean addItemStackToInventory(@Nullable ItemStack itemStackIn) {
        if (itemStackIn != null && itemStackIn.stackSize != 0 && itemStackIn.getItem() != null) {
            try {
                int i;
                if (itemStackIn.isItemDamaged()) {
                    int j = this.getFirstEmptySlot();
                    if (j == -1) {
                        return false;
                    }
                    this.stacks[j] = ItemStack.copyItemStack((ItemStack)itemStackIn);
                    itemStackIn.stackSize = 0;
                    return true;
                }
                do {
                    i = itemStackIn.stackSize;
                    itemStackIn.stackSize = this.storePartialItemStack(itemStackIn);
                } while (itemStackIn.stackSize > 0 && itemStackIn.stackSize < i);
                return itemStackIn.stackSize < i;
            }
            catch (RuntimeException exp) {
                CrashReport crashreport = CrashReport.makeCrashReport((Throwable)exp, (String)"Adding item to inventory");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Item being added");
                crashreportcategory.addCrashSection("Item ID", (Object)Item.getIdFromItem((Item)itemStackIn.getItem()));
                crashreportcategory.addCrashSection("Item data", (Object)itemStackIn.getMetadata());
                try {
                    crashreportcategory.addCrashSection("Item name", (Object)itemStackIn.getDisplayName());
                }
                catch (RuntimeException e) {
                    crashreportcategory.addCrashSectionThrowable("Item name", (Throwable)e);
                }
                throw new ReportedException(crashreport);
            }
        }
        return false;
    }

    public int getFirstEmptySlot() {
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] != null) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(@NotNull ItemStack itemStackIn) {
        int i = itemStackIn.stackSize;
        int j = this.storeItemStack(itemStackIn);
        if (j < 0) {
            j = this.getFirstEmptySlot();
        }
        if (j < 0) {
            return i;
        }
        if (this.stacks[j] == null) {
            this.stacks[j] = itemStackIn.copy();
            this.stacks[j].stackSize = 0;
        }
        int k = i;
        if (i > this.stacks[j].getMaxStackSize() - this.stacks[j].stackSize) {
            k = this.stacks[j].getMaxStackSize() - this.stacks[j].stackSize;
        }
        if (k > this.getInventoryStackLimit() - this.stacks[j].stackSize) {
            k = this.getInventoryStackLimit() - this.stacks[j].stackSize;
        }
        if (k == 0) {
            return i;
        }
        this.stacks[j].stackSize += k;
        return i -= k;
    }

    private int storeItemStack(@NotNull ItemStack itemStackIn) {
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null || this.stacks[i].getItem() != itemStackIn.getItem() || !this.stacks[i].isStackable() || this.stacks[i].stackSize >= this.stacks[i].getMaxStackSize() || this.stacks[i].stackSize >= this.getInventoryStackLimit() || this.stacks[i].getHasSubtypes() && this.stacks[i].getMetadata() != itemStackIn.getMetadata() || !ItemStack.areItemStackTagsEqual((ItemStack)this.stacks[i], (ItemStack)itemStackIn)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasItem(Item itemIn) {
        return this.getInventorySlotContainItem(itemIn) != -1;
    }

    public int getHeldItemSlot() {
        return this.heldItem;
    }

    public boolean isSlotEmpty(int index) {
        return this.getStackInSlot(index) == null;
    }

    @NotNull
    public String getName() {
        return this.hasCustomName() ? this.customName : "citizen.inventory";
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.getTagList(TAG_ITEMS, 10);
        this.stacks = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
            int j = nbttagcompound.getByte(TAG_SLOT) & 0x7F;
            if (j == -1 || j >= this.stacks.length) continue;
            this.stacks[j] = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound);
        }
        if (compound.hasKey(TAG_CUSTOM_NAME, 8)) {
            this.customName = compound.getString(TAG_CUSTOM_NAME);
        }
    }

    public int getSizeInventory() {
        return 27;
    }

    public ItemStack getStackInSlot(int index) {
        return this.stacks[index];
    }

    @Nullable
    public ItemStack decrStackSize(int index, int count) {
        if (this.stacks[index] != null) {
            if (this.stacks[index].stackSize <= count) {
                ItemStack itemstack1 = this.stacks[index];
                this.stacks[index] = null;
                this.markDirty();
                if (index == this.heldItem) {
                    if (this.citizen != null) {
                        this.citizen.removeHeldItem();
                    }
                    this.heldItem = 0;
                }
                return itemstack1;
            }
            ItemStack itemstack = this.stacks[index].splitStack(count);
            if (this.stacks[index].stackSize == 0) {
                this.stacks[index] = null;
            }
            this.markDirty();
            return itemstack;
        }
        return null;
    }

    @Nullable
    public ItemStack removeStackFromSlot(int index) {
        if (this.stacks[index] == null) {
            return null;
        }
        ItemStack itemstack = this.stacks[index];
        this.stacks[index] = null;
        return itemstack;
    }

    public void setInventorySlotContents(int index, @Nullable ItemStack stack) {
        if (index == this.heldItem && stack == null) {
            if (this.citizen != null) {
                this.citizen.removeHeldItem();
            }
            this.heldItem = 0;
        }
        this.stacks[index] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        this.inventoryChanged = true;
        if (this.citizen != null) {
            this.citizen.onInventoryChanged();
        }
    }

    public boolean isUseableByPlayer(@NotNull EntityPlayer player) {
        return this.citizen.getColony().getPermissions().hasPermission(player, Permissions.Action.ACCESS_HUTS);
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public int getField(int id) {
        return 0;
    }

    @NotNull
    public ITextComponent getDisplayName() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        for (int i = 0; i < this.stacks.length; ++i) {
            this.stacks[i] = null;
        }
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte(TAG_SLOT, (byte)i);
            this.stacks[i].writeToNBT(nbttagcompound);
            nbttaglist.appendTag((NBTBase)nbttagcompound);
        }
        compound.setTag(TAG_ITEMS, (NBTBase)nbttaglist);
        if (this.hasCustomName()) {
            compound.setString(TAG_CUSTOM_NAME, this.customName);
        }
        compound.setTag(TAG_INVENTORY, (NBTBase)nbttaglist);
    }
}

