/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import com.minecolonies.coremod.util.LanguageHandler;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemCaliper
extends AbstractItemMinecolonies {
    private static final RangedAttribute ATTRIBUTE_CALIPER_USE = new RangedAttribute((IAttribute)null, "player.caliperUse", 0.0, 0.0, 1.0);
    private static final double HALF = 0.5;
    private static final String ITEM_CALIPER_MESSAGE_LINE = "item.caliper.message.line";
    private static final String ITEM_CALIPER_MESSAGE_SQUARE = "item.caliper.message.square";
    private static final String ITEM_CALIPER_MESSAGE_CUBE = "item.caliper.message.cube";
    private static final String ITEM_CALIPER_MESSAGE_SAME = "item.caliper.message.same";
    private BlockPos startPosition;

    public ItemCaliper() {
        super("caliper");
        super.setCreativeTab(ModCreativeTabs.MINECOLONIES);
        this.maxStackSize = 1;
    }

    private static EnumActionResult handleZEqual(@NotNull EntityPlayer playerIn, int a, int a2) {
        int distance1 = Math.abs(a) + 1;
        int distance2 = Math.abs(a2) + 1;
        LanguageHandler.sendPlayerMessage(playerIn, ITEM_CALIPER_MESSAGE_SQUARE, Integer.toString(distance1), Integer.toString(distance2));
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.isRemote) {
            return EnumActionResult.FAIL;
        }
        IAttributeInstance attribute = playerIn.getEntityAttribute((IAttribute)ATTRIBUTE_CALIPER_USE);
        if (attribute == null) {
            attribute = playerIn.getAttributeMap().registerAttribute((IAttribute)ATTRIBUTE_CALIPER_USE);
        }
        if (attribute.getAttributeValue() < 0.5) {
            this.startPosition = pos;
            attribute.setBaseValue(1.0);
            return EnumActionResult.SUCCESS;
        }
        attribute.setBaseValue(0.0);
        if (this.startPosition.getX() == pos.getX() && this.startPosition.getY() == pos.getY() && this.startPosition.getZ() == pos.getZ()) {
            LanguageHandler.sendPlayerMessage(playerIn, ITEM_CALIPER_MESSAGE_SAME, new Object[0]);
            return EnumActionResult.FAIL;
        }
        return this.handlePlayerMessage(playerIn, pos);
    }

    private EnumActionResult handlePlayerMessage(@NotNull EntityPlayer playerIn, @NotNull BlockPos pos) {
        if (this.startPosition.getX() == pos.getX()) {
            return this.handleXEqual(playerIn, pos);
        }
        if (this.startPosition.getY() == pos.getY()) {
            return this.handleYEqual(playerIn, pos, pos.getX() - this.startPosition.getX(), pos.getY() - this.startPosition.getZ());
        }
        if (this.startPosition.getZ() == pos.getZ()) {
            return ItemCaliper.handleZEqual(playerIn, pos.getX() - this.startPosition.getX(), pos.getY() - this.startPosition.getY());
        }
        int distance1 = Math.abs(pos.getX() - this.startPosition.getX()) + 1;
        int distance2 = Math.abs(pos.getY() - this.startPosition.getY()) + 1;
        int distance3 = Math.abs(pos.getZ() - this.startPosition.getZ()) + 1;
        LanguageHandler.sendPlayerMessage(playerIn, ITEM_CALIPER_MESSAGE_CUBE, Integer.toString(distance1), Integer.toString(distance2), Integer.toString(distance3));
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult handleYEqual(@NotNull EntityPlayer playerIn, @NotNull BlockPos pos, int a, int a2) {
        if (this.startPosition.getZ() == pos.getZ()) {
            int distance = Math.abs(a) + 1;
            LanguageHandler.sendPlayerMessage(playerIn, ITEM_CALIPER_MESSAGE_LINE, Integer.toString(distance));
            return EnumActionResult.SUCCESS;
        }
        return ItemCaliper.handleZEqual(playerIn, a, a2);
    }

    private EnumActionResult handleXEqual(@NotNull EntityPlayer playerIn, @NotNull BlockPos pos) {
        if (this.startPosition.getY() == pos.getY()) {
            int distance = Math.abs(pos.getZ() - this.startPosition.getZ()) + 1;
            LanguageHandler.sendPlayerMessage(playerIn, ITEM_CALIPER_MESSAGE_LINE, Integer.toString(distance));
            return EnumActionResult.SUCCESS;
        }
        return this.handleYEqual(playerIn, pos, pos.getY() - this.startPosition.getY(), pos.getZ() - this.startPosition.getZ());
    }
}

