/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockParticleEffectMessage
implements IMessage,
IMessageHandler<BlockParticleEffectMessage, IMessage> {
    public static final int BREAK_BLOCK = -1;
    private BlockPos pos;
    private Block block;
    private int metadata;
    private int side;

    public BlockParticleEffectMessage() {
    }

    public BlockParticleEffectMessage(BlockPos pos, @NotNull IBlockState state, int side) {
        this.pos = pos;
        this.block = state.getBlock();
        this.metadata = state.getBlock().getMetaFromState(state);
        this.side = side;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.pos = BlockPosUtil.readFromByteBuf(buf);
        this.block = Block.getBlockById((int)buf.readInt());
        this.metadata = buf.readInt();
        this.side = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        BlockPosUtil.writeToByteBuf(buf, this.pos);
        buf.writeInt(Block.getIdFromBlock((Block)this.block));
        buf.writeInt(this.metadata);
        buf.writeInt(this.side);
    }

    @Nullable
    public IMessage onMessage(@NotNull BlockParticleEffectMessage message, MessageContext ctx) {
        if (message.side == -1) {
            Minecraft.getMinecraft().effectRenderer.addBlockDestroyEffects(message.pos, message.block.getDefaultState());
        } else {
            FMLClientHandler.instance().getClient().effectRenderer.addBlockHitEffects(message.pos, EnumFacing.getFront((int)message.side));
        }
        return null;
    }
}

