/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.permissions;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.util.EntityUtils;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemPotion;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ColonyPermissionEventHandler {
    private final Colony colony;

    public ColonyPermissionEventHandler(Colony colony) {
        this.colony = colony;
    }

    @SubscribeEvent
    public void on(BlockEvent.PlaceEvent event) {
        if (Configurations.enableColonyProtection && this.checkBlockEventDenied(event.getWorld(), event.getPos(), event.getPlayer(), event.getPlacedBlock())) {
            ColonyPermissionEventHandler.cancelEvent((Event)event);
        }
    }

    private boolean checkBlockEventDenied(World worldIn, BlockPos posIn, EntityPlayer playerIn, IBlockState blockState) {
        EntityPlayer player = EntityUtils.getPlayerOfFakePlayer(playerIn, worldIn);
        if (this.colony.isCoordInColony(worldIn, posIn)) {
            if (!this.colony.getPermissions().isColonyMember(player)) {
                return true;
            }
            Permissions.Rank rank = this.colony.getPermissions().getRank(player);
            if (rank.ordinal() >= Permissions.Rank.FRIEND.ordinal()) {
                return true;
            }
            if (blockState.getBlock() instanceof AbstractBlockHut && rank.ordinal() >= Permissions.Rank.OFFICER.ordinal()) {
                return true;
            }
        }
        return false;
    }

    private static void cancelEvent(Event event) {
        event.setResult(Event.Result.DENY);
        if (event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void on(BlockEvent.BreakEvent event) {
        if (Configurations.enableColonyProtection && this.checkBlockEventDenied(event.getWorld(), event.getPos(), event.getPlayer(), event.getWorld().getBlockState(event.getPos()))) {
            ColonyPermissionEventHandler.cancelEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Detonate event) {
        if (!Configurations.enableColonyProtection || !Configurations.turnOffExplosionsInColonies) {
            return;
        }
        World eventWorld = event.getWorld();
        Predicate<BlockPos> getBlocksInColony = pos -> this.colony.isCoordInColony(eventWorld, (BlockPos)pos);
        Predicate<Entity> getEntitiesInColony = entity -> this.colony.isCoordInColony(entity.getEntityWorld(), entity.getPosition());
        List blocksToRemove = event.getAffectedBlocks().stream().filter(getBlocksInColony).collect(Collectors.toList());
        List entitiesToRemove = event.getAffectedEntities().stream().filter(getEntitiesInColony).collect(Collectors.toList());
        event.getAffectedBlocks().removeAll(blocksToRemove);
        event.getAffectedEntities().removeAll(entitiesToRemove);
    }

    @SubscribeEvent
    public void on(ExplosionEvent.Start event) {
        if (Configurations.enableColonyProtection && Configurations.turnOffExplosionsInColonies && this.colony.isCoordInColony(event.getWorld(), new BlockPos(event.getExplosion().getPosition()))) {
            ColonyPermissionEventHandler.cancelEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent event) {
        if (this.colony.isCoordInColony(event.getWorld(), event.getPos())) {
            Permissions.Rank rank;
            Block block = event.getWorld().getBlockState(event.getPos()).getBlock();
            if (block instanceof AbstractBlockHut && !this.colony.getPermissions().hasPermission(event.getEntityPlayer(), Permissions.Action.ACCESS_HUTS)) {
                ColonyPermissionEventHandler.cancelEvent((Event)event);
            }
            if (Configurations.enableColonyProtection && (event.getWorld().getBlockState(event.getPos()).getBlock() instanceof BlockContainer || event.getWorld().getTileEntity(event.getPos()) != null || event.getItemStack() != null && event.getItemStack().getItem() instanceof ItemPotion) && (rank = this.colony.getPermissions().getRank(event.getEntityPlayer())).ordinal() >= Permissions.Rank.FRIEND.ordinal()) {
                ColonyPermissionEventHandler.cancelEvent((Event)event);
            }
            EntityPlayer player = EntityUtils.getPlayerOfFakePlayer(event.getEntityPlayer(), event.getWorld());
            if (event.getItemStack() != null && event.getItemStack().getItem() instanceof ItemMonsterPlacer && !this.colony.getPermissions().hasPermission(player, Permissions.Action.PLACE_HUTS)) {
                ColonyPermissionEventHandler.cancelEvent((Event)event);
            }
        }
    }

    private void checkEventCancelation(Permissions.Rank rankIn, @NotNull EntityPlayer playerIn, @NotNull World world, @NotNull Event event) {
        Permissions.Rank rank;
        EntityPlayer player = EntityUtils.getPlayerOfFakePlayer(playerIn, world);
        if (Configurations.enableColonyProtection && this.colony.isCoordInColony(player.getEntityWorld(), player.getPosition()) && (rank = this.colony.getPermissions().getRank(player)).ordinal() >= rankIn.ordinal()) {
            ColonyPermissionEventHandler.cancelEvent(event);
        }
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteract event) {
        this.checkEventCancelation(Permissions.Rank.FRIEND, event.getEntityPlayer(), event.getWorld(), (Event)event);
    }

    @SubscribeEvent
    public void on(PlayerInteractEvent.EntityInteractSpecific event) {
        this.checkEventCancelation(Permissions.Rank.FRIEND, event.getEntityPlayer(), event.getWorld(), (Event)event);
    }

    @SubscribeEvent
    public void on(ItemTossEvent event) {
        this.checkEventCancelation(Permissions.Rank.NEUTRAL, event.getPlayer(), event.getPlayer().getEntityWorld(), (Event)event);
    }

    @SubscribeEvent
    public void on(EntityItemPickupEvent event) {
        this.checkEventCancelation(Permissions.Rank.FRIEND, event.getEntityPlayer(), event.getEntityPlayer().getEntityWorld(), (Event)event);
    }

    @SubscribeEvent
    public void on(FillBucketEvent event) {
        this.checkEventCancelation(Permissions.Rank.FRIEND, event.getEntityPlayer(), event.getEntityPlayer().getEntityWorld(), (Event)event);
    }

    @SubscribeEvent
    public void on(ArrowLooseEvent event) {
        this.checkEventCancelation(Permissions.Rank.FRIEND, event.getEntityPlayer(), event.getEntityPlayer().getEntityWorld(), (Event)event);
    }

    @SubscribeEvent
    public void on(AttackEntityEvent event) {
        if (event.getEntity() instanceof EntityMob) {
            return;
        }
        this.checkEventCancelation(Permissions.Rank.FRIEND, event.getEntityPlayer(), event.getEntityPlayer().getEntityWorld(), (Event)event);
    }
}

