/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.inventory.InventoryField;
import com.minecolonies.coremod.util.EntityUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ScarecrowTileEntity
extends TileEntityChest {
    private static final String TAG_TYPE = "type";
    private static final String TAG_NAME = "name";
    private final Random random = new Random();
    private InventoryField inventoryField;
    private ScareCrowType type;
    private String name = LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user", LanguageHandler.format("com.minecolonies.coremod.gui.scarecrow.user.noone", new Object[0]));

    public ScarecrowTileEntity() {
        this.inventoryField = new InventoryField(this.name);
    }

    public String getDesc() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull
    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new SPacketUpdateTileEntity(this.getPos(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, @NotNull SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public void onLoad() {
        Entity entity;
        super.onLoad();
        World world = this.getWorld();
        Colony colony = ColonyManager.getColony(world, this.pos);
        if (colony != null && colony.getField(this.pos) == null && (entity = EntityUtils.getEntityFromUUID(world, colony.getPermissions().getOwner())) instanceof EntityPlayer) {
            colony.addNewField(this, ((EntityPlayer)entity).inventory, this.pos, world);
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.type = ScareCrowType.values()[compound.getInteger(TAG_TYPE)];
        this.getInventoryField().readFromNBT(compound);
        this.name = compound.getString(TAG_NAME);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setInteger(TAG_TYPE, this.getType().ordinal());
        this.getInventoryField().writeToNBT(compound);
        compound.setString(TAG_NAME, this.name);
        return compound;
    }

    public ScareCrowType getType() {
        if (this.type == null) {
            this.type = ScareCrowType.values()[this.random.nextInt(2)];
        }
        return this.type;
    }

    public InventoryField getInventoryField() {
        return this.inventoryField;
    }

    public final void setInventoryField(InventoryField inventoryField) {
        this.inventoryField = inventoryField;
    }

    public static enum ScareCrowType {
        PUMPKINHEAD,
        NORMAL;

    }
}

