/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.MathUtils;
import com.minecolonies.coremod.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityUtils {
    private static final int DEFAULT_MOVE_RANGE = 3;
    private static final int AIR_SPACE_ABOVE_TO_CHECK = 2;
    private static final int TELEPORT_RANGE = 512;
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final int SCAN_RADIUS = 5;

    private EntityUtils() {
    }

    @NotNull
    public static EntityPlayer getPlayerOfFakePlayer(@NotNull EntityPlayer player, @NotNull World world) {
        EntityPlayer tempPlayer;
        if (player instanceof FakePlayer && (tempPlayer = world.getPlayerEntityByUUID(player.getUniqueID())) != null) {
            return tempPlayer;
        }
        return player;
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, int x, int y, int z) {
        return EntityUtils.isWorkerAtSiteWithMove(worker, x, y, z, 3);
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, int x, int y, int z, int range) {
        if (!EntityUtils.isWorkerAtSite(worker, x, y, z, 512)) {
            BlockPos spawnPoint = Utils.scanForBlockNearPoint(worker.getEntityWorld(), new BlockPos(x, y, z), 5, 5, 5, 2, new Block[]{Blocks.AIR, Blocks.SNOW_LAYER, Blocks.TALLGRASS, Blocks.RED_FLOWER, Blocks.YELLOW_FLOWER, Blocks.CARPET});
            worker.setLocationAndAngles((double)spawnPoint.getX() + 0.5, spawnPoint.getY(), (double)spawnPoint.getZ() + 0.5, worker.rotationYaw, worker.rotationPitch);
            return true;
        }
        if (!EntityUtils.isWorkerAtSite(worker, x, y, z, range)) {
            if (worker.getNavigator().noPath() && !EntityUtils.tryMoveLivingToXYZ((EntityLiving)worker, x, y, z)) {
                worker.setStatus(EntityCitizen.Status.PATHFINDING_ERROR);
            }
            return false;
        }
        return true;
    }

    public static boolean setSpawnPoint(@Nullable BlockPos spawnPoint, @NotNull EntityCitizen citizen) {
        if (spawnPoint == null) {
            return false;
        }
        citizen.setLocationAndAngles((double)spawnPoint.getX() + 0.5, spawnPoint.getY(), (double)spawnPoint.getZ() + 0.5, citizen.rotationYaw, citizen.rotationPitch);
        citizen.getNavigator().clearPathEntity();
        return true;
    }

    public static boolean isWorkerAtSite(@NotNull EntityCitizen worker, int x, int y, int z, int range) {
        return worker.getPosition().distanceSq(new Vec3i(x, y, z)) < MathUtils.square(range);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull EntityLiving living, int x, int y, int z) {
        return EntityUtils.tryMoveLivingToXYZ(living, x, y, z, 1.0);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull EntityLiving living, int x, int y, int z, double speed) {
        return living.getNavigator().tryMoveToXYZ((double)x, (double)y, (double)z, speed);
    }

    public static Entity getEntityFromUUID(@NotNull World world, @NotNull UUID id) {
        for (int i = 0; i < world.loadedEntityList.size(); ++i) {
            if (!id.equals(((Entity)world.loadedEntityList.get(i)).getUniqueID())) continue;
            return (Entity)world.loadedEntityList.get(i);
        }
        return null;
    }

    @NotNull
    public static List<Entity> getEntitiesFromUUID(@NotNull World world, @NotNull Collection<UUID> ids) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Object o : world.loadedEntityList) {
            Entity entity;
            if (!(o instanceof Entity) || !ids.contains((entity = (Entity)o).getUniqueID())) continue;
            entities.add(entity);
            if (entities.size() != ids.size()) continue;
            return entities;
        }
        return entities;
    }

    public static List<Entity> getEntitiesFromID(@NotNull World world, @NotNull List<Integer> ids) {
        return ids.stream().map(arg_0 -> ((World)world).getEntityByID(arg_0)).collect(Collectors.toList());
    }

    public static boolean isPathingTo(@NotNull EntityCitizen citizen, int x, int z) {
        PathPoint pathpoint = citizen.getNavigator().getPath().getFinalPathPoint();
        return pathpoint != null && pathpoint.xCoord == x && pathpoint.zCoord == z;
    }

    public static boolean checkForFreeSpace(@NotNull World world, @NotNull BlockPos groundPosition) {
        for (int i = 1; i < 2; ++i) {
            if (!EntityUtils.solidOrLiquid(world, groundPosition.up(i))) continue;
            return false;
        }
        return world.getBlockState(groundPosition).getMaterial().isSolid();
    }

    public static boolean solidOrLiquid(@NotNull World world, @NotNull BlockPos blockPos) {
        Material material = world.getBlockState(blockPos).getMaterial();
        return material.isSolid() || material.isLiquid();
    }

    @Nullable
    public static BlockPos getSpawnPoint(World world, BlockPos nearPoint) {
        return Utils.scanForBlockNearPoint(world, nearPoint, 1, 1, 1, 2, new Block[]{Blocks.AIR, Blocks.SNOW_LAYER, Blocks.TALLGRASS, Blocks.RED_FLOWER, Blocks.YELLOW_FLOWER, Blocks.CARPET});
    }
}

