/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.structures.helpers;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.structures.helpers.Structure;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Settings {
    public static final Settings instance = new Settings();
    private final BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
    public BlockPos pos = null;
    private boolean isMirrored = false;
    private boolean inHutMode = true;
    @Nullable
    private Structure structure = null;
    private int rotation = 0;
    private String hutDec = "";
    private String style = "";
    private int level = 0;
    private boolean isPendingReset = false;

    private Settings() {
    }

    public void moveTo(BlockPos pos) {
        if (this.structure == null) {
            return;
        }
        this.pos = this.pos.add((Vec3i)pos);
    }

    @Nullable
    public Structure getActiveStructure() {
        if (this.structure != null && this.structure.isTemplateMissing()) {
            this.structure = null;
        }
        return this.structure;
    }

    public void setActiveSchematic(Structure structure) {
        if (structure == null) {
            this.reset();
        } else {
            this.structure = structure;
        }
    }

    public void reset() {
        this.structure = null;
        this.isPendingReset = false;
        this.offset.setPos(0, 0, 0);
        this.rotation = 0;
        this.isMirrored = false;
    }

    public boolean isInHutMode() {
        return this.inHutMode;
    }

    public void setInHutMode(boolean mode) {
        this.inHutMode = mode;
    }

    public void setSchematicInfo(String hutDec, String style, int level, int rotation) {
        this.hutDec = hutDec;
        this.style = style;
        this.level = level;
        this.rotation = rotation;
    }

    public String getHutDec() {
        return this.hutDec;
    }

    public String getStyle() {
        return this.style;
    }

    public int getLevel() {
        return this.level;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void markDirty() {
        this.isPendingReset = true;
    }

    public boolean isDirty() {
        return this.isPendingReset;
    }

    @NotNull
    public BlockPos getOffset(PlacementSettings settings) {
        if (this.structure != null) {
            for (Template.BlockInfo info : this.structure.getBlockInfoWithSettings(settings)) {
                if (!(info.blockState.getBlock() instanceof AbstractBlockHut)) continue;
                this.offset.setPos((Vec3i)info.pos);
                return info.pos;
            }
        }
        return new BlockPos(0, 0, 0);
    }

    public void mirror() {
        if (this.structure == null) {
            return;
        }
        this.isMirrored = !this.isMirrored;
        this.structure.setPlacementSettings(this.structure.getSettings().setMirror(this.getMirror()));
    }

    public Mirror getMirror() {
        if (this.isMirrored) {
            return Mirror.FRONT_BACK;
        }
        return Mirror.NONE;
    }
}

