/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks;

import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockConstructionTapeCorner
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static final float BLOCK_HARDNESS = 0.0f;
    private static final String BLOCK_NAME = "blockConstructionTapeCorner";
    private static final float RESISTANCE = 0.0f;
    private static final double BOTTOM_COLLISION = 0.0;
    private static final double N_START_COLLISION_X = 0.0;
    private static final double N_END_COLLISION_X = 0.5625;
    private static final double N_START_COLLISION_Z = 0.0;
    private static final double N_END_COLLISION_Z = 0.5625;
    private static final double W_START_COLLISION_X = 0.0;
    private static final double W_END_COLLISION_X = 0.5625;
    private static final double W_START_COLLISION_Z = 0.4375;
    private static final double W_END_COLLISION_Z = 1.0;
    private static final double S_START_COLLISION_X = 0.4375;
    private static final double S_END_COLLISION_X = 1.0;
    private static final double S_START_COLLISION_Z = 0.4375;
    private static final double S_END_COLLISION_Z = 1.0;
    private static final double E_START_COLLISION_X = 0.4375;
    private static final double E_END_COLLISION_X = 1.0;
    private static final double E_START_COLLISION_Z = 0.0;
    private static final double E_END_COLLISION_Z = 0.5625;
    private static final double HEIGHT_COLLISION = 1.0;
    private static final int LIGHT_OPACITY = 0;

    public BlockConstructionTapeCorner() {
        super(Material.VINE);
        this.initBlock();
    }

    private void initBlock() {
        this.setRegistryName(BLOCK_NAME);
        this.setUnlocalizedName(String.format("%s.%s", "minecolonies".toLowerCase(), BLOCK_NAME));
        this.setCreativeTab(ModCreativeTabs.MINECOLONIES);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setHardness(0.0f);
        this.setResistance(0.0f);
        this.setLightOpacity(0);
        this.blockMaterial.setReplaceable();
    }

    @Nullable
    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @Deprecated
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, World worldIn, BlockPos pos) {
        return null;
    }

    public int getMetaFromState(@NotNull IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
    }

    @Deprecated
    @NotNull
    public IBlockState getStateFromMeta(int meta) {
        EnumFacing enumfacing = EnumFacing.getFront((int)meta);
        if (enumfacing.getAxis() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumfacing);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Deprecated
    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    @NotNull
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.SOLID;
    }

    @Deprecated
    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isPassable(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Deprecated
    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((EnumFacing)state.getValue((IProperty)FACING)).equals((Object)EnumFacing.NORTH)) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 0.5625);
        }
        if (((EnumFacing)state.getValue((IProperty)FACING)).equals((Object)EnumFacing.WEST)) {
            return new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 1.0);
        }
        if (((EnumFacing)state.getValue((IProperty)FACING)).equals((Object)EnumFacing.SOUTH)) {
            return new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 1.0);
        }
        return new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 0.5625);
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nullable EntityLivingBase placer) {
        EnumFacing enumFacing = placer == null ? EnumFacing.NORTH : EnumFacing.fromAngle((double)placer.rotationYaw);
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumFacing);
    }
}

