/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.EntityFishHook;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

public class RenderFishHook
extends Render<EntityFishHook> {
    private static final ResourceLocation texture = new ResourceLocation("textures/particle/particles.png");

    public RenderFishHook(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void doRender(@NotNull EntityFishHook entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.enableRescaleNormal();
        GlStateManager.scale((float)0.5f, (float)0.5f, (float)0.5f);
        this.bindEntityTexture(entity);
        Tessellator tessellator = Tessellator.getInstance();
        VertexBuffer vertexBuffer = tessellator.getBuffer();
        GlStateManager.rotate((float)((float)(180.0 - (double)this.renderManager.playerViewY)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)(-this.renderManager.playerViewX), (float)1.0f, (float)0.0f, (float)0.0f);
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION_TEX_NORMAL);
        vertexBuffer.pos(-0.5, -0.5, 0.0).tex(0.0625, 0.1875).normal(0.0f, 1.0f, 0.0f).endVertex();
        vertexBuffer.pos(0.5, -0.5, 0.0).tex(0.125, 0.1875).normal(0.0f, 1.0f, 0.0f).endVertex();
        vertexBuffer.pos(0.5, 0.5, 0.0).tex(0.125, 0.125).normal(0.0f, 1.0f, 0.0f).endVertex();
        vertexBuffer.pos(-0.5, 0.5, 0.0).tex(0.0625, 0.125).normal(0.0f, 1.0f, 0.0f).endVertex();
        tessellator.draw();
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        EntityCitizen citizen = entity.getCitizen();
        if (citizen == null) {
            for (Object citizenX : entity.worldObj.getEntitiesWithinAABB(EntityCitizen.class, entity.getEntityBoundingBox().expand(10.0, 10.0, 10.0))) {
                if (!((EntityCitizen)((Object)citizenX)).getModelID().textureBase.contains("Fisherman")) continue;
                citizen = (EntityCitizen)((Object)citizenX);
                break;
            }
        }
        if (citizen != null) {
            double orientation = citizen.getSwingProgress(partialTicks);
            double finalOrientation = Math.sin(Math.sqrt(orientation) * Math.PI);
            Vec3d Vec3d2 = new Vec3d(-0.36, 0.03, 0.35);
            Vec3d2.rotatePitch((float)(-((double)citizen.prevRotationPitch + ((double)citizen.rotationPitch - (double)citizen.prevRotationPitch) * (double)partialTicks) * Math.PI / 180.0));
            Vec3d2.rotateYaw((float)(-((double)citizen.prevRotationYaw + ((double)citizen.rotationYaw - (double)citizen.prevRotationYaw) * (double)partialTicks) * Math.PI / 180.0));
            Vec3d2.rotateYaw((float)(finalOrientation * 0.5));
            Vec3d2.rotatePitch((float)(-finalOrientation * 0.7));
            double thirdPersonOffset = ((double)citizen.prevRenderYawOffset + ((double)citizen.renderYawOffset - (double)citizen.prevRenderYawOffset) * (double)partialTicks) * Math.PI / 180.0;
            double correctedPosX = citizen.prevPosX + (citizen.posX - citizen.prevPosX) * (double)partialTicks - (double)MathHelper.cos((float)((float)thirdPersonOffset)) * 0.35 - (double)MathHelper.sin((float)((float)thirdPersonOffset)) * 0.8;
            double correctedPosY = citizen.prevPosY + (double)citizen.getEyeHeight() + (citizen.posY - citizen.prevPosY) * (double)partialTicks - 0.45;
            double correctedPosZ = citizen.prevPosZ + (citizen.posZ - citizen.prevPosZ) * (double)partialTicks - (double)MathHelper.sin((float)((float)thirdPersonOffset)) * 0.35 + (double)MathHelper.cos((float)((float)thirdPersonOffset)) * 0.8;
            double eyeHeight = citizen.isSneaking() ? -0.1875 : 0.0;
            double distX = entity.prevPosX + (entity.posX - entity.prevPosX) * (double)partialTicks;
            double distY = entity.posY + 0.25;
            double distZ = entity.prevPosZ + (entity.posZ - entity.prevPosZ) * (double)partialTicks;
            double correctionX = correctedPosX - distX;
            double correctionY = correctedPosY - distY + eyeHeight;
            double correctionZ = correctedPosZ - distZ;
            GlStateManager.disableTexture2D();
            GlStateManager.disableLighting();
            vertexBuffer.begin(3, DefaultVertexFormats.POSITION_COLOR);
            for (int l = 0; l <= 16; ++l) {
                double var = (double)l / 16.0;
                vertexBuffer.pos(x + correctionX * var, y + correctionY * (var * var + var) * 0.5 + 0.25, z + correctionZ * var).color(0, 0, 0, 255).endVertex();
            }
            tessellator.draw();
            GlStateManager.enableLighting();
            GlStateManager.enableTexture2D();
            super.doRender((Entity)entity, x, y, z, entityYaw, partialTicks);
        }
    }

    @NotNull
    protected ResourceLocation getEntityTexture(EntityFishHook entity) {
        return RenderFishHook.getTexture();
    }

    @NotNull
    private static ResourceLocation getTexture() {
        return texture;
    }
}

