/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.coremod.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenDataView {
    private final int id;
    private int entityId;
    private String name;
    private boolean female;
    private int level;
    private double experience;
    private double health;
    private double maxHealth;
    private int strength;
    private int endurance;
    private int charisma;
    private int intelligence;
    private int dexterity;
    private String job;
    @Nullable
    private BlockPos homeBuilding;
    @Nullable
    private BlockPos workBuilding;

    protected CitizenDataView(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFemale() {
        return this.female;
    }

    public int getLevel() {
        return this.level;
    }

    public double getExperience() {
        return this.experience;
    }

    public String getJob() {
        return this.job;
    }

    @Nullable
    public BlockPos getHomeBuilding() {
        return this.homeBuilding;
    }

    @Nullable
    public BlockPos getWorkBuilding() {
        return this.workBuilding;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getEndurance() {
        return this.endurance;
    }

    public int getCharisma() {
        return this.charisma;
    }

    public int getIntelligence() {
        return this.intelligence;
    }

    public int getDexterity() {
        return this.dexterity;
    }

    public double getHealth() {
        return this.health;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public void deserialize(@NotNull ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.female = buf.readBoolean();
        this.entityId = buf.readInt();
        this.homeBuilding = buf.readBoolean() ? BlockPosUtil.readFromByteBuf(buf) : null;
        this.workBuilding = buf.readBoolean() ? BlockPosUtil.readFromByteBuf(buf) : null;
        this.level = buf.readInt();
        this.experience = buf.readDouble();
        this.health = buf.readFloat();
        this.maxHealth = buf.readFloat();
        this.strength = buf.readInt();
        this.endurance = buf.readInt();
        this.charisma = buf.readInt();
        this.intelligence = buf.readInt();
        this.dexterity = buf.readInt();
        this.job = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }
}

