/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.EntityAIWorkLumberjack;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.Tree;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobLumberjack
extends AbstractJob {
    private static final String TAG_TREE = "Tree";
    @Nullable
    public Tree tree;

    public JobLumberjack(CitizenData entity) {
        super(entity);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.hasKey(TAG_TREE)) {
            this.tree = Tree.readFromNBT(compound.getCompoundTag(TAG_TREE));
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Lumberjack";
    }

    @Override
    @NotNull
    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.LUMBERJACK;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagCompound treeTag = new NBTTagCompound();
        if (this.tree != null) {
            this.tree.writeToNBT(treeTag);
        }
    }

    @NotNull
    public AbstractAISkeleton<JobLumberjack> generateAI() {
        return new EntityAIWorkLumberjack(this);
    }
}

