/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.WorkOrderView;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.util.Log;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWorkOrder {
    private static final String TAG_TYPE = "type";
    private static final String TAG_ID = "id";
    private static final String TAG_CLAIMED_BY = "claimedBy";
    @NotNull
    private static final Map<String, Class<? extends AbstractWorkOrder>> nameToClassMap = new HashMap<String, Class<? extends AbstractWorkOrder>>();
    @NotNull
    private static final Map<Class<? extends AbstractWorkOrder>, String> classToNameMap = new HashMap<Class<? extends AbstractWorkOrder>, String>();
    protected int id;
    private int claimedBy;
    private int priority;
    private boolean changed = false;

    private static void addMapping(String name, @NotNull Class<? extends AbstractWorkOrder> orderClass) {
        if (nameToClassMap.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding Work Order class mapping");
        }
        try {
            if (orderClass.getDeclaredConstructor(new Class[0]) != null) {
                nameToClassMap.put(name, orderClass);
                classToNameMap.put(orderClass, name);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding Work Order class mapping", exception);
        }
    }

    public static AbstractWorkOrder createFromNBT(@NotNull NBTTagCompound compound) {
        AbstractWorkOrder order = null;
        Class<? extends AbstractWorkOrder> oclass = null;
        try {
            oclass = nameToClassMap.get(compound.getString(TAG_TYPE));
            if (oclass != null) {
                Constructor<? extends AbstractWorkOrder> constructor = oclass.getDeclaredConstructor(new Class[0]);
                order = constructor.newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.getLogger().trace((Object)e);
        }
        if (order == null) {
            Log.getLogger().warn(String.format("Unknown WorkOrder type '%s' or missing constructor of proper format.", compound.getString(TAG_TYPE)));
            return null;
        }
        try {
            order.readFromNBT(compound);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A WorkOrder %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.getString(TAG_TYPE), oclass.getName()), (Throwable)ex);
            return null;
        }
        return order;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.id = compound.getInteger(TAG_ID);
        this.claimedBy = compound.getInteger(TAG_CLAIMED_BY);
    }

    @Nullable
    public static WorkOrderView createWorkOrderView(ByteBuf buf) {
        WorkOrderView workOrderView = new WorkOrderView();
        try {
            workOrderView.deserialize(buf);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A WorkOrder.View for #%d has thrown an exception during loading, its state cannot be restored. Report this to the mod author", workOrderView.getId()), (Throwable)ex);
            workOrderView = null;
        }
        return workOrderView;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void resetChange() {
        this.changed = false;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public boolean isClaimed() {
        return this.claimedBy != 0;
    }

    public boolean isClaimedBy(@NotNull CitizenData citizen) {
        return citizen.getId() == this.claimedBy;
    }

    public int getClaimedBy() {
        return this.claimedBy;
    }

    void setClaimedBy(@Nullable CitizenData citizen) {
        this.changed = true;
        this.claimedBy = citizen != null ? citizen.getId() : 0;
    }

    public void clearClaimedBy() {
        this.changed = true;
        this.claimedBy = 0;
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        String s = classToNameMap.get(this.getClass());
        if (s == null) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compound.setString(TAG_TYPE, s);
        compound.setInteger(TAG_ID, this.id);
        if (this.claimedBy != 0) {
            compound.setInteger(TAG_CLAIMED_BY, this.claimedBy);
        }
    }

    public boolean isValid(Colony colony) {
        return true;
    }

    public abstract void attemptToFulfill(Colony var1);

    public void serializeViewNetworkData(@NotNull ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.priority);
        buf.writeInt(this.claimedBy);
        buf.writeInt(this.getType().ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getValue());
    }

    @NotNull
    protected abstract WorkOrderType getType();

    protected abstract String getValue();

    static {
        AbstractWorkOrder.addMapping("build", WorkOrderBuild.class);
        AbstractWorkOrder.addMapping("decoration", WorkOrderBuildDecoration.class);
    }

    public static enum WorkOrderType {
        BUILD;

    }
}

