/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.commands.ISubCommand;
import com.minecolonies.coremod.configuration.Configurations;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSingleCommand
implements ISubCommand {
    private final String[] parents;
    public static final String NOT_PERMITTED = "You are not allowed to do that!";

    public AbstractSingleCommand(String ... parents) {
        this.parents = (String[])parents.clone();
    }

    public static int getIthArgument(String[] args, int i, int def) {
        if (args.length <= i) {
            return def;
        }
        try {
            return Integer.parseInt(args[i]);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        StringBuilder sb = new StringBuilder().append('/');
        for (String parent : this.parents) {
            sb.append(parent).append(' ');
        }
        return sb.toString();
    }

    public boolean canPlayerUseCommand(EntityPlayer player, Commands theCommand, int colonyId) {
        if (this.isPlayerOpped((ICommandSender)player, theCommand.toString())) {
            return true;
        }
        Colony chkColony = ColonyManager.getColony(colonyId);
        if (chkColony == null) {
            return false;
        }
        return this.canCommandSenderUseCommand(theCommand) && this.canRankUseCommand(chkColony, player);
    }

    public boolean canRankUseCommand(@NotNull Colony colony, @NotNull EntityPlayer player) {
        return colony.getPermissions().getRank(player).equals((Object)Permissions.Rank.OFFICER) || colony.getPermissions().getRank(player).equals((Object)Permissions.Rank.OWNER);
    }

    public boolean canCommandSenderUseCommand(Commands theCommand) {
        switch (theCommand) {
            case HOMETP: {
                return Configurations.canPlayerUseHomeTPCommand;
            }
            case COLONYTP: {
                return Configurations.canPlayerUseColonyTPCommand;
            }
            case RTP: {
                return Configurations.canPlayerUseRTPCommand;
            }
            case KILLCITIZENS: {
                return Configurations.canPlayerUseKillCitizensCommand;
            }
            case CITIZENINFO: {
                return Configurations.canPlayerUseCitizenInfoCommand;
            }
            case LISTCITIZENS: {
                return Configurations.canPlayerUseListCitizensCommand;
            }
            case RESPAWNCITIZENS: {
                return Configurations.canPlayerRespawnCitizensCommand;
            }
            case SHOWCOLONYINFO: {
                return Configurations.canPlayerUseShowColonyInfoCommand;
            }
            case ADDOFFICER: {
                return Configurations.canPlayerUseAddOfficerCommand;
            }
            case DELETECOLONY: {
                return Configurations.canPlayerUseDeleteColonyCommand;
            }
            case REFRESH_COLONY: {
                return Configurations.canPlayerUseRefreshColonyCommand;
            }
            case MC_BACKUP: {
                return Configurations.canPlayerUseBackupCommand;
            }
        }
        return false;
    }

    @NotNull
    public boolean isPlayerOpped(@NotNull ICommandSender sender, String cmdName) {
        if (sender instanceof EntityPlayer) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().getPlayerList().canSendCommands(((EntityPlayer)sender).getGameProfile());
        }
        return true;
    }

    static enum Commands {
        CITIZENINFO,
        COLONYTP,
        RTP,
        DELETECOLONY,
        KILLCITIZENS,
        LISTCITIZENS,
        RESPAWNCITIZENS,
        SHOWCOLONYINFO,
        ADDOFFICER,
        CHANGE_COLONY_OWNER,
        REFRESH_COLONY,
        HOMETP,
        MC_BACKUP;

    }
}

