/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.commands.ISubCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSplitCommand
implements ISubCommand {
    private final String[] parents;

    public AbstractSplitCommand(String ... parents) {
        this.parents = parents;
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        Map<String, ISubCommand> childs = this.getSubCommands();
        StringBuilder sb = new StringBuilder().append('/');
        for (String parent : this.parents) {
            sb.append(parent).append(' ');
        }
        sb.append('<');
        boolean first = true;
        for (String child : childs.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append('|');
            }
            sb.append(child);
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        Map<String, ISubCommand> childs = this.getSubCommands();
        if (args.length == 0 || !childs.containsKey(args[0])) {
            throw new CommandException(this.getCommandUsage(sender), new Object[0]);
        }
        ISubCommand child = childs.get(args[0]);
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        child.execute(server, sender, newArgs);
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        Map<String, ISubCommand> childs = this.getSubCommands();
        if (args.length <= 1 || !childs.containsKey(args[0])) {
            return new ArrayList<String>(childs.keySet());
        }
        ISubCommand child = childs.get(args[0]);
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        return child.getTabCompletionOptions(server, sender, newArgs, pos);
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        Map<String, ISubCommand> childs = this.getSubCommands();
        if (index == 0 || args.length == 0 || !childs.containsKey(args[0])) {
            return false;
        }
        ISubCommand child = childs.get(args[0]);
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        return child.isUsernameIndex(newArgs, index - 1);
    }

    public abstract Map<String, ISubCommand> getSubCommands();
}

