/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.util.TeleportToColony;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public final class ColonyTeleportCommand
extends AbstractSingleCommand {
    public static final String DESC = "teleport";

    public ColonyTeleportCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "colonytp" + "<colID>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        int colonyID;
        if (sender instanceof EntityPlayer && args.length == 1 && (colonyID = ColonyTeleportCommand.getIthArgument(args, 0, -1)) != -1 && this.canPlayerUseCommand((EntityPlayer)sender, AbstractSingleCommand.Commands.COLONYTP, colonyID)) {
            TeleportToColony.colonyTeleport(server, sender, args);
            return;
        }
        sender.getCommandSenderEntity().addChatMessage((ITextComponent)new TextComponentString("You are not allowed to do this"));
    }

    @Override
    public boolean canRankUseCommand(@NotNull Colony colony, @NotNull EntityPlayer player) {
        return colony.getPermissions().hasPermission(player, Permissions.Action.TELEPORT_TO_COLONY);
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return index == 0;
    }
}

