/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity;

import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.BuildingHome;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobFisherman;
import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.colony.jobs.JobLumberjack;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenAvoidEntity;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenWander;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIGoHome;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIOpenFenceGate;
import com.minecolonies.coremod.entity.ai.minimal.EntityAISleep;
import com.minecolonies.coremod.entity.pathfinding.PathNavigate;
import com.minecolonies.coremod.entity.pathfinding.WalkToProxy;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.network.messages.BlockParticleEffectMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.EntityUtils;
import com.minecolonies.coremod.util.ExperienceUtils;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.SoundUtils;
import com.minecolonies.coremod.util.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCitizen
extends EntityAgeable
implements INpc {
    private static final DataParameter<Integer> DATA_TEXTURE = EntityDataManager.createKey(EntityCitizen.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Integer> DATA_LEVEL = EntityDataManager.createKey(EntityCitizen.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Integer> DATA_IS_FEMALE = EntityDataManager.createKey(EntityCitizen.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Integer> DATA_COLONY_ID = EntityDataManager.createKey(EntityCitizen.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<Integer> DATA_CITIZEN_ID = EntityDataManager.createKey(EntityCitizen.class, (DataSerializer)DataSerializers.VARINT);
    private static final DataParameter<String> DATA_MODEL = EntityDataManager.createKey(EntityCitizen.class, (DataSerializer)DataSerializers.STRING);
    private static final DataParameter<String> DATA_RENDER_METADATA = EntityDataManager.createKey(EntityCitizen.class, (DataSerializer)DataSerializers.STRING);
    private static final int MOVE_AWAY_SPEED = 2;
    private static final int MOVE_AWAY_RANGE = 6;
    private static final int HEAL_CITIZENS_AFTER = 100;
    private static final String TAG_COLONY_ID = "colony";
    private static final String TAG_CITIZEN = "citizen";
    private static final String TAG_HELD_ITEM_SLOT = "HeldItemSlot";
    private static final String TAG_STATUS = "status";
    private static final String TAG_LAST_JOB = "lastJob";
    private static final float FACING_DELTA_YAW = 10.0f;
    private static final double BLOCK_BREAK_SOUND_RANGE = 16.0;
    private static final double BLOCK_BREAK_PARTICLE_RANGE = 16.0;
    private static final double EXP_DIVIDER = 100.0;
    private static final int RANT_ABOUT_WEATHER_CHANCE = 6000;
    private static final double MOVE_MINIMAL = 0.001;
    private static final double BASE_MAX_HEALTH = 20.0;
    public static final double BASE_MOVEMENT_SPEED = 0.3;
    private static final int BASE_PATHFINDING_RANGE = 100;
    private static final double CITIZEN_HEIGHT = 1.8;
    private static final double CITIZEN_WIDTH = 0.6;
    private static final double RENDER_DISTANCE_WEIGHT = 2.0;
    private static final int BONUS_BUILDING_LEVEL = 5;
    private static final double ROTATION_MOVEMENT = 30.0;
    private static final int TICKS_20 = 20;
    private static final int OFFSET_TICK_MULTIPLIER = 7;
    private static final double RANGE_TO_BE_HOME = 16.0;
    private String lastJob = "";
    private static final int MAX_STUCK_TIME = 2400;
    private static Field navigatorField;
    private final InventoryCitizen inventory;
    @NotNull
    private final Map<String, Integer> statusMessages = new HashMap<String, Integer>();
    private final PathNavigate newNavigator;
    protected Status status = Status.IDLE;
    private RenderBipedCitizen.Model modelId = RenderBipedCitizen.Model.SETTLER;
    private String renderMetadata;
    private ResourceLocation texture;
    private int colonyId;
    private int citizenId = 0;
    private int level;
    private int textureId;
    private WalkToProxy proxy;
    private double skillModifier = 0.0;
    private boolean female;
    @Nullable
    private Colony colony;
    @Nullable
    private CitizenData citizenData;
    private BlockPos currentPosition = null;
    private int stuckTime = 0;

    public EntityCitizen(World world) {
        super(world);
        this.setSize(0.6f, 1.8f);
        this.enablePersistence();
        this.setAlwaysRenderNameTag(Configurations.alwaysRenderNameTag);
        this.inventory = new InventoryCitizen("Minecolonies Inventory", false, this);
        this.newNavigator = new PathNavigate((EntityLiving)this, world);
        this.updateNavigatorField();
        if (world.isRemote) {
            EntityCitizen.setRenderDistanceWeight((double)2.0);
        }
        this.newNavigator.setCanSwim(true);
        this.newNavigator.setEnterDoors(true);
        this.initTasks();
    }

    private synchronized void updateNavigatorField() {
        if (navigatorField == null) {
            Field[] fields;
            for (Field field : fields = EntityLiving.class.getDeclaredFields()) {
                if (!field.getType().equals(net.minecraft.pathfinding.PathNavigate.class)) continue;
                field.setAccessible(true);
                navigatorField = field;
                break;
            }
        }
        if (navigatorField == null) {
            throw new IllegalStateException("Navigator field should not be null, contact developers.");
        }
        try {
            navigatorField.set((Object)this, (Object)this.newNavigator);
        }
        catch (IllegalAccessException e) {
            Log.getLogger().error("Navigator error", (Throwable)e);
        }
    }

    private void initTasks() {
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        if (this.getColonyJob() == null || !"com.minecolonies.coremod.job.Guard".equals(this.getColonyJob().getName())) {
            this.tasks.addTask(1, (EntityAIBase)new EntityAICitizenAvoidEntity(this, EntityMob.class, 8.0f, 0.6, 1.6));
        }
        this.tasks.addTask(2, (EntityAIBase)new EntityAIGoHome(this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAISleep(this));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIOpenFenceGate((EntityLiving)this, true));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityCitizen.class, 5.0f, 0.02f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAICitizenWander(this, 0.6));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 6.0f));
        this.onJobChanged(this.getColonyJob());
    }

    @Nullable
    public AbstractJob getColonyJob() {
        return this.citizenData == null ? null : this.citizenData.getJob();
    }

    public void onJobChanged(@Nullable AbstractJob job) {
        Object[] currentTasks;
        if (job == null) {
            switch (this.getLevel()) {
                case 1: {
                    this.modelId = RenderBipedCitizen.Model.CITIZEN;
                    break;
                }
                case 2: {
                    this.modelId = RenderBipedCitizen.Model.NOBLE;
                    break;
                }
                case 3: {
                    this.modelId = RenderBipedCitizen.Model.ARISTOCRAT;
                    break;
                }
                default: {
                    this.modelId = RenderBipedCitizen.Model.SETTLER;
                    break;
                }
            }
        } else {
            this.modelId = job.getModel();
        }
        this.dataManager.set(DATA_MODEL, (Object)this.modelId.name());
        this.setRenderMetadata("");
        for (Object task : currentTasks = this.tasks.taskEntries.toArray()) {
            if (!(((EntityAITasks.EntityAITaskEntry)task).action instanceof AbstractEntityAIInteract)) continue;
            this.tasks.removeTask(((EntityAITasks.EntityAITaskEntry)task).action);
        }
        if (job != null) {
            job.addTasks(this.tasks);
            if (this.ticksExisted > 0 && this.getWorkBuilding() != null) {
                BlockPosUtil.tryMoveLivingToXYZ((EntityLiving)this, this.getWorkBuilding().getLocation());
            }
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void onInventoryChanged() {
        AbstractBuildingWorker building = this.citizenData.getWorkBuilding();
        if (building != null) {
            building.markDirty();
        }
    }

    public void setRenderMetadata(String metadata) {
        this.renderMetadata = metadata;
        this.dataManager.set(DATA_RENDER_METADATA, (Object)this.renderMetadata);
        if (this.citizenData != null) {
            if (this.getColonyJob() != null && Configurations.enableInDevelopmentFeatures) {
                this.setCustomNameTag(this.citizenData.getName() + " (" + (Object)((Object)this.getStatus()) + ")[" + this.getColonyJob().getNameTagDescription() + "]");
            } else {
                this.setCustomNameTag(this.citizenData.getName());
            }
        }
    }

    @Nullable
    public AbstractBuildingWorker getWorkBuilding() {
        return this.citizenData == null ? null : this.citizenData.getWorkBuilding();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isWorkerAtSiteWithMove(@NotNull BlockPos site, int range) {
        if (this.proxy == null) {
            this.proxy = new WalkToProxy(this);
        }
        return this.proxy.walkToBlock(site, range, true);
    }

    @Nullable
    public <J extends AbstractJob> J getColonyJob(@NotNull Class<J> type) {
        return this.citizenData == null ? null : (J)this.citizenData.getJob(type);
    }

    public void faceBlock(@Nullable BlockPos block) {
        if (block == null) {
            return;
        }
        double xDifference = (double)block.getX() - this.posX;
        double zDifference = (double)block.getZ() - this.posZ;
        double yDifference = (double)block.getY() - (this.posY + (double)this.getEyeHeight());
        double squareDifference = Math.sqrt(xDifference * xDifference + zDifference * zDifference);
        double intendedRotationYaw = Math.atan2(zDifference, xDifference) * 180.0 / Math.PI - 90.0;
        double intendedRotationPitch = -(Math.atan2(yDifference, squareDifference) * 180.0 / Math.PI);
        this.setRotation((float)EntityCitizen.updateRotation(this.rotationYaw, intendedRotationYaw, 30.0), (float)EntityCitizen.updateRotation(this.rotationPitch, intendedRotationPitch, 30.0));
        double goToX = xDifference > 0.0 ? 0.001 : -0.001;
        double goToZ = zDifference > 0.0 ? 0.001 : -0.001;
        this.moveEntity(goToX, 0.0, goToZ);
    }

    private static double updateRotation(double currentRotation, double intendedRotation, double maxIncrement) {
        double wrappedAngle = MathHelper.wrapDegrees((double)(intendedRotation - currentRotation));
        if (wrappedAngle > maxIncrement) {
            wrappedAngle = maxIncrement;
        }
        if (wrappedAngle < -maxIncrement) {
            wrappedAngle = -maxIncrement;
        }
        return currentRotation + wrappedAngle;
    }

    public void gatherXp() {
        for (EntityXPOrb orb : this.getXPOrbsOnGrid()) {
            this.addExperience((double)orb.getXpValue() / 2.0);
            orb.setDead();
        }
    }

    private List<EntityXPOrb> getXPOrbsOnGrid() {
        AxisAlignedBB bb = new AxisAlignedBB(this.posX - 2.0, this.posY - 2.0, this.posZ - 2.0, this.posX + 2.0, this.posY + 2.0, this.posZ + 2.0);
        return this.worldObj.getEntitiesWithinAABB(EntityXPOrb.class, bb);
    }

    public void addExperience(double xp) {
        double citizenHutMaxLevel;
        double citizenHutLevel = this.getHomeBuilding() == null ? 0.0 : (double)this.getHomeBuilding().getBuildingLevel();
        double d = citizenHutMaxLevel = this.getHomeBuilding() == null ? 1.0 : (double)this.getHomeBuilding().getMaxBuildingLevel();
        if (citizenHutLevel < citizenHutMaxLevel && Math.pow(2.0, citizenHutLevel + 1.0) < (double)this.getExperienceLevel()) {
            return;
        }
        double maxValue = 2.147483647E9 - this.citizenData.getExperience();
        double localXp = xp * this.skillModifier / 100.0;
        double workBuildingLevel = this.getWorkBuilding() == null ? 0.0 : (double)this.getWorkBuilding().getBuildingLevel();
        double bonusXp = workBuildingLevel * (1.0 + citizenHutLevel) / Math.log((double)this.getExperienceLevel() + 2.0);
        if ((localXp *= bonusXp) > maxValue) {
            localXp = maxValue;
        }
        this.citizenData.addExperience(localXp);
        while (ExperienceUtils.getXPNeededForNextLevel(this.citizenData.getLevel()) < this.citizenData.getExperience()) {
            this.citizenData.increaseLevel();
        }
        this.updateLevel();
        this.citizenData.markDirty();
    }

    private BuildingHome getHomeBuilding() {
        return this.citizenData == null ? null : this.citizenData.getHomeBuilding();
    }

    public int getExperienceLevel() {
        return this.citizenData.getLevel();
    }

    private void updateLevel() {
        this.level = this.citizenData == null ? 0 : this.citizenData.getLevel();
        this.dataManager.set(DATA_LEVEL, (Object)this.level);
    }

    protected void updateFallState(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.onGround) {
            int px = MathHelper.floor_double((double)this.posX);
            int py = (int)this.posY;
            int pz = MathHelper.floor_double((double)this.posZ);
            this.onGround = this.worldObj.getBlockState(new BlockPos(px, py, pz)).getBlock().isLadder(this.worldObj.getBlockState(new BlockPos(px, py, pz)), (IBlockAccess)this.worldObj, new BlockPos(px, py, pz), (EntityLivingBase)this);
        }
        super.updateFallState(y, onGroundIn, state, pos);
    }

    public boolean attackEntityFrom(@NotNull DamageSource damageSource, float damage) {
        Entity sourceEntity = damageSource.getEntity();
        if (sourceEntity instanceof EntityCitizen && ((EntityCitizen)sourceEntity).colonyId == this.colonyId) {
            return false;
        }
        boolean result = super.attackEntityFrom(damageSource, damage);
        if (damageSource.isMagicDamage() || damageSource.isFireDamage()) {
            return result;
        }
        this.updateArmorDamage(damage);
        return result;
    }

    public void triggerDeathAchievement(DamageSource source, AbstractJob job) {
        if (job instanceof JobMiner) {
            if (source == DamageSource.lava || source == DamageSource.inFire || source == DamageSource.onFire) {
                this.getColony().triggerAchievement(ModAchievements.achievementMinerDeathLava);
            }
            if (source.equals(DamageSource.fall)) {
                this.getColony().triggerAchievement(ModAchievements.achievementMinerDeathFall);
            }
        }
        if (job instanceof JobLumberjack && source == DamageSource.inWall) {
            this.getColony().triggerAchievement(ModAchievements.achievementLumberjackDeathTree);
        }
        if (job instanceof JobFisherman && source.getEntity() instanceof EntityGuardian) {
            this.getColony().triggerAchievement(ModAchievements.achievementFisherDeathGuardian);
        }
        if (job instanceof JobGuard && source.getEntity() instanceof EntityEnderman) {
            this.getColony().triggerAchievement(ModAchievements.achievementGuardDeathEnderman);
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        this.dropExperience();
        this.setDead();
        if (this.colony != null) {
            this.triggerDeathAchievement(par1DamageSource, this.getColonyJob());
            if (this.getColonyJob() instanceof JobGuard) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "tile.blockHutTownHall.messageGuardDead", this.citizenData.getName(), (int)this.posX, (int)this.posY, (int)this.posZ);
            } else {
                LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "tile.blockHutTownHall.messageColonistDead", this.citizenData.getName(), (int)this.posX, (int)this.posY, (int)this.posZ);
            }
            this.colony.removeCitizen(this.getCitizenData());
        }
        super.onDeath(par1DamageSource);
    }

    private void dropExperience() {
        if (!this.worldObj.isRemote && this.recentlyHit > 0 && this.canDropLoot() && this.worldObj.getGameRules().getBoolean("doMobLoot")) {
            int j;
            for (int experience = (int)this.getExperiencePoints(); experience > 0; experience -= j) {
                j = EntityXPOrb.getXPSplit((int)experience);
                this.worldObj.spawnEntityInWorld((Entity)new EntityXPOrb(this.worldObj, this.posX, this.posY, this.posZ, j));
            }
        }
        for (int i = 0; i < 20; ++i) {
            double d2 = this.rand.nextGaussian() * 0.02;
            double d0 = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            this.worldObj.spawnParticle(EnumParticleTypes.EXPLOSION_LARGE, this.posX + this.rand.nextDouble() * (double)this.width * 2.0 - (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height, this.posZ + this.rand.nextDouble() * (double)this.width * 2.0 - (double)this.width, d2, d0, d1, new int[0]);
        }
    }

    @Nullable
    public CitizenData getCitizenData() {
        return this.citizenData;
    }

    private double getExperiencePoints() {
        return this.citizenData.getExperience();
    }

    private void updateArmorDamage(double damage) {
        for (ItemStack stack : this.getArmorInventoryList()) {
            if (stack == null || stack.getItem() == null || !(stack.getItem() instanceof ItemArmor)) continue;
            stack.damageItem((int)(damage / 2.0), (EntityLivingBase)this);
            if (stack.stackSize < 1) {
                this.setItemStackToSlot(EntityCitizen.getSlotForItemStack((ItemStack)stack), null);
            }
            this.setItemStackToSlot(EntityCitizen.getSlotForItemStack((ItemStack)stack), stack);
        }
    }

    public EntityAgeable createChild(EntityAgeable var1) {
        return null;
    }

    public boolean processInteract(@NotNull EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        CitizenDataView citizenDataView;
        ColonyView colonyView = ColonyManager.getColonyView(this.colonyId);
        if (colonyView != null && !colonyView.getPermissions().hasPermission(player, Permissions.Action.ACCESS_HUTS)) {
            return false;
        }
        if (this.worldObj.isRemote && (citizenDataView = this.getCitizenDataView()) != null) {
            MineColonies.proxy.showCitizenWindow(citizenDataView);
        }
        return true;
    }

    public void entityInit() {
        super.entityInit();
        this.dataManager.register(DATA_COLONY_ID, (Object)this.colonyId);
        this.dataManager.register(DATA_CITIZEN_ID, (Object)this.citizenId);
        this.dataManager.register(DATA_TEXTURE, (Object)0);
        this.dataManager.register(DATA_LEVEL, (Object)0);
        this.dataManager.register(DATA_IS_FEMALE, (Object)0);
        this.dataManager.register(DATA_MODEL, (Object)RenderBipedCitizen.Model.SETTLER.name());
        this.dataManager.register(DATA_RENDER_METADATA, (Object)"");
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        super.writeEntityToNBT(compound);
        compound.setInteger(TAG_STATUS, this.status.ordinal());
        if (this.colony != null && this.citizenData != null) {
            compound.setInteger(TAG_COLONY_ID, this.colony.getID());
            compound.setInteger(TAG_CITIZEN, this.citizenData.getId());
        }
        this.inventory.writeToNBT(compound);
        compound.setInteger(TAG_HELD_ITEM_SLOT, this.inventory.getHeldItemSlot());
        compound.setString(TAG_LAST_JOB, this.lastJob);
    }

    public void readEntityFromNBT(NBTTagCompound compound) {
        super.readEntityFromNBT(compound);
        this.status = Status.values()[compound.getInteger(TAG_STATUS)];
        this.colonyId = compound.getInteger(TAG_COLONY_ID);
        this.citizenId = compound.getInteger(TAG_CITIZEN);
        if (this.isServerWorld()) {
            this.updateColonyServer();
        }
        this.inventory.readFromNBT(compound);
        this.inventory.setHeldItem(compound.getInteger(TAG_HELD_ITEM_SLOT));
        this.lastJob = compound.getString(TAG_LAST_JOB);
    }

    public void onLivingUpdate() {
        if (this.recentlyHit > 0) {
            this.citizenData.markDirty();
        }
        if (this.worldObj.isRemote) {
            this.updateColonyClient();
        } else {
            this.pickupItems();
            this.cleanupChatMessages();
            this.updateColonyServer();
            this.checkIfStuck();
            if (this.worldObj.isDaytime() && !this.worldObj.isRaining()) {
                SoundUtils.playRandomSound(this.worldObj, this);
            } else if (this.worldObj.isRaining() && 1 >= this.rand.nextInt(6000) && this.getColonyJob() != null) {
                SoundUtils.playSoundAtCitizenWithChance(this.worldObj, this.getPosition(), this.getColonyJob().getBadWeatherSound(), 1);
            }
        }
        if (this.isEntityInsideOpaqueBlock() || this.isInsideOfMaterial(Material.LEAVES)) {
            this.getNavigator().moveAwayFromXYZ(this.getPosition(), 6.0, 2.0);
        }
        this.checkHeal();
        super.onLivingUpdate();
    }

    private void checkIfStuck() {
        if (this.currentPosition == null) {
            this.currentPosition = this.getPosition();
            return;
        }
        if (this.currentPosition.equals((Object)this.getPosition()) && this.newNavigator != null && this.newNavigator.getDestination() != null) {
            ++this.stuckTime;
            if (this.stuckTime >= 2400) {
                if (this.newNavigator.getDestination().distanceSq(this.posX, this.posY, this.posZ) < 6.0) {
                    this.stuckTime = 0;
                    return;
                }
                BlockPos destination = BlockPosUtil.getFloor(this.newNavigator.getDestination(), this.worldObj);
                BlockPos spawnPoint = Utils.scanForBlockNearPoint(this.worldObj, destination, 1, 1, 1, 3, new Block[]{Blocks.AIR, Blocks.SNOW_LAYER, Blocks.TALLGRASS, Blocks.RED_FLOWER, Blocks.YELLOW_FLOWER, Blocks.CARPET});
                EntityUtils.setSpawnPoint(spawnPoint, this);
                if (this.colony != null) {
                    Log.getLogger().info("Teleported stuck citizen " + this.getName() + " from colony: " + this.colony.getID() + " to target location");
                }
                this.stuckTime = 0;
            }
        } else {
            this.stuckTime = 0;
            this.currentPosition = this.getPosition();
        }
        this.currentPosition = this.getPosition();
    }

    public void setLastJob(@NotNull String jobName) {
        this.lastJob = jobName;
    }

    @NotNull
    public String getLastJob() {
        return this.lastJob;
    }

    private void updateColonyClient() {
        if (this.dataManager.isDirty()) {
            if (this.colonyId == 0) {
                this.colonyId = (Integer)this.dataManager.get(DATA_COLONY_ID);
            }
            if (this.citizenId == 0) {
                this.citizenId = (Integer)this.dataManager.get(DATA_CITIZEN_ID);
            }
            this.female = (Integer)this.dataManager.get(DATA_IS_FEMALE) != 0;
            this.level = (Integer)this.dataManager.get(DATA_LEVEL);
            this.modelId = RenderBipedCitizen.Model.valueOf((String)this.dataManager.get(DATA_MODEL));
            this.textureId = (Integer)this.dataManager.get(DATA_TEXTURE);
            this.renderMetadata = (String)this.dataManager.get(DATA_RENDER_METADATA);
            this.setTexture();
            this.dataManager.setClean();
        }
        this.updateArmSwingProgress();
    }

    private void pickupItems() {
        ArrayList<EntityItem> retList = new ArrayList<EntityItem>();
        for (Object o : this.worldObj.getEntitiesWithinAABB(EntityItem.class, this.getEntityBoundingBox().expand(2.0, 0.0, 2.0))) {
            if (!(o instanceof EntityItem)) continue;
            retList.add((EntityItem)o);
        }
        retList.stream().filter(item -> item != null).filter(item -> !item.isDead).filter(item -> this.canPickUpLoot()).forEach(this::tryPickupEntityItem);
    }

    private void cleanupChatMessages() {
        if (this.statusMessages.size() > 0 && this.ticksExisted % 20 == 0) {
            Iterator<Map.Entry<String, Integer>> it = this.statusMessages.entrySet().iterator();
            while (it.hasNext()) {
                if (this.ticksExisted - it.next().getValue() <= 20 * Configurations.chatFrequency) continue;
                it.remove();
            }
        }
    }

    private void checkHeal() {
        if (this.citizenData != null && this.getOffsetTicks() % 100 == 0 && this.getHealth() < this.getMaxHealth()) {
            this.heal(1.0f);
            this.citizenData.markDirty();
        }
    }

    private void setTexture() {
        if (!this.worldObj.isRemote) {
            return;
        }
        RenderBipedCitizen.Model model = this.getModelID();
        String textureBase = "textures/entity/" + model.textureBase;
        textureBase = textureBase + (this.female ? "Female" : "Male");
        int moddedTextureId = this.textureId % model.numTextures + 1;
        this.texture = new ResourceLocation("minecolonies", textureBase + moddedTextureId + this.renderMetadata + ".png");
    }

    public int getOffsetTicks() {
        return this.ticksExisted + 7 * this.getEntityId();
    }

    public RenderBipedCitizen.Model getModelID() {
        return this.modelId;
    }

    public void updateColonyServer() {
        if (this.colonyId == 0) {
            this.setDead();
            return;
        }
        if (this.colony == null) {
            this.handleNullColony();
        }
    }

    private void handleNullColony() {
        Colony c = ColonyManager.getColony(this.colonyId);
        if (c == null) {
            Log.getLogger().warn(String.format("EntityCitizen '%s' unable to find Colony #%d", this.getUniqueID(), this.colonyId));
            this.setDead();
            return;
        }
        CitizenData data = c.getCitizen(this.citizenId);
        if (data == null) {
            Log.getLogger().warn(String.format("EntityCitizen '%s' attempting to register with Colony #%d as Citizen %d, but not known to colony", this.getUniqueID(), this.colonyId, this.citizenId));
            this.setDead();
            return;
        }
        EntityCitizen existingCitizen = data.getCitizenEntity();
        if (existingCitizen != null && existingCitizen != this) {
            this.handleExistingCitizen(data, existingCitizen);
            return;
        }
        this.setColony(c, data);
    }

    private void handleExistingCitizen(@NotNull CitizenData data, @NotNull EntityCitizen existingCitizen) {
        Log.getLogger().warn(String.format("EntityCitizen '%s' attempting to register with Colony #%d as Citizen #%d, but already have a citizen ('%s')", this.getUniqueID(), this.colonyId, this.citizenId, existingCitizen.getUniqueID()));
        if (existingCitizen.getUniqueID().equals(this.getUniqueID())) {
            data.setCitizenEntity(this);
        } else {
            this.setDead();
        }
    }

    public void setColony(@Nullable Colony c, @Nullable CitizenData data) {
        if (c == null) {
            this.colony = null;
            this.colonyId = 0;
            this.citizenId = 0;
            this.citizenData = null;
            this.setDead();
            return;
        }
        this.colony = c;
        this.colonyId = this.colony.getID();
        this.citizenId = data.getId();
        this.citizenData = data;
        this.setCustomNameTag(this.citizenData.getName());
        this.female = this.citizenData.isFemale();
        this.textureId = this.citizenData.getTextureId();
        this.dataManager.set(DATA_COLONY_ID, (Object)this.colonyId);
        this.dataManager.set(DATA_CITIZEN_ID, (Object)this.citizenId);
        this.dataManager.set(DATA_IS_FEMALE, (Object)(this.female ? 1 : 0));
        this.dataManager.set(DATA_TEXTURE, (Object)this.textureId);
        this.updateLevel();
        this.citizenData.setCitizenEntity(this);
        this.onJobChanged(this.getColonyJob());
    }

    private CitizenDataView getCitizenDataView() {
        ColonyView colonyView;
        if (this.colonyId != 0 && this.citizenId != 0 && (colonyView = ColonyManager.getColonyView(this.colonyId)) != null) {
            return colonyView.getCitizen(this.citizenId);
        }
        return null;
    }

    public Random getRandom() {
        return this.rand;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.3);
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(100.0);
    }

    @NotNull
    public PathNavigate getNavigator() {
        return this.newNavigator;
    }

    protected void dropEquipment(boolean par1, int par2) {
        for (int i = 0; i < this.inventory.getSizeInventory(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack == null || itemstack.stackSize <= 0) continue;
            this.entityDropItem(itemstack);
        }
    }

    public boolean isAIDisabled() {
        return false;
    }

    private EntityItem entityDropItem(@NotNull ItemStack itemstack) {
        return this.entityDropItem(itemstack, 0.0f);
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public boolean isFemale() {
        return this.female;
    }

    public void clearColony() {
        this.setColony(null, null);
    }

    public boolean isAtHome() {
        BlockPos homePosition = this.getHomePosition();
        return homePosition != null && homePosition.distanceSq((double)((int)Math.floor(this.posX)), (double)((int)this.posY), (double)((int)Math.floor(this.posZ))) <= 16.0;
    }

    @Nullable
    public BlockPos getHomePosition() {
        BuildingHome homeBuilding = this.getHomeBuilding();
        if (homeBuilding != null) {
            return homeBuilding.getLocation();
        }
        if (this.getColony() != null && this.getColony().getTownHall() != null) {
            return this.getColony().getTownHall().getLocation();
        }
        return null;
    }

    @Nullable
    public Colony getColony() {
        return this.colony;
    }

    public boolean isInventoryFull() {
        return InventoryUtils.isInventoryFull(this.getInventoryCitizen());
    }

    @NotNull
    public InventoryCitizen getInventoryCitizen() {
        return this.inventory;
    }

    @NotNull
    public DesiredActivity getDesiredActivity() {
        if (this.getColonyJob() instanceof JobGuard) {
            return DesiredActivity.WORK;
        }
        if (!this.worldObj.isDaytime()) {
            return DesiredActivity.SLEEP;
        }
        if (this.worldObj.isRaining() && !this.shouldWorkWhileRaining()) {
            return DesiredActivity.IDLE;
        }
        if (this.getNavigator() != null && this.getNavigator().getPath() != null && this.getNavigator().getPath().getCurrentPathLength() == 0) {
            this.getNavigator().clearPathEntity();
        }
        return DesiredActivity.WORK;
    }

    private boolean shouldWorkWhileRaining() {
        return this.getWorkBuilding() != null && this.getWorkBuilding().getBuildingLevel() >= 5;
    }

    @Nullable
    public Entity changeDimension(int dimensionIn) {
        return null;
    }

    @NotNull
    public BlockPos getPosition() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public int findFirstSlotInInventoryWith(Item targetItem, int itemDamage) {
        return InventoryUtils.findFirstSlotInInventoryWith((IInventory)this.getInventoryCitizen(), targetItem, itemDamage);
    }

    public int findFirstSlotInInventoryWith(Block block, int itemDamage) {
        return InventoryUtils.findFirstSlotInInventoryWith((IInventory)this.getInventoryCitizen(), block, itemDamage);
    }

    public int getItemCountInInventory(Block block, int itemDamage) {
        return InventoryUtils.getItemCountInInventory((IInventory)this.getInventoryCitizen(), block, itemDamage);
    }

    public int getItemCountInInventory(Item targetItem, int itemDamage) {
        return InventoryUtils.getItemCountInInventory((IInventory)this.getInventoryCitizen(), targetItem, itemDamage);
    }

    public boolean hasItemInInventory(Block block, int itemDamage) {
        return InventoryUtils.hasitemInInventory((IInventory)this.getInventoryCitizen(), block, itemDamage);
    }

    public boolean hasItemInInventory(Item item, int itemDamage) {
        return InventoryUtils.hasitemInInventory((IInventory)this.getInventoryCitizen(), item, itemDamage);
    }

    private void tryPickupEntityItem(@NotNull EntityItem entityItem) {
        if (!this.worldObj.isRemote) {
            if (entityItem.cannotPickup()) {
                return;
            }
            ItemStack itemStack = entityItem.getEntityItem();
            int i = itemStack.stackSize;
            if (i <= 0 || InventoryUtils.addItemStackToInventory(this.getInventoryCitizen(), itemStack)) {
                this.worldObj.playSound((EntityPlayer)null, this.getPosition(), SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.AMBIENT, 0.2f, (float)((this.rand.nextGaussian() * 0.7 + 1.0) * 2.0));
                this.onItemPickup((Entity)this, i);
                if (itemStack.stackSize <= 0) {
                    entityItem.setDead();
                }
            }
        }
    }

    public void removeHeldItem() {
        this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, null);
    }

    public void setHeldItem(int slot) {
        this.inventory.setHeldItem(slot);
        this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, this.inventory.getStackInSlot(slot));
    }

    public void hitBlockWithToolInHand(@Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        this.hitBlockWithToolInHand(blockPos, false);
    }

    private void hitBlockWithToolInHand(@Nullable BlockPos blockPos, boolean breakBlock) {
        if (blockPos == null) {
            return;
        }
        this.getLookHelper().setLookPosition((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 10.0f, (float)this.getVerticalFaceSpeed());
        this.swingArm(this.getActiveHand());
        IBlockState blockState = this.worldObj.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (breakBlock) {
            if (!this.worldObj.isRemote) {
                MineColonies.getNetwork().sendToAllAround((IMessage)new BlockParticleEffectMessage(blockPos, this.worldObj.getBlockState(blockPos), -1), new NetworkRegistry.TargetPoint(this.worldObj.provider.getDimension(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 16.0));
            }
            this.worldObj.playSound(null, blockPos, block.getSoundType(blockState, this.worldObj, blockPos, (Entity)this).getBreakSound(), SoundCategory.BLOCKS, block.getSoundType(blockState, this.worldObj, blockPos, (Entity)this).getVolume(), block.getSoundType(blockState, this.worldObj, blockPos, (Entity)this).getPitch());
            this.worldObj.setBlockToAir(blockPos);
            this.damageItemInHand(1);
        } else {
            if (!this.worldObj.isRemote) {
                MineColonies.getNetwork().sendToAllAround((IMessage)new BlockParticleEffectMessage(blockPos, this.worldObj.getBlockState(blockPos), 1), new NetworkRegistry.TargetPoint(this.worldObj.provider.getDimension(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 16.0));
            }
            this.worldObj.playSound((EntityPlayer)null, blockPos, block.getSoundType(blockState, this.worldObj, blockPos, (Entity)this).getBreakSound(), SoundCategory.BLOCKS, block.getSoundType(blockState, this.worldObj, blockPos, (Entity)this).getVolume(), block.getSoundType(blockState, this.worldObj, blockPos, (Entity)this).getPitch());
        }
    }

    public void damageItemInHand(int damage) {
        ItemStack heldItem = this.inventory.getHeldItemMainhand();
        if (heldItem == null) {
            return;
        }
        heldItem.damageItem(damage, (EntityLivingBase)this);
        if (heldItem.stackSize < 1) {
            this.getInventoryCitizen().setInventorySlotContents(this.getInventoryCitizen().getHeldItemSlot(), null);
            this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, null);
        }
    }

    public void breakBlockWithToolInHand(@Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        this.hitBlockWithToolInHand(blockPos, true);
    }

    public void sendLocalizedChat(String key, Object ... args) {
        this.sendChat(key, args);
    }

    private void sendChat(String key, Object ... msg) {
        TextComponentTranslation requiredItem;
        if (msg == null || this.statusMessages.containsKey(key)) {
            return;
        }
        if (msg.length == 0) {
            requiredItem = new TextComponentTranslation(key, new Object[0]);
        } else {
            this.statusMessages.put(key + msg[0], this.ticksExisted);
            requiredItem = new TextComponentTranslation(key, msg);
        }
        TextComponentString citizenDescription = new TextComponentString(" ");
        citizenDescription.appendText(this.getCustomNameTag()).appendText(": ");
        TextComponentString colonyDescription = new TextComponentString(" at " + this.getColony().getName() + ":");
        LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), this.getColonyJob().getName(), colonyDescription, citizenDescription, requiredItem);
    }

    public int getIntelligence() {
        return this.citizenData.getIntelligence();
    }

    public int getCharisma() {
        return this.citizenData.getCharisma();
    }

    public int getStrength() {
        return this.citizenData.getStrength();
    }

    public int getEndurance() {
        return this.citizenData.getEndurance();
    }

    public int getDexterity() {
        return this.citizenData.getDexterity();
    }

    public void setSkillModifier(int modifier) {
        this.skillModifier = modifier;
    }

    public void onWakeUp() {
        if (this.getWorkBuilding() instanceof BuildingFarmer) {
            ((BuildingFarmer)this.getWorkBuilding()).resetFields();
        }
    }

    public static enum Status {
        IDLE,
        SLEEPING,
        WORKING,
        GETTING_ITEMS,
        NEED_ASSISTANCE,
        PATHFINDING_ERROR;

    }

    public static enum DesiredActivity {
        SLEEP,
        IDLE,
        WORK;

    }
}

