/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingBuilder;
import com.minecolonies.coremod.colony.buildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.entity.ai.util.Structure;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.MathUtils;
import com.minecolonies.coremod.util.StructureWrapper;
import com.minecolonies.coremod.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructure<J extends AbstractJob>
extends AbstractEntityAIInteract<J> {
    private static final double XP_EACH_BUILDING = 2.5;
    private static final double RUN_AWAY_SPEED = 4.1;
    private static final int MIN_ADDITIONAL_RANGE_TO_BUILD = 3;
    private static final int UNLIMITED_RESOURCES_TIMEOUT = 5;
    private Structure currentStructure;
    private BlockPos workFrom;
    private static final int STANDARD_WORKING_RANGE = 5;
    private static final int MIN_WORKING_RANGE = 12;
    private int rotation = 0;
    private static final CharSequence WAYPOINT_STRING = "waypoint";

    protected AbstractEntityAIStructure(@NotNull J job) {
        super(job);
        this.registerTargets(new AITarget(this::checkIfCanceled, AIState.IDLE), new AITarget(AIState.START_BUILDING, this::startBuilding), new AITarget(AIState.IDLE, this::isThereAStructureToBuild, () -> AIState.START_BUILDING), new AITarget(AIState.CLEAR_STEP, this.generateStructureGenerator(this::clearStep, AIState.BUILDING_STEP)), new AITarget(AIState.BUILDING_STEP, this.generateStructureGenerator(this::structureStep, AIState.SPAWN_STEP)), new AITarget(AIState.SPAWN_STEP, this.generateStructureGenerator(this::spawnEntity, AIState.DECORATION_STEP)), new AITarget(AIState.DECORATION_STEP, this.generateStructureGenerator(this::decorationStep, AIState.COMPLETE_BUILD)), new AITarget(AIState.COMPLETE_BUILD, this::completeBuild));
    }

    private AIState completeBuild() {
        if (this.job instanceof AbstractJobStructure) {
            if (((AbstractJobStructure)this.job).getStructure() == null && this.job instanceof JobBuilder && ((JobBuilder)this.job).hasWorkOrder()) {
                ((JobBuilder)this.job).complete();
            }
            if (this.job instanceof JobBuilder && ((JobBuilder)this.job).getStructure() != null) {
                String structureName = ((AbstractJobStructure)this.job).getStructure().getName();
                LanguageHandler.sendPlayersMessage(this.worker.getColony().getMessageEntityPlayers(), "entity.builder.messageBuildComplete", structureName);
                WorkOrderBuild wo = ((JobBuilder)this.job).getWorkOrder();
                if (wo == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing work order(%d)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), ((JobBuilder)this.job).getWorkOrderId()));
                } else {
                    if (wo instanceof WorkOrderBuildDecoration) {
                        if (structureName.contains(WAYPOINT_STRING)) {
                            this.worker.getColony().addWayPoint(wo.getBuildingLocation(), this.world.getBlockState(wo.getBuildingLocation()));
                        }
                    } else {
                        AbstractBuilding building = this.job.getColony().getBuilding(wo.getBuildingLocation());
                        if (building == null) {
                            Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), wo.getBuildingLocation()));
                        } else {
                            building.setBuildingLevel(wo.getUpgradeLevel());
                        }
                    }
                    ((JobBuilder)this.job).complete();
                }
                AbstractBuildingWorker workerBuilding = this.getOwnBuilding();
                if (workerBuilding instanceof BuildingBuilder) {
                    ((BuildingBuilder)workerBuilding).resetNeededResources();
                }
                this.resetTask();
            } else if (this.job instanceof JobMiner) {
                BuildingMiner minerBuilding = (BuildingMiner)this.getOwnBuilding();
                if (minerBuilding.clearedShaft) {
                    minerBuilding.getCurrentLevel().closeNextNode(this.rotation);
                } else {
                    Level currentLevel = new Level(minerBuilding, ((JobMiner)this.job).getStructure().getPosition().getY());
                    minerBuilding.addLevel(currentLevel);
                    minerBuilding.setCurrentLevel(minerBuilding.getNumberOfLevels());
                    minerBuilding.resetStartingLevelShaft();
                }
                this.getOwnBuilding().markDirty();
                ((JobMiner)this.job).setStructure(null);
            }
            this.worker.addExperience(2.5);
        }
        this.workFrom = null;
        this.currentStructure = null;
        return AIState.IDLE;
    }

    private Boolean decorationStep(Structure.StructureBlock structureBlock) {
        if (!BlockUtils.shouldNeverBeMessedWith(structureBlock.worldBlock)) {
            if (!this.walkToConstructionSite()) {
                return false;
            }
            if (structureBlock.block == null || structureBlock.doesStructureBlockEqualWorldBlock() || structureBlock.metadata.getMaterial().isSolid() || structureBlock.block instanceof BlockBed && ((BlockBed.EnumPartType)structureBlock.metadata.getValue((IProperty)BlockBed.PART)).equals((Object)BlockBed.EnumPartType.HEAD) || structureBlock.block instanceof BlockDoor && ((BlockDoor.EnumDoorHalf)structureBlock.metadata.getValue((IProperty)BlockDoor.HALF)).equals((Object)BlockDoor.EnumDoorHalf.UPPER)) {
                return true;
            }
            this.worker.faceBlock(structureBlock.blockPosition);
            Block block = structureBlock.block;
            if (block == null) {
                BlockPos local = structureBlock.blockPosition;
                Log.getLogger().error(String.format("StructureProxy has null block at %s - local(%s)", this.currentStructure.getCurrentBlockPosition(), local));
                return true;
            }
            IBlockState blockState = structureBlock.metadata;
            if (!Configurations.builderInfiniteResources && !this.handleMaterials(block, blockState)) {
                return false;
            }
            this.placeBlockAt(block, blockState, structureBlock.blockPosition);
        }
        return true;
    }

    private Boolean structureStep(Structure.StructureBlock structureBlock) {
        if (!BlockUtils.shouldNeverBeMessedWith(structureBlock.worldBlock)) {
            if (!this.walkToConstructionSite()) {
                return false;
            }
            if (structureBlock.block == null || structureBlock.doesStructureBlockEqualWorldBlock() || !structureBlock.metadata.getMaterial().isSolid() && structureBlock.block != Blocks.AIR || structureBlock.block instanceof BlockBed && ((BlockBed.EnumPartType)structureBlock.metadata.getValue((IProperty)BlockBed.PART)).equals((Object)BlockBed.EnumPartType.HEAD) || structureBlock.block instanceof BlockDoor && ((BlockDoor.EnumDoorHalf)structureBlock.metadata.getValue((IProperty)BlockDoor.HALF)).equals((Object)BlockDoor.EnumDoorHalf.UPPER)) {
                return true;
            }
            Block block = structureBlock.block;
            IBlockState blockState = structureBlock.metadata;
            if (structureBlock.block == ModBlocks.blockSolidSubstitution) {
                if (!(this.job instanceof JobMiner && structureBlock.worldBlock instanceof BlockOre || !structureBlock.worldMetadata.getMaterial().isSolid())) {
                    return true;
                }
                blockState = this.getSolidSubstitution(structureBlock.blockPosition);
                block = blockState.getBlock();
            }
            this.worker.faceBlock(structureBlock.blockPosition);
            if (block == null) {
                BlockPos local = structureBlock.blockPosition;
                Log.getLogger().error(String.format("StructureProxy has null block at %s - local(%s)", this.currentStructure.getCurrentBlockPosition(), local));
                return true;
            }
            if (!Configurations.builderInfiniteResources && !this.handleMaterials(block, blockState)) {
                return false;
            }
            this.placeBlockAt(block, blockState, structureBlock.blockPosition);
        }
        return true;
    }

    private Supplier<AIState> generateStructureGenerator(@NotNull Function<Structure.StructureBlock, Boolean> evaluationFunction, @NotNull AIState nextState) {
        Supplier<Structure.StructureBlock> getCurrentBlock = () -> this.currentStructure.getCurrentBlock();
        Supplier<Structure.Result> advanceBlock = () -> this.currentStructure.advanceBlock();
        return () -> {
            Structure.StructureBlock currentBlock = (Structure.StructureBlock)getCurrentBlock.get();
            if (currentBlock.block == null || ((Boolean)evaluationFunction.apply(currentBlock)).booleanValue()) {
                Structure.Result result = (Structure.Result)((Object)((Object)advanceBlock.get()));
                if (result == Structure.Result.AT_END) {
                    this.switchStage(nextState);
                    return nextState;
                }
                if (result == Structure.Result.CONFIG_LIMIT) {
                    return this.getState();
                }
            }
            return this.getState();
        };
    }

    private void switchStage(AIState state) {
        if (state.equals((Object)AIState.BUILDING_STEP)) {
            this.currentStructure.setStage(Structure.Stage.BUILD);
        } else if (state.equals((Object)AIState.DECORATION_STEP)) {
            this.currentStructure.setStage(Structure.Stage.DECORATE);
        } else if (state.equals((Object)AIState.SPAWN_STEP)) {
            this.currentStructure.setStage(Structure.Stage.SPAWN);
        } else if (state.equals((Object)AIState.COMPLETE_BUILD)) {
            this.currentStructure.setStage(Structure.Stage.COMPLETE);
        }
    }

    public void loadStructure() {
        WorkOrderBuild workOrder = null;
        if (this.job instanceof JobBuilder) {
            workOrder = ((JobBuilder)this.job).getWorkOrder();
        }
        if (workOrder == null) {
            return;
        }
        BlockPos pos = workOrder.getBuildingLocation();
        if (!(workOrder instanceof WorkOrderBuildDecoration) && this.worker.getColony().getBuilding(pos) == null) {
            Log.getLogger().warn("AbstractBuilding does not exist - removing build request");
            this.worker.getColony().getWorkManager().removeWorkOrder(workOrder);
            return;
        }
        int tempRotation = 0;
        if (workOrder.getRotation() == 0 && !(workOrder instanceof WorkOrderBuildDecoration)) {
            IBlockState blockState = this.world.getBlockState(pos);
            if (blockState.getBlock() instanceof AbstractBlockHut) {
                tempRotation = BlockUtils.getRotationFromFacing((EnumFacing)blockState.getValue((IProperty)AbstractBlockHut.FACING));
            }
        } else {
            tempRotation = workOrder.getRotation();
        }
        this.loadStructure(workOrder.getStructureName(), tempRotation, pos, workOrder.isMirrored());
        workOrder.setCleared(false);
        workOrder.setRequested(false);
        this.requestMaterialsIfRequired();
    }

    private void requestMaterialsIfRequired() {
        if (!Configurations.builderInfiniteResources && this.job instanceof JobBuilder && this.getOwnBuilding() instanceof BuildingBuilder) {
            ((BuildingBuilder)this.getOwnBuilding()).resetNeededResources();
            this.requestMaterials();
        }
    }

    public abstract IBlockState getSolidSubstitution(BlockPos var1);

    public void loadStructure(@NotNull String name, int rotateTimes, BlockPos position, boolean isMirrored) {
        if (this.job instanceof AbstractJobStructure) {
            this.rotation = rotateTimes;
            try {
                StructureWrapper wrapper = new StructureWrapper(this.world, name);
                ((AbstractJobStructure)this.job).setStructure(wrapper);
                this.currentStructure = new Structure(this.world, wrapper, Structure.Stage.CLEAR);
            }
            catch (IllegalStateException e) {
                Log.getLogger().warn(String.format("StructureProxy: (%s) does not exist - removing build request", name), (Throwable)e);
                ((AbstractJobStructure)this.job).setStructure(null);
            }
            ((AbstractJobStructure)this.job).getStructure().rotate(rotateTimes, this.world, position, isMirrored ? Mirror.FRONT_BACK : Mirror.NONE);
            ((AbstractJobStructure)this.job).getStructure().setPosition(position);
        }
    }

    protected abstract boolean checkIfCanceled();

    private void requestMaterials() {
        JobBuilder builderJob = (JobBuilder)this.job;
        while (builderJob.getStructure().findNextBlock()) {
            AbstractBuildingWorker building;
            Template.BlockInfo blockInfo = builderJob.getStructure().getBlockInfo();
            Template.EntityInfo entityInfo = builderJob.getStructure().getEntityinfo();
            if (blockInfo == null) continue;
            this.requestEntityToBuildingIfRequired(entityInfo);
            IBlockState blockState = blockInfo.blockState;
            Block block = blockState.getBlock();
            if (builderJob.getStructure().doesStructureBlockEqualWorldBlock() || blockState.getBlock() instanceof BlockBed && ((BlockBed.EnumPartType)blockState.getValue((IProperty)BlockBed.PART)).equals((Object)BlockBed.EnumPartType.FOOT) || blockState.getBlock() instanceof BlockDoor && ((BlockDoor.EnumDoorHalf)blockState.getValue((IProperty)BlockDoor.HALF)).equals((Object)BlockDoor.EnumDoorHalf.UPPER)) continue;
            Block worldBlock = BlockPosUtil.getBlock(this.world, builderJob.getStructure().getBlockPosition());
            if (block == null || block == Blocks.AIR || worldBlock == Blocks.BEDROCK || worldBlock instanceof AbstractBlockHut || AbstractEntityAIStructure.isBlockFree(block, 0) || !((building = this.getOwnBuilding()) instanceof BuildingBuilder)) continue;
            this.requestBlockToBuildingIfRequired((BuildingBuilder)building, blockState);
        }
        builderJob.getWorkOrder().setRequested(true);
    }

    private void requestBlockToBuildingIfRequired(BuildingBuilder building, IBlockState blockState) {
        if (((JobBuilder)this.job).getStructure().getBlockInfo().tileentityData != null) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.addAll(this.getItemStacksOfTileEntity(((JobBuilder)this.job).getStructure().getBlockInfo().tileentityData));
            for (ItemStack stack : itemList) {
                building.addNeededResource(stack, 1);
            }
        }
        building.addNeededResource(BlockUtils.getItemStackFromBlockState(blockState), 1);
    }

    private void requestEntityToBuildingIfRequired(Template.EntityInfo entityInfo) {
        Entity entity;
        if (entityInfo != null && (entity = this.getEntityFromEntityInfoOrNull(entityInfo)) != null) {
            ArrayList<ItemStack> request = new ArrayList<ItemStack>();
            if (entity instanceof EntityItemFrame) {
                ItemStack stack = ((EntityItemFrame)entity).getDisplayedItem();
                if (stack != null) {
                    stack.stackSize = 1;
                    request.add(stack);
                    request.add(new ItemStack(Items.ITEM_FRAME, 1, stack.getItemDamage()));
                }
            } else if (entity instanceof EntityArmorStand) {
                request.add(entity.getPickedResult(new RayTraceResult((Entity)this.worker)));
                entity.getArmorInventoryList().forEach(request::add);
            } else {
                request.add(entity.getPickedResult(new RayTraceResult((Entity)this.worker)));
            }
            for (ItemStack stack : request) {
                AbstractBuildingWorker building = this.getOwnBuilding();
                if (!(building instanceof BuildingBuilder) || stack == null || stack.getItem() == null) continue;
                ((BuildingBuilder)building).addNeededResource(stack, 1);
            }
        }
    }

    private boolean clearStep(@NotNull Structure.StructureBlock currentBlock) {
        if (this.job instanceof JobBuilder && ((JobBuilder)this.job).getWorkOrder() != null && ((JobBuilder)this.job).getWorkOrder().isCleared() || !this.currentStructure.getStage().equals((Object)Structure.Stage.CLEAR)) {
            return true;
        }
        if (!BlockUtils.shouldNeverBeMessedWith(currentBlock.worldBlock)) {
            if (!this.walkToConstructionSite()) {
                return false;
            }
            this.worker.faceBlock(currentBlock.blockPosition);
            if (Configurations.builderInfiniteResources || currentBlock.worldMetadata.getMaterial().isLiquid()) {
                this.worker.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, null);
                this.world.setBlockToAir(currentBlock.blockPosition);
                this.world.setBlockState(currentBlock.blockPosition, Blocks.AIR.getDefaultState());
                this.worker.swingArm(this.worker.getActiveHand());
                this.setDelay(5);
            } else if (!this.mineBlock(currentBlock.blockPosition, this.workFrom == null ? this.getWorkingPosition(this.currentStructure.getCurrentBlockPosition()) : this.workFrom)) {
                return false;
            }
        }
        return true;
    }

    protected boolean isThereAStructureToBuild() {
        return this.currentStructure != null;
    }

    public boolean walkToConstructionSite() {
        if (this.workFrom == null) {
            this.workFrom = this.getWorkingPosition(this.currentStructure.getCurrentBlockPosition());
        }
        return this.worker.isWorkerAtSiteWithMove(this.workFrom, 5) || MathUtils.twoDimDistance(this.worker.getPosition(), this.workFrom) < 12.0;
    }

    @NotNull
    private AIState startBuilding() {
        if (this.currentStructure == null) {
            this.onStartWithoutStructure();
            return AIState.IDLE;
        }
        switch (this.currentStructure.getStage()) {
            case CLEAR: {
                return AIState.CLEAR_STEP;
            }
            case BUILD: {
                return AIState.BUILDING_STEP;
            }
            case DECORATE: {
                return AIState.DECORATION_STEP;
            }
            case SPAWN: {
                return AIState.SPAWN_STEP;
            }
        }
        return AIState.COMPLETE_BUILD;
    }

    protected abstract void onStartWithoutStructure();

    private boolean handleMaterials(@NotNull Block block, @NotNull IBlockState blockState) {
        if (block == Blocks.AIR) {
            return true;
        }
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
        if (this.job instanceof JobBuilder && ((JobBuilder)this.job).getStructure() != null && ((JobBuilder)this.job).getStructure().getBlockInfo() != null && ((JobBuilder)this.job).getStructure().getBlockInfo().tileentityData != null) {
            itemList.addAll(this.getItemStacksOfTileEntity(((JobBuilder)this.job).getStructure().getBlockInfo().tileentityData));
        }
        for (ItemStack stack : itemList) {
            if (stack == null || !this.checkOrRequestItems(this.getTotalAmount(stack))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        return stack;
    }

    private List<ItemStack> getItemStacksOfTileEntity(NBTTagCompound compound) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        TileEntity tileEntity = TileEntity.create((World)this.world, (NBTTagCompound)compound);
        if (tileEntity instanceof TileEntityFlowerPot) {
            items.add(((TileEntityFlowerPot)tileEntity).getFlowerItemStack());
        } else if (tileEntity instanceof TileEntityLockable) {
            for (int i = 0; i < ((TileEntityLockable)tileEntity).getSizeInventory(); ++i) {
                ItemStack stack = ((TileEntityLockable)tileEntity).getStackInSlot(i);
                if (stack == null) continue;
                items.add(stack);
            }
        }
        return items;
    }

    public static boolean isBlockFree(@Nullable Block block, int metadata) {
        return block == null || BlockUtils.isWater(block.getDefaultState()) || block.equals(Blocks.LEAVES) || block.equals(Blocks.LEAVES2) || block.equals(Blocks.DOUBLE_PLANT) && Utils.testFlag(metadata, 8) || block.equals(Blocks.GRASS) || block.equals(ModBlocks.blockSolidSubstitution);
    }

    private void placeBlockAt(@NotNull Block block, @NotNull IBlockState blockState, @NotNull BlockPos coords) {
        if (block == Blocks.AIR) {
            this.worker.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, null);
            if (!this.world.setBlockToAir(coords)) {
                Log.getLogger().error(String.format("Block break failure at %s", coords));
            }
        } else {
            ItemStack item = BlockUtils.getItemStackFromBlockState(blockState);
            this.worker.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, item == null ? null : item);
            if (!this.placeBlock(coords, block, blockState)) {
                Log.getLogger().error(String.format("Block place failure %s at %s", block.getUnlocalizedName(), coords));
            }
            this.worker.swingArm(this.worker.getActiveHand());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean placeBlock(@NotNull BlockPos pos, Block block, @NotNull IBlockState blockState) {
        if (MathHelper.floor_double((double)this.worker.posX) == pos.getX() && MathHelper.abs_int((int)(pos.getY() - (int)this.worker.posY)) <= 1 && MathHelper.floor_double((double)this.worker.posZ) == pos.getZ() && this.worker.getNavigator().noPath()) {
            this.worker.getNavigator().moveAwayFromXYZ(pos, 4.1, 1.0);
        }
        if (blockState.getBlock() instanceof BlockStairs && this.world.getBlockState(pos).getBlock() instanceof BlockStairs && this.world.getBlockState(pos).getValue((IProperty)BlockStairs.FACING) == blockState.getValue((IProperty)BlockStairs.FACING) && blockState.getBlock() == this.world.getBlockState(pos).getBlock()) {
            return true;
        }
        if (!Configurations.builderInfiniteResources && this.world.getBlockState(pos).getBlock() != Blocks.AIR) {
            List<ItemStack> items = BlockPosUtil.getBlockDrops(this.world, pos, 0);
            for (ItemStack item : items) {
                InventoryUtils.setStack(this.worker.getInventoryCitizen(), item);
            }
        }
        if (block instanceof BlockDoor) {
            if (((BlockDoor.EnumDoorHalf)blockState.getValue((IProperty)BlockDoor.HALF)).equals((Object)BlockDoor.EnumDoorHalf.LOWER)) {
                ItemDoor.placeDoor((World)this.world, (BlockPos)pos, (EnumFacing)((EnumFacing)blockState.getValue((IProperty)BlockDoor.FACING)), (Block)block, (boolean)false);
            }
        } else if (block instanceof BlockBed) {
            EnumFacing facing = (EnumFacing)blockState.getValue((IProperty)BlockBed.FACING);
            if (blockState.getValue((IProperty)BlockBed.PART) != BlockBed.EnumPartType.FOOT) return true;
            this.world.setBlockState(pos.offset(facing), blockState.withProperty((IProperty)BlockBed.PART, (Comparable)BlockBed.EnumPartType.HEAD), 3);
            this.world.setBlockState(pos, blockState.withProperty((IProperty)BlockBed.PART, (Comparable)BlockBed.EnumPartType.FOOT), 3);
        } else if (block instanceof BlockDoublePlant) {
            this.world.setBlockState(pos, blockState.withProperty((IProperty)BlockDoublePlant.HALF, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER), 3);
            this.world.setBlockState(pos.up(), blockState.withProperty((IProperty)BlockDoublePlant.HALF, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), 3);
        } else {
            if (block instanceof BlockEndPortal || block instanceof BlockMobSpawner || block instanceof BlockDragonEgg || block instanceof BlockPortal) {
                return true;
            }
            if (block instanceof BlockFlowerPot) {
                if (!this.world.setBlockState(pos, blockState, 3)) {
                    return false;
                }
                if (this.job instanceof JobBuilder && ((JobBuilder)this.job).getStructure().getBlockInfo().tileentityData != null) {
                    TileEntityFlowerPot tileentityflowerpot = (TileEntityFlowerPot)this.world.getTileEntity(pos);
                    tileentityflowerpot.readFromNBT(((JobBuilder)this.job).getStructure().getBlockInfo().tileentityData);
                    this.world.setTileEntity(pos, (TileEntity)tileentityflowerpot);
                }
            } else if (!this.world.setBlockState(pos, blockState, 3)) {
                return false;
            }
        }
        if (block instanceof BlockChest && this.job instanceof JobBuilder) {
            BlockPos buildingLocation = ((JobBuilder)this.job).getWorkOrder().getBuildingLocation();
            AbstractBuilding building = this.getOwnBuilding().getColony().getBuilding(buildingLocation);
            building.addContainerPosition(pos);
        }
        if (AbstractEntityAIStructure.isBlockFree(block, block.getMetaFromState(blockState))) {
            return true;
        }
        ItemStack stack = BlockUtils.getItemStackFromBlockState(blockState);
        if (stack == null) {
            Log.getLogger().error("Block causes NPE: " + blockState.getBlock());
            return false;
        }
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        itemList.add(stack);
        if (this.job instanceof JobBuilder && ((JobBuilder)this.job).getStructure() != null && ((JobBuilder)this.job).getStructure().getBlockInfo() != null && ((JobBuilder)this.job).getStructure().getBlockInfo().tileentityData != null) {
            itemList.addAll(this.getItemStacksOfTileEntity(((JobBuilder)this.job).getStructure().getBlockInfo().tileentityData));
        }
        for (ItemStack tempStack : itemList) {
            int slot;
            if (tempStack == null || (slot = this.worker.findFirstSlotInInventoryWith(tempStack.getItem(), tempStack.getItemDamage())) == -1) continue;
            this.getInventory().decrStackSize(slot, 1);
            this.reduceNeededResources(tempStack);
        }
        if (Configurations.builderBuildBlockDelay <= 0 || block == Blocks.AIR) return true;
        this.setDelay(Configurations.builderBuildBlockDelay);
        return true;
    }

    public void reduceNeededResources(ItemStack stack) {
        AbstractBuildingWorker workerBuilding = this.getOwnBuilding();
        if (workerBuilding instanceof BuildingBuilder) {
            ((BuildingBuilder)workerBuilding).reduceNeededResource(stack, 1);
        }
    }

    @Nullable
    private Entity getEntityFromEntityInfoOrNull(Template.EntityInfo entityInfo) {
        try {
            return EntityList.createEntityFromNBT((NBTTagCompound)entityInfo.entityData, (World)this.world);
        }
        catch (RuntimeException e) {
            Log.getLogger().info("Couldn't restore entitiy", (Throwable)e);
            return null;
        }
    }

    public void resetCurrentStructure() {
        this.currentStructure = null;
    }

    private Boolean spawnEntity(@NotNull Structure.StructureBlock currentBlock) {
        Entity entity;
        Template.EntityInfo entityInfo = currentBlock.entity;
        if (entityInfo != null && this.job instanceof JobBuilder && ((JobBuilder)this.job).getStructure() != null && (entity = this.getEntityFromEntityInfoOrNull(entityInfo)) != null && !AbstractEntityAIStructure.isEntityAtPosition(entity, this.world)) {
            ArrayList<ItemStack> request = new ArrayList<ItemStack>();
            if (entity instanceof EntityItemFrame) {
                ItemStack stack = ((EntityItemFrame)entity).getDisplayedItem();
                if (stack != null) {
                    ++stack.stackSize;
                    request.add(stack);
                }
                request.add(new ItemStack(Items.ITEM_FRAME, 1));
            } else if (entity instanceof EntityArmorStand) {
                request.add(entity.getPickedResult(new RayTraceResult((Entity)this.worker)));
                entity.getArmorInventoryList().forEach(request::add);
            } else {
                request.add(entity.getPickedResult(new RayTraceResult((Entity)this.worker)));
            }
            if (!Configurations.builderInfiniteResources) {
                for (ItemStack stack : request) {
                    if (!this.checkOrRequestItems(stack)) continue;
                    return false;
                }
                for (ItemStack stack : request) {
                    int slot;
                    if (stack == null || (slot = this.worker.findFirstSlotInInventoryWith(stack.getItem(), stack.getItemDamage())) == -1) continue;
                    this.getInventory().decrStackSize(slot, 1);
                    this.reduceNeededResources(stack);
                }
            }
            entity.setUniqueId(UUID.randomUUID());
            entity.setLocationAndAngles(entity.posX, entity.posY, entity.posZ, entity.rotationYaw, entity.rotationPitch);
            if (!this.world.spawnEntityInWorld(entity)) {
                Log.getLogger().info("Failed to spawn entity");
            }
        }
        return true;
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        int length = this.currentStructure.getLength();
        int width = this.currentStructure.getWidth();
        int distance = Math.max(width, length) + 3;
        return this.getWorkingPosition(distance, targetPosition, 0);
    }

    private static boolean isEntityAtPosition(Entity entity, World world) {
        return !world.getEntitiesWithinAABB(entity.getClass(), new AxisAlignedBB(entity.posX, entity.posY, entity.posZ, entity.posX, entity.posY, entity.posZ)).isEmpty();
    }
}

