/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.fisherman;

import com.minecolonies.coremod.colony.buildings.BuildingFisherman;
import com.minecolonies.coremod.colony.jobs.JobFisherman;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.EntityFishHook;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import com.minecolonies.coremod.entity.ai.util.AIState;
import com.minecolonies.coremod.entity.ai.util.AITarget;
import com.minecolonies.coremod.entity.pathfinding.PathJobFindWater;
import com.minecolonies.coremod.sounds.FishermanSounds;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.SoundUtils;
import com.minecolonies.coremod.util.Utils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFisherman
extends AbstractEntityAISkill<JobFisherman> {
    private static final String RENDER_META_FISH = "Fish";
    private static final String RENDER_META_FISHANDROD = "RodFish";
    private static final String RENDER_META_ROD = "Rod";
    private static final int MAX_PONDS = 20;
    private static final int FISHING_DELAY = 500;
    private static final int CHANCE = 2;
    private static final int MIN_DISTANCE_TO_WATER = 3;
    private static final int MAX_FISHES_IN_INV = 10;
    private static final int MAX_ROTATIONS = 6;
    private static final String TOOL_TYPE_ROD = "rod";
    private static final int SEARCH_RANGE = 50;
    private static final double CHANCE_NEW_POND = 0.05;
    private static final int INTELLIGENCE_MULTIPLIER = 2;
    private static final int DEXTERITY_MULTIPLIER = 1;
    private static final int FISHING_TIMEOUT = 5;
    private static final int CHANCE_TO_PLAY_SOUND = 20;
    private int executedRotations = 0;
    @Nullable
    private PathJobFindWater.WaterPathResult pathResult;
    @Nullable
    private PathJobFindWater.WaterPathResult lastPathResult;
    private int fishingSkill = this.worker.getLevel();
    @Nullable
    private EntityFishHook entityFishHook;
    @NotNull
    private final Random random = new Random();

    public EntityAIWorkFisherman(@NotNull JobFisherman job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget(AIState.PREPARING, this::prepareForFishing), new AITarget(AIState.FISHERMAN_CHECK_WATER, this::tryDifferentAngles), new AITarget(AIState.FISHERMAN_SEARCHING_WATER, this::findWater), new AITarget(AIState.FISHERMAN_WALKING_TO_WATER, this::getToWater), new AITarget(AIState.FISHERMAN_START_FISHING, this::doFishing));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getIntelligence() + 1 * this.worker.getCitizenData().getDexterity());
        this.worker.setCanPickUpLoot(true);
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.PREPARING;
    }

    private AIState prepareForFishing() {
        if (this.checkOrRequestItems(false, new ItemStack((Item)Items.FISHING_ROD))) {
            this.playNeedRodSound();
            return this.getState();
        }
        if (((JobFisherman)this.job).getWater() == null) {
            return AIState.FISHERMAN_SEARCHING_WATER;
        }
        return AIState.FISHERMAN_WALKING_TO_WATER;
    }

    private void playNeedRodSound() {
        if (this.worker != null) {
            SoundEvent needFishingRod = this.worker.isFemale() ? FishermanSounds.Female.needFishingRod : FishermanSounds.Male.needFishingRod;
            SoundUtils.playSoundAtCitizenWithChance(this.world, this.worker.getPosition(), needFishingRod, 20);
        }
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10;
    }

    @Override
    protected BuildingFisherman getOwnBuilding() {
        return (BuildingFisherman)this.worker.getWorkBuilding();
    }

    @Override
    protected void updateRenderMetaData() {
        if (this.hasFish() && this.hasRodButNotEquipped()) {
            this.worker.setRenderMetadata(RENDER_META_FISHANDROD);
        } else if (this.hasRodButNotEquipped() && !this.hasFish()) {
            this.worker.setRenderMetadata(RENDER_META_ROD);
        } else {
            this.worker.setRenderMetadata(this.hasFish() ? RENDER_META_FISH : "");
        }
    }

    private boolean hasFish() {
        return InventoryUtils.hasitemInInventory((IInventory)this.getInventory(), Items.FISH, -1);
    }

    private boolean hasRodButNotEquipped() {
        return this.worker.hasItemInInventory((Item)Items.FISHING_ROD, -1) && this.worker.getHeldItemMainhand() != null && !(this.worker.getHeldItemMainhand().getItem() instanceof ItemFishingRod);
    }

    private AIState getToWater() {
        if (((JobFisherman)this.job).getWater() == null) {
            return AIState.FISHERMAN_SEARCHING_WATER;
        }
        if (this.walkToWater()) {
            return this.getState();
        }
        return AIState.FISHERMAN_CHECK_WATER;
    }

    private boolean walkToWater() {
        return ((JobFisherman)this.job).getWater() != null && this.walkToBlock(((JobFisherman)this.job).getWater());
    }

    @NotNull
    private AIState tryDifferentAngles() {
        if (((JobFisherman)this.job).getWater() == null) {
            return AIState.FISHERMAN_SEARCHING_WATER;
        }
        if (this.executedRotations >= 6) {
            ((JobFisherman)this.job).removeFromPonds(((JobFisherman)this.job).getWater());
            ((JobFisherman)this.job).setWater(null);
            this.executedRotations = 0;
            return AIState.FISHERMAN_SEARCHING_WATER;
        }
        this.worker.faceBlock(((JobFisherman)this.job).getWater());
        ++this.executedRotations;
        return AIState.FISHERMAN_START_FISHING;
    }

    private AIState findWater() {
        this.executedRotations = 0;
        if (((JobFisherman)this.job).getPonds().size() >= 20) {
            return this.setRandomWater();
        }
        return this.findNewWater();
    }

    private AIState setRandomWater() {
        if (((JobFisherman)this.job).getPonds().isEmpty()) {
            if (this.lastPathResult != null && this.lastPathResult.isEmpty && !this.lastPathResult.isCancelled()) {
                this.chatSpamFilter.talkWithoutSpam("entity.fisherman.messageWaterTooFar", new Object[0]);
            }
            this.pathResult = this.worker.getNavigator().moveToWater(50, 1.0, ((JobFisherman)this.job).getPonds());
            return this.getState();
        }
        ((JobFisherman)this.job).setWater(((JobFisherman)this.job).getPonds().get(this.random.nextInt(((JobFisherman)this.job).getPonds().size())));
        return AIState.FISHERMAN_CHECK_WATER;
    }

    private AIState findNewWater() {
        if (this.pathResult == null) {
            this.pathResult = this.worker.getNavigator().moveToWater(50, 1.0, ((JobFisherman)this.job).getPonds());
            return this.getState();
        }
        if (this.pathResult.failedToReachDestination()) {
            return this.setRandomWater();
        }
        if (this.pathResult.getPathReachesDestination()) {
            if (this.pathResult.pond != null) {
                ((JobFisherman)this.job).setWater(this.pathResult.pond);
                ((JobFisherman)this.job).addToPonds(this.pathResult.pond);
            }
            this.lastPathResult = this.pathResult;
            this.pathResult = null;
            return AIState.FISHERMAN_CHECK_WATER;
        }
        if (this.pathResult.isCancelled()) {
            this.pathResult = null;
            return AIState.PREPARING;
        }
        return this.getState();
    }

    @Nullable
    private AIState doFishing() {
        this.worker.gatherXp();
        AIState notReadyState = this.isReadyToFish();
        if (notReadyState != null) {
            return notReadyState;
        }
        if (this.caughtFish()) {
            this.getOwnBuilding().getColony().incrementStatistic("fish");
            this.playCaughtFishSound();
            if (this.random.nextDouble() < 0.05) {
                ((JobFisherman)this.job).setWater(null);
                return AIState.FISHERMAN_SEARCHING_WATER;
            }
            return AIState.FISHERMAN_WALKING_TO_WATER;
        }
        return this.throwOrRetrieveHook();
    }

    private void playCaughtFishSound() {
        if (this.worker != null) {
            SoundEvent iGotOne = this.worker.isFemale() ? FishermanSounds.Female.iGotOne : FishermanSounds.Male.iGotOne;
            SoundUtils.playSoundAtCitizenWithChance(this.world, this.worker.getPosition(), iGotOne, 20);
        }
    }

    private AIState throwOrRetrieveHook() {
        if (this.entityFishHook == null) {
            if (this.testRandomChance()) {
                return this.getState();
            }
            this.throwRod();
        } else if (this.isFishHookStuck()) {
            this.retrieveRod();
            return AIState.FISHERMAN_WALKING_TO_WATER;
        }
        return this.getState();
    }

    private void throwRod() {
        if (!this.world.isRemote) {
            this.worker.faceBlock(((JobFisherman)this.job).getWater());
            this.world.playSound((EntityPlayer)null, this.worker.getPosition(), SoundEvents.ENTITY_BOBBER_THROW, SoundCategory.NEUTRAL, 0.5f, (float)(0.4 / ((double)this.world.rand.nextFloat() * 0.4 + 0.8)));
            this.entityFishHook = new EntityFishHook(this.world, this.getCitizen());
            this.world.spawnEntityInWorld((Entity)this.entityFishHook);
        }
        this.worker.swingArm(this.worker.getActiveHand());
    }

    private boolean isFishHookStuck() {
        return !this.entityFishHook.isInWater() && (this.entityFishHook.onGround || this.entityFishHook.fishHookIsOverTimeToLive()) || this.entityFishHook.isDead;
    }

    private boolean testRandomChance() {
        this.setDelay(5);
        double chance = (double)this.random.nextInt(500) / (double)(this.fishingSkill + 1);
        return chance >= 2.0;
    }

    private AIState isReadyToFish() {
        if (!this.worker.hasItemInInventory((Item)Items.FISHING_ROD, -1)) {
            return AIState.PREPARING;
        }
        if (this.world.getBlockState(this.worker.getPosition()).getBlock() == Blocks.WATER) {
            ((JobFisherman)this.job).removeFromPonds(((JobFisherman)this.job).getWater());
            ((JobFisherman)this.job).setWater(null);
            return AIState.FISHERMAN_SEARCHING_WATER;
        }
        if (!Utils.isBlockInRange(this.world, (Block)Blocks.WATER, (int)this.worker.posX, (int)this.worker.posY, (int)this.worker.posZ, 3)) {
            return AIState.FISHERMAN_WALKING_TO_WATER;
        }
        if (this.worker.getHeldItemMainhand() == null || !this.worker.getHeldItemMainhand().getItem().equals(Items.FISHING_ROD)) {
            this.equipRod();
            return this.getState();
        }
        return null;
    }

    private void equipRod() {
        this.worker.setHeldItem(this.getRodSlot());
    }

    private int getRodSlot() {
        return InventoryUtils.getFirstSlotContainingTool(this.getInventory(), TOOL_TYPE_ROD);
    }

    private boolean caughtFish() {
        if (this.entityFishHook == null) {
            return false;
        }
        if (!this.entityFishHook.caughtFish()) {
            return false;
        }
        this.worker.setCanPickUpLoot(true);
        this.worker.captureDrops = true;
        this.retrieveRod();
        this.fishingSkill = this.worker.getLevel();
        this.incrementActionsDone();
        return true;
    }

    private void retrieveRod() {
        this.worker.swingArm(this.worker.getActiveHand());
        int i = this.entityFishHook.getDamage(this.getCitizen());
        this.worker.damageItemInHand(i);
        this.entityFishHook = null;
    }

    @Nullable
    public EntityCitizen getCitizen() {
        return this.worker;
    }
}

