/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.SoundUtils;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;

public class EntityAIGoHome
extends EntityAIBase {
    private static final int CHANCE = 100;
    private static final DamageSource CLEANUP_DAMAGE = new DamageSource("CleanUpTask");
    private final EntityCitizen citizen;

    public EntityAIGoHome(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    public boolean shouldExecute() {
        return this.citizen.getDesiredActivity() == EntityCitizen.DesiredActivity.SLEEP && !this.citizen.isAtHome();
    }

    public boolean continueExecuting() {
        return !this.citizen.getNavigator().noPath() && this.citizen.getDesiredActivity() == EntityCitizen.DesiredActivity.SLEEP;
    }

    public void startExecuting() {
        BlockPos pos = this.citizen.getHomePosition();
        if (pos == null) {
            if (this.citizen.getColony() == null) {
                this.citizen.onDeath(CLEANUP_DAMAGE);
            } else {
                this.citizen.isWorkerAtSiteWithMove(this.citizen.getColony().getCenter(), 2);
            }
            return;
        }
        this.playGoHomeSounds();
        this.citizen.isWorkerAtSiteWithMove(pos, 2);
    }

    public void setMutexBits(int mutexBitsIn) {
        super.setMutexBits(1);
    }

    private void playGoHomeSounds() {
        int chance = this.citizen.getRandom().nextInt(100);
        if (chance <= 1 && this.citizen.getWorkBuilding() != null && this.citizen.getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWithChance(this.citizen.worldObj, this.citizen.getPosition(), this.citizen.getColonyJob().getBedTimeSound(), 1);
        }
    }
}

