/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Node
implements Comparable<Node> {
    private static final int HASH_A = 12;
    private static final int HASH_B = 20;
    private static final int HASH_C = 24;
    @NotNull
    public final BlockPos pos;
    private final int hash;
    @Nullable
    public Node parent;
    private int counterAdded;
    private int counterVisited;
    private int steps;
    private double cost;
    private double heuristic;
    private double score;
    private boolean closed = false;
    private boolean ladder = false;
    private boolean swimming = false;

    public Node(@NotNull BlockPos pos, double heuristic) {
        this(null, pos, 0.0, heuristic, heuristic);
    }

    public Node(@Nullable Node parent, @NotNull BlockPos pos, double cost, double heuristic, double score) {
        this.parent = parent;
        this.pos = pos;
        this.steps = parent == null ? 0 : parent.steps + 1;
        this.cost = cost;
        this.heuristic = heuristic;
        this.score = score;
        this.hash = pos.getX() ^ (pos.getZ() << 12 | pos.getZ() >> 20) ^ pos.getY() << 24;
    }

    @Override
    public int compareTo(@NotNull Node o) {
        if (this.score < o.score) {
            return -1;
        }
        if (this.score > o.score) {
            return 1;
        }
        if (this.heuristic < o.heuristic) {
            return -1;
        }
        if (this.heuristic > o.heuristic) {
            return 1;
        }
        return this.counterAdded - o.counterAdded;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(@Nullable Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            Node other = (Node)o;
            return this.pos.getX() == other.pos.getX() && this.pos.getY() == other.pos.getY() && this.pos.getZ() == other.pos.getZ();
        }
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isLadder() {
        return this.ladder;
    }

    public boolean isSwimming() {
        return this.swimming;
    }

    public void setClosed() {
        this.closed = true;
    }

    public int getCounterVisited() {
        return this.counterVisited;
    }

    public void setCounterVisited(int counterVisited) {
        this.counterVisited = counterVisited;
    }

    public double getScore() {
        return this.score;
    }

    public double getCost() {
        return this.cost;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setLadder() {
        this.ladder = true;
    }

    public void setSwimming() {
        this.swimming = true;
    }

    public double getHeuristic() {
        return this.heuristic;
    }

    public void setCounterAdded(int counterAdded) {
        this.counterAdded = counterAdded;
    }

    public void setSteps(int steps) {
        this.steps = steps;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void setHeuristic(double heuristic) {
        this.heuristic = heuristic;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public int getCounterAdded() {
        return this.counterAdded;
    }
}

