/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.coremod.entity.ai.citizen.lumberjack.Tree;
import com.minecolonies.coremod.entity.pathfinding.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class PathJobFindTree
extends AbstractPathJob {
    private final BlockPos hutLocation;

    public PathJobFindTree(World world, @NotNull BlockPos start, BlockPos home, int range) {
        super(world, start, start, range, new TreePathResult());
        this.hutLocation = home;
    }

    @Override
    @NotNull
    public TreePathResult getResult() {
        return (TreePathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        int dx = pos.getX() - this.hutLocation.getX();
        int dy = pos.getY() - this.hutLocation.getY();
        int dz = pos.getZ() - this.hutLocation.getZ();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 0.951;
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        return n.parent != null && this.isNearTree(n);
    }

    private boolean isNearTree(@NotNull Node n) {
        if (n.pos.getX() == n.parent.pos.getX()) {
            int dz = n.pos.getZ() > n.parent.pos.getZ() ? 1 : -1;
            return this.isTree(n.pos.add(0, 0, dz)) || this.isTree(n.pos.add(-1, 0, 0)) || this.isTree(n.pos.add(1, 0, 0));
        }
        int dx = n.pos.getX() > n.parent.pos.getX() ? 1 : -1;
        return this.isTree(n.pos.add(-dx, 0, 0)) || this.isTree(n.pos.add(0, 0, -1)) || this.isTree(n.pos.add(0, 0, 1));
    }

    private boolean isTree(BlockPos pos) {
        if (Tree.checkTree(this.world, pos)) {
            this.getResult().treeLocation = pos;
            return true;
        }
        return false;
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return 0.0;
    }

    @Override
    protected boolean isPassable(@NotNull IBlockState block) {
        return super.isPassable(block) || block.getMaterial() == Material.LEAVES;
    }

    public static class TreePathResult
    extends PathResult {
        public BlockPos treeLocation;
    }
}

