/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.PathJobFindTree;
import com.minecolonies.coremod.entity.pathfinding.PathJobFindWater;
import com.minecolonies.coremod.entity.pathfinding.PathJobMoveAwayFromLocation;
import com.minecolonies.coremod.entity.pathfinding.PathJobMoveToLocation;
import com.minecolonies.coremod.entity.pathfinding.PathPointExtended;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.coremod.util.Log;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathNavigate
extends PathNavigateGround {
    public static final double MAX_PATHING_LENGTH = 36.0;
    public static final double PATHING_INTERMEDIARY_LENGTH = 16.0;
    private final EntityLiving entity;
    private double walkSpeed;
    @Nullable
    private BlockPos destination;
    @Nullable
    private BlockPos originalDestination;
    @Nullable
    private Future<Path> future;
    @Nullable
    private PathResult pathResult;

    public PathNavigate(@NotNull EntityLiving entity, World world) {
        super(entity, world);
        this.entity = entity;
        this.nodeProcessor = new WalkNodeProcessor();
    }

    @Nullable
    protected PathFinder getPathFinder() {
        return null;
    }

    protected boolean canNavigate() {
        return true;
    }

    protected Vec3d getEntityPosition() {
        return this.entity.getPositionVector();
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    @Nullable
    public Path getPathToPos(BlockPos pos) {
        return null;
    }

    public double getSpeed() {
        return this.walkSpeed;
    }

    public void setSpeed(double d) {
        this.walkSpeed = d;
    }

    public boolean tryMoveToXYZ(double x, double y, double z, double speed) {
        this.moveToXYZ(x, y, z, speed);
        return true;
    }

    public boolean tryMoveToEntityLiving(@NotNull Entity e, double speed) {
        return this.tryMoveToXYZ(e.posX, e.posY, e.posZ, speed);
    }

    @Nullable
    public PathResult moveToXYZ(double x, double y, double z, double speed) {
        int newX = MathHelper.floor_double((double)x);
        int newY = (int)y;
        int newZ = MathHelper.floor_double((double)z);
        if (this.destination != null && BlockPosUtil.isEqual(this.destination, newX, newY, newZ) || this.originalDestination != null && BlockPosUtil.isEqual(this.originalDestination, newX, newY, newZ) && this.pathResult != null && this.pathResult.isInProgress()) {
            return this.pathResult;
        }
        Vec3d moveVector = this.getEntityPosition().subtractReverse(new Vec3d((double)newX, (double)newY, (double)newZ));
        double moveLength = moveVector.lengthVector();
        if (moveLength >= 36.0 && !this.isUnableToReachDestination()) {
            Vec3d newMove = moveVector.scale(16.0 / moveLength).add(this.getEntityPosition());
            this.originalDestination = new BlockPos(newX, newY, newZ);
            newX = MathHelper.floor_double((double)newMove.xCoord);
            newY = MathHelper.floor_double((double)newMove.yCoord);
            newZ = MathHelper.floor_double((double)newMove.zCoord);
        }
        BlockPos start = AbstractPathJob.prepareStart(this.entity);
        BlockPos dest = new BlockPos(newX, newY, newZ);
        return this.setPathJob(new PathJobMoveToLocation(this.entity.worldObj, start, dest, (int)this.getPathSearchRange()), dest, speed);
    }

    public boolean isUnableToReachDestination() {
        return this.pathResult != null && this.pathResult.failedToReachDestination();
    }

    @Nullable
    private PathResult setPathJob(@NotNull AbstractPathJob job, BlockPos dest, double speed) {
        this.clearPathEntity();
        this.destination = dest;
        this.walkSpeed = speed;
        this.future = Pathfinding.enqueue(job);
        this.pathResult = job.getResult();
        return this.pathResult;
    }

    public boolean setPath(@NotNull Path path, double speed) {
        int pathLength = path.getCurrentPathLength();
        Path tempPath = null;
        if (pathLength > 0 && !(path.getPathPointFromIndex(0) instanceof PathPointExtended)) {
            PathPoint[] newPoints = new PathPointExtended[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                PathPoint point = path.getPathPointFromIndex(i);
                newPoints[i] = new PathPointExtended(new BlockPos(point.xCoord, point.yCoord, point.zCoord));
            }
            tempPath = new Path(newPoints);
            PathPoint finalPoint = newPoints[pathLength - 1];
            this.destination = new BlockPos(finalPoint.xCoord, finalPoint.yCoord, finalPoint.zCoord);
        }
        return super.setPath(tempPath == null ? path : tempPath, speed);
    }

    public void onUpdateNavigation() {
        if (this.future != null) {
            if (!this.future.isDone()) {
                return;
            }
            try {
                if (this.future.get() == null) {
                    this.future = null;
                    return;
                }
                this.setPath(this.future.get(), this.walkSpeed);
                this.pathResult.setPathLength(this.getPath().getCurrentPathLength());
                this.pathResult.setStatus(PathResult.Status.IN_PROGRESS_FOLLOWING);
                PathPoint p = this.getPath().getFinalPathPoint();
                if (p != null && this.destination == null) {
                    this.destination = new BlockPos(p.xCoord, p.yCoord, p.zCoord);
                    this.pathResult.setPathReachesDestination(true);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Log.getLogger().catching((Throwable)e);
            }
            this.future = null;
        }
        int oldIndex = this.noPath() ? 0 : this.getPath().getCurrentPathIndex();
        super.onUpdateNavigation();
        if (!this.noPath()) {
            PathPointExtended pEx = (PathPointExtended)this.getPath().getPathPointFromIndex(this.getPath().getCurrentPathIndex());
            if (pEx.isOnLadder()) {
                Vec3d vec3 = this.getPath().getPosition((Entity)this.entity);
                if (vec3.squareDistanceTo(this.entity.posX, vec3.yCoord, this.entity.posZ) < 0.1) {
                    double newSpeed = 0.05;
                    switch (pEx.getLadderFacing()) {
                        case NORTH: {
                            vec3.addVector(0.0, 0.0, 1.0);
                            break;
                        }
                        case SOUTH: {
                            vec3.addVector(0.0, 0.0, -1.0);
                            break;
                        }
                        case WEST: {
                            vec3.addVector(1.0, 0.0, 0.0);
                            break;
                        }
                        case EAST: {
                            vec3.addVector(-1.0, 0.0, 0.0);
                            break;
                        }
                        default: {
                            newSpeed = 0.0;
                        }
                    }
                    this.entity.getMoveHelper().setMoveTo(vec3.xCoord, vec3.yCoord, vec3.zCoord, newSpeed);
                }
            } else if (this.entity.isInWater()) {
                int curIndex = this.getPath().getCurrentPathIndex();
                if (curIndex > 0 && curIndex + 1 < this.getPath().getCurrentPathLength() && this.getPath().getPathPointFromIndex((int)(curIndex - 1)).yCoord != pEx.yCoord) {
                    oldIndex = curIndex + 1;
                }
                this.getPath().setCurrentPathIndex(oldIndex);
                Vec3d Vec3d2 = this.getPath().getPosition((Entity)this.entity);
                Vec3d vec3d = new Vec3d(this.entity.posX, Vec3d2.yCoord, this.entity.posZ);
                if (Vec3d2.squareDistanceTo(vec3d) < 0.1 && Math.abs(this.entity.posY - Vec3d2.yCoord) < 0.5) {
                    this.getPath().setCurrentPathIndex(this.getPath().getCurrentPathIndex() + 1);
                    if (this.noPath()) {
                        return;
                    }
                    Vec3d2 = this.getPath().getPosition((Entity)this.entity);
                }
                this.entity.getMoveHelper().setMoveTo(Vec3d2.xCoord, Vec3d2.yCoord, Vec3d2.zCoord, this.walkSpeed);
            } else {
                this.speed = BlockUtils.isPathBlock(this.worldObj.getBlockState(this.entity.getPosition().down()).getBlock()) ? 1.3 : 1.0;
            }
        }
        if (this.pathResult != null && this.noPath()) {
            this.pathResult.setStatus(PathResult.Status.COMPLETE);
            this.pathResult = null;
        }
    }

    protected void pathFollow() {
        int curNode = this.currentPath.getCurrentPathIndex();
        int curNodeNext = curNode + 1;
        if (curNodeNext < this.currentPath.getCurrentPathLength()) {
            PathPointExtended pEx = (PathPointExtended)this.currentPath.getPathPointFromIndex(curNode);
            PathPointExtended pExNext = (PathPointExtended)this.currentPath.getPathPointFromIndex(curNodeNext);
            if (pEx.isOnLadder() && pEx.getLadderFacing() == EnumFacing.DOWN && !pExNext.isOnLadder()) {
                Vec3d vec3 = this.getEntityPosition();
                if (vec3.yCoord - (double)pEx.yCoord < 0.001) {
                    this.currentPath.setCurrentPathIndex(curNodeNext);
                }
                this.checkForStuck(vec3);
                return;
            }
        }
        super.pathFollow();
    }

    public boolean noPath() {
        return this.future == null && super.noPath();
    }

    public void clearPathEntity() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        if (this.pathResult != null) {
            this.pathResult.setStatus(PathResult.Status.CANCELLED);
            this.pathResult = null;
        }
        this.destination = null;
        super.clearPathEntity();
    }

    public PathJobFindTree.TreePathResult moveToTree(int range, double speed) {
        BlockPos start = AbstractPathJob.prepareStart(this.entity);
        return (PathJobFindTree.TreePathResult)this.setPathJob(new PathJobFindTree(this.entity.worldObj, start, ((EntityCitizen)this.entity).getWorkBuilding().getLocation(), range), null, speed);
    }

    @Nullable
    public PathJobFindWater.WaterPathResult moveToWater(int range, double speed, List<BlockPos> ponds) {
        BlockPos start = AbstractPathJob.prepareStart(this.entity);
        return (PathJobFindWater.WaterPathResult)this.setPathJob(new PathJobFindWater(this.entity.worldObj, start, ((EntityCitizen)this.entity).getWorkBuilding().getLocation(), range, ponds), null, speed);
    }

    @Nullable
    public PathResult moveToEntityLiving(@NotNull Entity e, double speed) {
        return this.moveToXYZ(e.posX, e.posY, e.posZ, speed);
    }

    @Nullable
    public PathResult moveAwayFromEntityLiving(@NotNull Entity e, double distance, double speed) {
        return this.moveAwayFromXYZ(e.getPosition(), distance, speed);
    }

    @Nullable
    public PathResult moveAwayFromXYZ(BlockPos avoid, double range, double speed) {
        BlockPos start = AbstractPathJob.prepareStart(this.entity);
        return this.setPathJob(new PathJobMoveAwayFromLocation(this.entity.worldObj, start, avoid, (int)range, (int)this.getPathSearchRange()), null, speed);
    }
}

