/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.EntityUtils;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WalkToProxy {
    private static final int MIN_RANGE_FOR_DIRECT_PATH = 400;
    private static final int MIN_DISTANCE = 25;
    private static final int OTHER_SIDE_OF_SHAFT = 6;
    private final EntityCitizen worker;
    private BlockPos currentProxy;
    private ArrayList<BlockPos> proxyList = new ArrayList();
    private BlockPos target;

    public WalkToProxy(EntityCitizen worker) {
        this.worker = worker;
    }

    public boolean walkToBlock(@NotNull BlockPos target, int range) {
        return this.walkToBlock(target, range, false);
    }

    private boolean takeTheDirectPath(@NotNull BlockPos target, int range, boolean onMove) {
        if (onMove) {
            int targetY = this.worker.getColonyJob() instanceof JobBuilder ? this.worker.getPosition().getY() : target.getY();
            return EntityUtils.isWorkerAtSiteWithMove(this.worker, target.getX(), target.getY(), target.getZ(), range) || EntityUtils.isWorkerAtSite(this.worker, target.getX(), targetY, target.getZ(), range + 1);
        }
        return !EntityUtils.isWorkerAtSite(this.worker, target.getX(), target.getY(), target.getZ(), range);
    }

    public boolean walkToBlock(@NotNull BlockPos target, int range, boolean onMove) {
        double distanceProxyNextProxy;
        double distanceToPath;
        if (!target.equals((Object)this.target)) {
            this.reset();
            this.target = target;
        }
        double d = distanceToPath = this.worker.getColonyJob() instanceof JobBuilder ? (double)BlockPosUtil.getDistanceSquared2D(this.worker.getPosition(), target) : (double)BlockPosUtil.getDistanceSquared(this.worker.getPosition(), target);
        if (distanceToPath <= 400.0) {
            this.currentProxy = distanceToPath <= 25.0 ? null : target;
            this.proxyList = new ArrayList();
            return this.takeTheDirectPath(target, range, onMove);
        }
        if (this.currentProxy == null) {
            this.currentProxy = this.fillProxyList(target, distanceToPath);
        }
        double distanceToProxy = BlockPosUtil.getDistanceSquared2D(this.worker.getPosition(), this.currentProxy);
        double distanceToNextProxy = this.proxyList.isEmpty() ? (double)BlockPosUtil.getDistanceSquared2D(this.worker.getPosition(), target) : (double)BlockPosUtil.getDistanceSquared2D(this.worker.getPosition(), this.proxyList.get(0));
        double d2 = distanceProxyNextProxy = this.proxyList.isEmpty() ? (double)BlockPosUtil.getDistanceSquared2D(this.currentProxy, target) : (double)BlockPosUtil.getDistanceSquared2D(this.currentProxy, this.proxyList.get(0));
        if (distanceToProxy < 25.0 || distanceToNextProxy < distanceProxyNextProxy) {
            if (this.proxyList.isEmpty()) {
                this.currentProxy = target;
            }
            if (this.proxyList.isEmpty()) {
                return this.takeTheDirectPath(target, range, onMove);
            }
            this.worker.getNavigator().clearPathEntity();
            this.currentProxy = this.proxyList.get(0);
            this.proxyList.remove(0);
        }
        if (this.currentProxy != null && !EntityUtils.isWorkerAtSiteWithMove(this.worker, this.currentProxy.getX(), this.currentProxy.getY(), this.currentProxy.getZ(), range)) {
            return !onMove;
        }
        return !onMove;
    }

    @NotNull
    private BlockPos fillProxyList(@NotNull BlockPos target, double distanceToPath) {
        AbstractBuildingWorker building = this.worker.getWorkBuilding();
        BlockPos proxyPoint = this.worker.getColonyJob() != null && this.worker.getColonyJob() instanceof JobMiner && building instanceof BuildingMiner ? this.getMinerProxy(target, distanceToPath, (BuildingMiner)building) : this.getProxy(target, this.worker.getPosition(), distanceToPath);
        if (!this.proxyList.isEmpty()) {
            this.proxyList.remove(0);
        }
        return proxyPoint;
    }

    public void reset() {
        this.currentProxy = null;
        this.proxyList = new ArrayList();
    }

    @NotNull
    private BlockPos getMinerProxy(BlockPos target, double distanceToPath, @NotNull BuildingMiner building) {
        Level level = building.getCurrentLevel();
        BlockPos ladderPos = building.getLadderLocation();
        if (level != null) {
            int levelDepth = level.getDepth() + 2;
            int targetY = target.getY();
            int workerY = this.worker.getPosition().getY();
            if (workerY <= levelDepth && targetY > levelDepth) {
                if (level.getRandomNode() != null && level.getRandomNode().getParent() != null) {
                    Node currentNode = level.getNode(level.getRandomNode().getParent());
                    while (new Point2D.Double(currentNode.getX(), currentNode.getZ()) != currentNode.getParent() && currentNode.getParent() != null) {
                        this.proxyList.add(new BlockPos(currentNode.getX(), (double)levelDepth, currentNode.getZ()));
                        currentNode = level.getNode(currentNode.getParent());
                    }
                }
                this.proxyList.add(new BlockPos(ladderPos.getX() + building.getVectorX() * 6, level.getDepth(), ladderPos.getZ() + building.getVectorZ() * 6));
                return this.getProxy(target, this.worker.getPosition(), distanceToPath);
            }
            if (targetY <= levelDepth && workerY > levelDepth) {
                BlockPos buildingPos = building.getLocation();
                BlockPos newProxy = this.getProxy(buildingPos, this.worker.getPosition(), BlockPosUtil.getDistanceSquared(this.worker.getPosition(), buildingPos));
                this.proxyList.add(new BlockPos(ladderPos.getX() + building.getVectorX() * 6, level.getDepth(), ladderPos.getZ() + building.getVectorZ() * 6));
                if (level.getRandomNode() != null && level.getRandomNode().getParent() != null) {
                    ArrayList<BlockPos> nodesToTarget = new ArrayList<BlockPos>();
                    Node currentNode = level.getNode(level.getRandomNode().getParent());
                    while (new Point2D.Double(currentNode.getX(), currentNode.getZ()) != currentNode.getParent() && currentNode.getParent() != null) {
                        nodesToTarget.add(new BlockPos(currentNode.getX(), (double)levelDepth, currentNode.getZ()));
                        currentNode = level.getNode(currentNode.getParent());
                    }
                    for (int i = nodesToTarget.size() - 1; i >= 0; --i) {
                        this.proxyList.add((BlockPos)nodesToTarget.get(i));
                    }
                }
                return newProxy;
            }
            if (targetY <= levelDepth) {
                double closestNode = Double.MAX_VALUE;
                Node lastNode = null;
                for (Map.Entry<Point2D, Node> node : level.getNodes().entrySet()) {
                    double distanceToNode = node.getKey().distance(this.worker.getPosition().getX(), this.worker.getPosition().getZ());
                    if (!(distanceToNode < closestNode)) continue;
                    lastNode = node.getValue();
                    closestNode = distanceToNode;
                }
                if (lastNode != null && lastNode.getParent() != null) {
                    Object currentNode = level.getNode(lastNode.getParent());
                    while (new Point2D.Double(((Node)currentNode).getX(), ((Node)currentNode).getZ()) != ((Node)currentNode).getParent() && ((Node)currentNode).getParent() != null) {
                        this.proxyList.add(new BlockPos(((Node)currentNode).getX(), (double)levelDepth, ((Node)currentNode).getZ()));
                        currentNode = level.getNode(((Node)currentNode).getParent());
                    }
                }
                if (level.getRandomNode().getParent() != null) {
                    ArrayList<BlockPos> nodesToTarget = new ArrayList<BlockPos>();
                    Node currentNode = level.getNode(level.getRandomNode().getParent());
                    while (new Point2D.Double(currentNode.getX(), currentNode.getZ()) != currentNode.getParent() && currentNode.getParent() != null) {
                        nodesToTarget.add(new BlockPos(currentNode.getX(), (double)levelDepth, currentNode.getZ()));
                        currentNode = level.getNode(currentNode.getParent());
                    }
                    for (int i = nodesToTarget.size() - 1; i >= 0; --i) {
                        this.proxyList.add((BlockPos)nodesToTarget.get(i));
                    }
                }
                if (!this.proxyList.isEmpty()) {
                    return this.proxyList.get(0);
                }
                return target;
            }
        }
        return this.getProxy(target, this.worker.getPosition(), distanceToPath);
    }

    @NotNull
    private BlockPos getProxy(@NotNull BlockPos target, @NotNull BlockPos position, double distanceToPath) {
        if (this.worker.getColony() == null) {
            return target;
        }
        double weight = Double.MAX_VALUE;
        BlockPos proxyPoint = null;
        for (BlockPos wayPoint : this.worker.getColony().getWayPoints(position, target)) {
            double simpleDistance = BlockPosUtil.getDistanceSquared(position, wayPoint);
            double currentWeight = simpleDistance * simpleDistance + (double)BlockPosUtil.getDistanceSquared(wayPoint, target);
            if (!(currentWeight < weight) || !((double)BlockPosUtil.getDistanceSquared2D(wayPoint, target) < distanceToPath) || !(simpleDistance > 25.0) || !(simpleDistance < distanceToPath) || this.proxyList.contains(proxyPoint)) continue;
            proxyPoint = wayPoint;
            weight = currentWeight;
        }
        if (this.proxyList.contains(proxyPoint)) {
            proxyPoint = null;
        }
        if (proxyPoint != null) {
            this.proxyList.add(proxyPoint);
            this.getProxy(target, proxyPoint, distanceToPath);
            return this.proxyList.get(0);
        }
        return target;
    }
}

