/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.items.ModItems;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class GuardScepterMessage
extends AbstractMessage<GuardScepterMessage, IMessage> {
    private int taskId;
    private BlockPos buildingId;

    public GuardScepterMessage() {
    }

    public GuardScepterMessage(int taskId, BlockPos buildingId) {
        this.taskId = taskId;
        this.buildingId = buildingId;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.taskId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.taskId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
    }

    @Override
    public void messageOnServerThread(GuardScepterMessage message, EntityPlayerMP player) {
        NBTTagCompound compound;
        ItemStack scepter = new ItemStack(ModItems.scepterGuard);
        if (!scepter.hasTagCompound()) {
            scepter.setTagCompound(new NBTTagCompound());
        }
        if ((compound = scepter.getTagCompound()) == null) {
            return;
        }
        compound.setInteger("task", message.taskId);
        int emptySlot = player.inventory.getFirstEmptyStack();
        BlockPosUtil.writeToNBT(compound, "pos", message.buildingId);
        ItemStack item = player.inventory.getStackInSlot(player.inventory.currentItem);
        player.inventory.setInventorySlotContents(emptySlot, item);
        player.inventory.setInventorySlotContents(player.inventory.currentItem, scepter);
        player.inventory.markDirty();
    }
}

