/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.inventory.InventoryField;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class OpenInventoryMessage
extends AbstractMessage<OpenInventoryMessage, IMessage> {
    private String name;
    private InventoryType inventoryType;
    private int entityID;
    private BlockPos tePos;
    private int colonyId;

    public OpenInventoryMessage() {
    }

    public OpenInventoryMessage(@NotNull CitizenDataView citizen) {
        this.inventoryType = InventoryType.INVENTORY_CITIZEN;
        this.name = citizen.getName();
        this.entityID = citizen.getEntityId();
    }

    public OpenInventoryMessage(@NotNull AbstractBuilding.View building) {
        this.inventoryType = InventoryType.INVENTORY_CHEST;
        this.name = "";
        this.tePos = building.getLocation();
    }

    public OpenInventoryMessage(BlockPos field, int colonyId) {
        this.inventoryType = InventoryType.INVENTORY_FIELD;
        this.name = "field";
        this.tePos = field;
        this.colonyId = colonyId;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.inventoryType = InventoryType.values()[buf.readInt()];
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                this.entityID = buf.readInt();
                break;
            }
            case INVENTORY_CHEST: {
                this.tePos = BlockPosUtil.readFromByteBuf(buf);
                break;
            }
            case INVENTORY_FIELD: {
                this.colonyId = buf.readInt();
                this.tePos = BlockPosUtil.readFromByteBuf(buf);
            }
        }
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.inventoryType.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                buf.writeInt(this.entityID);
                break;
            }
            case INVENTORY_CHEST: {
                BlockPosUtil.writeToByteBuf(buf, this.tePos);
                break;
            }
            case INVENTORY_FIELD: {
                buf.writeInt(this.colonyId);
                BlockPosUtil.writeToByteBuf(buf, this.tePos);
            }
        }
    }

    @Override
    public void messageOnServerThread(OpenInventoryMessage message, EntityPlayerMP player) {
        switch (message.inventoryType) {
            case INVENTORY_CITIZEN: {
                OpenInventoryMessage.doCitizenInventory(message, player);
                break;
            }
            case INVENTORY_CHEST: {
                OpenInventoryMessage.doHutInventory(message, player);
                break;
            }
            case INVENTORY_FIELD: {
                OpenInventoryMessage.doFieldInventory(message, player);
                break;
            }
        }
    }

    private static void doCitizenInventory(OpenInventoryMessage message, EntityPlayerMP player) {
        EntityCitizen citizen = (EntityCitizen)player.worldObj.getEntityByID(message.entityID);
        if (citizen != null && OpenInventoryMessage.checkPermissions(citizen.getColony(), player)) {
            if (!StringUtils.isNullOrEmpty((String)message.name)) {
                citizen.getInventoryCitizen().setCustomName(message.name);
            }
            player.displayGUIChest((IInventory)citizen.getInventoryCitizen());
        }
    }

    private static void doHutInventory(OpenInventoryMessage message, EntityPlayerMP player) {
        if (OpenInventoryMessage.checkPermissions(ColonyManager.getClosestColony(player.getEntityWorld(), message.tePos), player)) {
            TileEntityChest chest = (TileEntityChest)BlockPosUtil.getTileEntity(player.worldObj, message.tePos);
            if (!StringUtils.isNullOrEmpty((String)message.name)) {
                chest.setCustomName(message.name);
            }
            player.displayGUIChest((IInventory)chest);
        }
    }

    private static void doFieldInventory(OpenInventoryMessage message, EntityPlayerMP player) {
        if (OpenInventoryMessage.checkPermissions(ColonyManager.getClosestColony(player.getEntityWorld(), message.tePos), player)) {
            InventoryField inventoryField = ColonyManager.getColony(message.colonyId).getField(message.tePos).getInventoryField();
            if (!StringUtils.isNullOrEmpty((String)message.name)) {
                inventoryField.setCustomName(message.name);
            }
            player.displayGUIChest((IInventory)inventoryField);
        }
    }

    private static boolean checkPermissions(Colony colony, EntityPlayerMP player) {
        return colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.MANAGE_HUTS);
    }

    private static enum InventoryType {
        INVENTORY_CITIZEN,
        INVENTORY_CHEST,
        INVENTORY_FIELD;

    }
}

