/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.network.PacketUtils;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import com.minecolonies.coremod.util.Log;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionsMessage {
    private static final String COLONY_DOES_NOT_EXIST = "Colony #%d does not exist.";

    public static class RemovePlayer
    extends AbstractMessage<RemovePlayer, IMessage> {
        private int colonyID;
        private UUID playerID;

        public RemovePlayer() {
        }

        public RemovePlayer(@NotNull ColonyView colony, UUID player) {
            this.colonyID = colony.getID();
            this.playerID = player;
        }

        public void toBytes(@NotNull ByteBuf buf) {
            buf.writeInt(this.colonyID);
            PacketUtils.writeUUID(buf, this.playerID);
        }

        public void fromBytes(@NotNull ByteBuf buf) {
            this.colonyID = buf.readInt();
            this.playerID = PacketUtils.readUUID(buf);
        }

        @Override
        public void messageOnServerThread(RemovePlayer message, EntityPlayerMP player) {
            Colony colony = ColonyManager.getColony(message.colonyID);
            if (colony == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, message.colonyID));
                return;
            }
            Permissions.Player permissionsPlayer = colony.getPermissions().getPlayers().get(message.playerID);
            if (permissionsPlayer.getRank() == Permissions.Rank.HOSTILE && colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.EDIT_PERMISSIONS) || permissionsPlayer.getRank() != Permissions.Rank.HOSTILE && colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.EDIT_PERMISSIONS) && colony.getPermissions().getRank((EntityPlayer)player).ordinal() < colony.getPermissions().getRank(message.playerID).ordinal() || player.getUniqueID().equals(message.playerID)) {
                colony.getPermissions().removePlayer(message.playerID);
            }
        }
    }

    public static class ChangePlayerRank
    extends AbstractMessage<ChangePlayerRank, IMessage> {
        private int colonyID;
        private UUID playerID;
        private Type type;

        public ChangePlayerRank() {
        }

        public ChangePlayerRank(@NotNull ColonyView colony, UUID player, Type type) {
            this.colonyID = colony.getID();
            this.playerID = player;
            this.type = type;
        }

        public void toBytes(@NotNull ByteBuf buf) {
            buf.writeInt(this.colonyID);
            PacketUtils.writeUUID(buf, this.playerID);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.type.name());
        }

        public void fromBytes(@NotNull ByteBuf buf) {
            this.colonyID = buf.readInt();
            this.playerID = PacketUtils.readUUID(buf);
            this.type = Type.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }

        @Override
        public void messageOnServerThread(ChangePlayerRank message, EntityPlayerMP player) {
            Colony colony = ColonyManager.getColony(message.colonyID);
            if (colony == null || colony.getWorld() == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, message.colonyID));
                return;
            }
            if (colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.EDIT_PERMISSIONS)) {
                if (message.type == Type.PROMOTE && colony.getPermissions().getRank((EntityPlayer)player).ordinal() < colony.getPermissions().getRank(message.playerID).ordinal()) {
                    colony.getPermissions().setPlayerRank(message.playerID, Permissions.getPromotionRank(colony.getPermissions().getRank(message.playerID)), colony.getWorld());
                } else if (message.type == Type.DEMOTE && (colony.getPermissions().getRank((EntityPlayer)player).ordinal() < colony.getPermissions().getRank(message.playerID).ordinal() || player.getUniqueID().equals(message.playerID))) {
                    colony.getPermissions().setPlayerRank(message.playerID, Permissions.getDemotionRank(colony.getPermissions().getRank(message.playerID)), colony.getWorld());
                }
            }
        }

        public static enum Type {
            PROMOTE,
            DEMOTE;

        }
    }

    public static class AddPlayer
    extends AbstractMessage<AddPlayer, IMessage> {
        private int colonyID;
        private String playerName;

        public AddPlayer() {
        }

        public AddPlayer(@NotNull ColonyView colony, String player) {
            this.colonyID = colony.getID();
            this.playerName = player;
        }

        public void toBytes(@NotNull ByteBuf buf) {
            buf.writeInt(this.colonyID);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
        }

        public void fromBytes(@NotNull ByteBuf buf) {
            this.colonyID = buf.readInt();
            this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        @Override
        public void messageOnServerThread(AddPlayer message, EntityPlayerMP player) {
            Colony colony = ColonyManager.getColony(message.colonyID);
            if (colony != null && colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.CAN_PROMOTE) && colony.getWorld() != null) {
                colony.getPermissions().addPlayer(message.playerName, Permissions.Rank.NEUTRAL, colony.getWorld());
            } else {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, message.colonyID));
            }
        }
    }

    public static class Permission
    extends AbstractMessage<Permission, IMessage> {
        private int colonyID;
        private MessageType type;
        private Permissions.Rank rank;
        private Permissions.Action action;

        public Permission() {
        }

        public Permission(@NotNull ColonyView colony, MessageType type, Permissions.Rank rank, Permissions.Action action) {
            this.colonyID = colony.getID();
            this.type = type;
            this.rank = rank;
            this.action = action;
        }

        @Override
        public void messageOnServerThread(Permission message, EntityPlayerMP player) {
            Colony colony = ColonyManager.getColony(message.colonyID);
            if (colony == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, message.colonyID));
                return;
            }
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Permissions.Action.EDIT_PERMISSIONS)) {
                return;
            }
            switch (message.type) {
                case SET_PERMISSION: {
                    colony.getPermissions().setPermission(message.rank, message.action);
                    break;
                }
                case REMOVE_PERMISSION: {
                    colony.getPermissions().removePermission(message.rank, message.action);
                    break;
                }
                case TOGGLE_PERMISSION: {
                    colony.getPermissions().togglePermission(message.rank, message.action);
                    break;
                }
                default: {
                    Log.getLogger().error(String.format("Invalid MessageType %s", message.type.toString()));
                }
            }
        }

        public void toBytes(@NotNull ByteBuf buf) {
            buf.writeInt(this.colonyID);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.type.name());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.rank.name());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.action.name());
        }

        public void fromBytes(@NotNull ByteBuf buf) {
            this.colonyID = buf.readInt();
            this.type = MessageType.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.rank = Permissions.Rank.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.action = Permissions.Action.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public static class View
    implements IMessage,
    IMessageHandler<View, IMessage> {
        private int colonyID;
        private ByteBuf data;

        public View() {
        }

        public View(@NotNull Colony colony, @NotNull Permissions.Rank viewerRank) {
            this.colonyID = colony.getID();
            this.data = Unpooled.buffer();
            colony.getPermissions().serializeViewNetworkData(this.data, viewerRank);
        }

        public void fromBytes(@NotNull ByteBuf buf) {
            this.colonyID = buf.readInt();
            this.data = buf;
        }

        @Nullable
        public IMessage onMessage(@NotNull View message, MessageContext ctx) {
            return ColonyManager.handlePermissionsViewMessage(message.colonyID, message.data);
        }

        public void toBytes(@NotNull ByteBuf buf) {
            buf.writeInt(this.colonyID);
            buf.writeBytes(this.data);
        }
    }

    public static enum MessageType {
        SET_PERMISSION,
        REMOVE_PERMISSION,
        TOGGLE_PERMISSION;

    }
}

