/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import com.minecolonies.coremod.util.EntityUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockPosUtil {
    private static final double CLOSE_DISTANCE = 4.84;
    private static final int MAX_DEPTH = 50;
    private static final int BLOCKPOS_LENGTH = 3;

    private BlockPosUtil() {
    }

    public static void writeToNBT(@NotNull NBTTagCompound compound, String name, @NotNull BlockPos pos) {
        NBTTagCompound coordsCompound = new NBTTagCompound();
        coordsCompound.setInteger("x", pos.getX());
        coordsCompound.setInteger("y", pos.getY());
        coordsCompound.setInteger("z", pos.getZ());
        compound.setTag(name, (NBTBase)coordsCompound);
    }

    @NotNull
    public static BlockPos readFromNBT(@NotNull NBTTagCompound compound, String name) {
        NBTTagCompound coordsCompound = compound.getCompoundTag(name);
        int x = coordsCompound.getInteger("x");
        int y = coordsCompound.getInteger("y");
        int z = coordsCompound.getInteger("z");
        return new BlockPos(x, y, z);
    }

    public static void writeToNBTTagList(@NotNull NBTTagList tagList, @NotNull BlockPos pos) {
        NBTTagCompound coordsCompound = new NBTTagCompound();
        coordsCompound.setInteger("x", pos.getX());
        coordsCompound.setInteger("y", pos.getY());
        coordsCompound.setInteger("z", pos.getZ());
        tagList.appendTag((NBTBase)coordsCompound);
    }

    @NotNull
    public static BlockPos readFromNBTTagList(@NotNull NBTTagList tagList, int index) {
        NBTTagCompound coordsCompound = tagList.getCompoundTagAt(index);
        int x = coordsCompound.getInteger("x");
        int y = coordsCompound.getInteger("y");
        int z = coordsCompound.getInteger("z");
        return new BlockPos(x, y, z);
    }

    public static void writeToByteBuf(@NotNull ByteBuf buf, @NotNull BlockPos pos) {
        buf.writeInt(pos.getX());
        buf.writeInt(pos.getY());
        buf.writeInt(pos.getZ());
    }

    @NotNull
    public static BlockPos readFromByteBuf(@NotNull ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        return new BlockPos(x, y, z);
    }

    @Nullable
    public static BlockPos getBlockPosOfString(@NotNull String inputText) {
        String[] strings = inputText.split(" ");
        if (strings.length == 3) {
            try {
                int x = Integer.parseInt(strings[0]);
                int y = Integer.parseInt(strings[1]);
                int z = Integer.parseInt(strings[2]);
                return new BlockPos(x, y, z);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isPositionSafe(@NotNull ICommandSender sender, BlockPos blockPos) {
        return sender.getEntityWorld().getBlockState(blockPos).getBlock() != Blocks.AIR && !sender.getEntityWorld().getBlockState(blockPos).getMaterial().isLiquid() && !sender.getEntityWorld().getBlockState(blockPos.up()).getMaterial().isLiquid();
    }

    public static BlockPos findLand(BlockPos blockPos, World world) {
        int top = blockPos.getY();
        int bot = 0;
        int mid = blockPos.getY();
        BlockPos foundland = null;
        BlockPos tempPos = blockPos;
        while (top >= bot) {
            Block blocks = world.getBlockState(tempPos = new BlockPos(tempPos.getX(), mid, tempPos.getZ())).getBlock();
            if (blocks == Blocks.AIR && world.canSeeSky(tempPos)) {
                top = mid - 1;
                foundland = tempPos;
            } else {
                bot = mid + 1;
                foundland = tempPos;
            }
            mid = (bot + top) / 2;
        }
        return foundland;
    }

    public static boolean isClose(@NotNull BlockPos coordinate, @NotNull EntityCitizen citizen) {
        return (double)BlockPosUtil.getDistanceSquared(coordinate, citizen.getPosition()) < 4.84;
    }

    public static long getDistanceSquared(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long zDiff;
        long yDiff;
        long xDiff = (long)block1.getX() - (long)block2.getX();
        long result = xDiff * xDiff + (yDiff = (long)block1.getY() - (long)block2.getY()) * yDiff + (zDiff = (long)block1.getZ() - (long)block2.getZ()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + yDiff + " | " + zDiff);
        }
        return result;
    }

    public static long getDistance(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long xDiff = (long)block1.getX() - (long)block2.getX();
        long yDiff = (long)block1.getY() - (long)block2.getY();
        long zDiff = (long)block1.getZ() - (long)block2.getZ();
        return Math.abs(xDiff + yDiff + zDiff);
    }

    public static long getDistance2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long xDiff = Math.abs((long)block1.getX() - (long)block2.getX());
        long zDiff = Math.abs((long)block1.getZ() - (long)block2.getZ());
        return Math.abs(xDiff + zDiff);
    }

    public static long getDistanceSquared2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long zDiff;
        long xDiff = (long)block1.getX() - (long)block2.getX();
        long result = xDiff * xDiff + (zDiff = (long)block1.getZ() - (long)block2.getZ()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + zDiff);
        }
        return result;
    }

    public static TileEntity getTileEntity(@NotNull World world, @NotNull BlockPos pos) {
        return world.getTileEntity(pos);
    }

    public static List<ItemStack> getBlockDrops(@NotNull World world, @NotNull BlockPos coords, int fortune) {
        return BlockPosUtil.getBlock(world, coords).getDrops((IBlockAccess)world, new BlockPos(coords.getX(), coords.getY(), coords.getZ()), BlockPosUtil.getBlockState(world, coords), fortune);
    }

    public static Block getBlock(@NotNull World world, @NotNull BlockPos coords) {
        return world.getBlockState(coords).getBlock();
    }

    public static IBlockState getBlockState(@NotNull World world, @NotNull BlockPos coords) {
        return world.getBlockState(coords);
    }

    public static boolean setBlock(@NotNull World world, BlockPos coords, @NotNull Block block) {
        return world.setBlockState(coords, block.getDefaultState());
    }

    public static boolean setBlock(@NotNull World worldIn, @NotNull BlockPos coords, IBlockState state, int flag) {
        return worldIn.setBlockState(coords, state, flag);
    }

    public static boolean isPathingTo(@NotNull EntityCitizen citizen, @NotNull BlockPos pos) {
        return EntityUtils.isPathingTo(citizen, pos.getX(), pos.getZ());
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, @NotNull BlockPos site) {
        return EntityUtils.isWorkerAtSiteWithMove(worker, site.getX(), site.getY(), site.getZ());
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, @NotNull BlockPos site, int range) {
        return EntityUtils.isWorkerAtSiteWithMove(worker, site.getX(), site.getY(), site.getZ(), range);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull EntityLiving living, @NotNull BlockPos destination) {
        return EntityUtils.tryMoveLivingToXYZ(living, destination.getX(), destination.getY(), destination.getZ());
    }

    public static PathResult moveLivingToXYZ(@NotNull EntityCitizen citizen, @NotNull BlockPos destination) {
        return citizen.getNavigator().moveToXYZ(destination.getX(), destination.getY(), destination.getZ(), 1.0);
    }

    public static void set(@NotNull BlockPos.MutableBlockPos pos, @NotNull BlockPos newPos) {
        pos.setPos(newPos.getX(), newPos.getY(), newPos.getZ());
    }

    public static boolean isEqual(@NotNull BlockPos coords, int x, int y, int z) {
        return coords.getX() == x && coords.getY() == y && coords.getZ() == z;
    }

    @NotNull
    public static BlockPos fromEntity(@NotNull Entity entity) {
        return new BlockPos(MathHelper.floor_double((double)entity.posX), MathHelper.floor_double((double)entity.posY), MathHelper.floor_double((double)entity.posZ));
    }

    @NotNull
    public static BlockPos getFloor(@NotNull BlockPos position, @NotNull World world) {
        BlockPos floor = BlockPosUtil.getFloor(position, 0, world);
        if (floor == null) {
            return position;
        }
        return floor;
    }

    @Nullable
    private static BlockPos getFloor(@NotNull BlockPos position, int depth, @NotNull World world) {
        if (depth > 50) {
            return null;
        }
        if (!EntityUtils.solidOrLiquid(world, position)) {
            return BlockPosUtil.getFloor(position.down(), depth + 1, world);
        }
        if (!EntityUtils.solidOrLiquid(world, position.up())) {
            return position;
        }
        return BlockPosUtil.getFloor(position.up(), depth + 1, world);
    }
}

