/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.blocks.AbstractBlockHut;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPurpurSlab;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockStoneSlabNew;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockUtils {
    @NotNull
    private static final List<BiPredicate<Block, IBlockState>> freeToPlaceBlocks = Arrays.asList((block, iBlockState) -> block.equals(Blocks.AIR), (block, iBlockState) -> iBlockState.getMaterial().isLiquid(), (block, iBlockState) -> BlockUtils.isWater(block.getDefaultState()), (block, iBlockState) -> block.equals(Blocks.LEAVES), (block, iBlockState) -> block.equals(Blocks.LEAVES2), (block, iBlockState) -> block.equals(Blocks.DOUBLE_PLANT), (block, iBlockState) -> block.equals(Blocks.GRASS), (block, iBlockState) -> block instanceof BlockDoor && iBlockState != null && (Boolean)iBlockState.getValue((IProperty)PropertyBool.create((String)"upper")) != false);

    private BlockUtils() {
    }

    public static Rotation getRotation(int rotation) {
        switch (rotation) {
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static IBlockState getSubstitutionBlockAtWorld(@NotNull World world, @NotNull BlockPos location) {
        IBlockState filler = world.getBiome((BlockPos)location).fillerBlock;
        if (filler.getBlock() instanceof BlockFalling) {
            return Blocks.DIRT.getDefaultState();
        }
        return filler;
    }

    public static boolean shouldNeverBeMessedWith(Block block) {
        return block instanceof AbstractBlockHut || Objects.equals(block, Blocks.BEDROCK);
    }

    public static int getRotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                return 2;
            }
            case EAST: {
                return 1;
            }
            case WEST: {
                return 3;
            }
        }
        return 0;
    }

    public static boolean freeToPlace(Block block) {
        return BlockUtils.freeToPlace(block, null);
    }

    public static boolean freeToPlace(@Nullable Block block, IBlockState blockState) {
        if (block == null) {
            return true;
        }
        for (BiPredicate<Block, IBlockState> predicate : freeToPlaceBlocks) {
            if (!predicate.test(block, blockState)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWater(IBlockState iBlockState) {
        return Objects.equals(iBlockState, Blocks.WATER.getDefaultState()) || Objects.equals(iBlockState, Blocks.FLOWING_WATER.getDefaultState());
    }

    public static boolean isBlockSeed(@NotNull World world, @NotNull BlockPos pos) {
        return BlockUtils.getItemStackFromBlockState(world.getBlockState(pos.up())) != null && BlockUtils.getItemStackFromBlockState(world.getBlockState(pos.up())).getItem() instanceof ItemSeeds;
    }

    public static ItemStack getItemStackFromBlockState(@NotNull IBlockState blockState) {
        Item item = BlockUtils.getItem(blockState);
        if (item == null) {
            return null;
        }
        Block block = blockState.getBlock();
        if (item instanceof ItemBlock) {
            block = Block.getBlockFromItem((Item)item);
        }
        return new ItemStack(item, 1, BlockUtils.getDamageValue(block, blockState));
    }

    private static Item getItem(@NotNull IBlockState blockState) {
        if (blockState.getBlock() instanceof BlockBanner) {
            return Items.BANNER;
        }
        if (blockState.getBlock() instanceof BlockBed) {
            return Items.BED;
        }
        if (blockState.getBlock() instanceof BlockBrewingStand) {
            return Items.BREWING_STAND;
        }
        if (blockState.getBlock() instanceof BlockCake) {
            return Items.CAKE;
        }
        if (blockState.getBlock() instanceof BlockCauldron) {
            return Items.CAULDRON;
        }
        if (blockState.getBlock() instanceof BlockCocoa) {
            return Items.DYE;
        }
        if (blockState.getBlock() instanceof BlockCrops) {
            ItemStack stack = ((BlockCrops)blockState.getBlock()).getItem(null, null, blockState);
            if (stack != null) {
                return stack.getItem();
            }
            return Items.WHEAT_SEEDS;
        }
        if (blockState.getBlock() instanceof BlockDaylightDetector) {
            return Item.getItemFromBlock((Block)Blocks.DAYLIGHT_DETECTOR);
        }
        if (blockState.getBlock() instanceof BlockDoor) {
            Item item = blockState.getBlock() == Blocks.IRON_DOOR ? Items.IRON_DOOR : (blockState.getBlock() == Blocks.SPRUCE_DOOR ? Items.SPRUCE_DOOR : (blockState.getBlock() == Blocks.BIRCH_DOOR ? Items.BIRCH_DOOR : (blockState.getBlock() == Blocks.JUNGLE_DOOR ? Items.JUNGLE_DOOR : (blockState.getBlock() == Blocks.ACACIA_DOOR ? Items.ACACIA_DOOR : (blockState.getBlock() == Blocks.DARK_OAK_DOOR ? Items.DARK_OAK_DOOR : Items.OAK_DOOR)))));
            return item == null ? Item.getItemFromBlock((Block)blockState.getBlock()) : item;
        }
        if (blockState.getBlock() instanceof BlockFarmland || blockState.getBlock() instanceof BlockGrassPath) {
            return Item.getItemFromBlock((Block)Blocks.DIRT);
        }
        if (blockState.getBlock() instanceof BlockFlowerPot) {
            return Items.FLOWER_POT;
        }
        if (blockState.getBlock() instanceof BlockFurnace) {
            return Item.getItemFromBlock((Block)Blocks.FURNACE);
        }
        if (blockState.getBlock() instanceof BlockHugeMushroom) {
            return blockState.getBlock().getItemDropped(null, null, 0);
        }
        if (blockState.getBlock() instanceof BlockNetherWart) {
            return Items.NETHER_WART;
        }
        if (blockState.getBlock() instanceof BlockPistonExtension) {
            return blockState.getValue((IProperty)BlockPistonExtension.TYPE) == BlockPistonExtension.EnumPistonType.STICKY ? Item.getItemFromBlock((Block)Blocks.STICKY_PISTON) : Item.getItemFromBlock((Block)Blocks.PISTON);
        }
        if (blockState.getBlock() instanceof BlockRedstoneComparator) {
            return Items.COMPARATOR;
        }
        if (blockState.getBlock() instanceof BlockRedstoneLight) {
            return Item.getItemFromBlock((Block)Blocks.REDSTONE_LAMP);
        }
        if (blockState.getBlock() instanceof BlockRedstoneRepeater) {
            return Items.REPEATER;
        }
        if (blockState.getBlock() instanceof BlockRedstoneTorch) {
            return Item.getItemFromBlock((Block)Blocks.REDSTONE_TORCH);
        }
        if (blockState.getBlock() instanceof BlockRedstoneWire) {
            return Items.REDSTONE;
        }
        if (blockState.getBlock() instanceof BlockReed) {
            return Items.REEDS;
        }
        if (blockState.getBlock() instanceof BlockSign) {
            return Items.SIGN;
        }
        if (blockState.getBlock() instanceof BlockSkull) {
            return Items.SKULL;
        }
        if (blockState.getBlock() instanceof BlockStem) {
            ItemStack stack = ((BlockStem)blockState.getBlock()).getItem(null, null, blockState);
            if (stack != null) {
                return stack.getItem();
            }
            return Items.MELON_SEEDS;
        }
        if (blockState.getBlock() instanceof BlockStoneSlab) {
            return Item.getItemFromBlock((Block)Blocks.STONE_SLAB);
        }
        if (blockState.getBlock() instanceof BlockPurpurSlab) {
            return Item.getItemFromBlock((Block)Blocks.PURPUR_SLAB);
        }
        if (blockState.getBlock() instanceof BlockStoneSlabNew) {
            return Item.getItemFromBlock((Block)Blocks.STONE_SLAB2);
        }
        if (blockState.getBlock() instanceof BlockTripWire) {
            return Items.STRING;
        }
        if (blockState.getBlock() instanceof BlockWoodSlab) {
            return Item.getItemFromBlock((Block)Blocks.WOODEN_SLAB);
        }
        return (Item)GameData.getBlockItemMap().get((Object)blockState.getBlock());
    }

    private static int getDamageValue(Block block, @NotNull IBlockState blockState) {
        if (block instanceof BlockCocoa) {
            return EnumDyeColor.BROWN.getDyeDamage();
        }
        if (block instanceof BlockDirt && !(blockState.getBlock() instanceof BlockFarmland)) {
            return ((BlockDirt.DirtType)blockState.getValue((IProperty)BlockDirt.VARIANT)).getMetadata();
        }
        if (block instanceof BlockDoublePlant && blockState.getValue((IProperty)BlockDoublePlant.HALF) == BlockDoublePlant.EnumBlockHalf.LOWER) {
            return ((BlockDoublePlant.EnumPlantType)blockState.getValue((IProperty)BlockDoublePlant.VARIANT)).getMeta();
        }
        if (block instanceof BlockNewLeaf) {
            return block.getMetaFromState(blockState) & 3;
        }
        if (block instanceof BlockOre) {
            return 0;
        }
        if (block instanceof BlockSilverfish || block instanceof BlockTallGrass) {
            return block.getMetaFromState(blockState);
        }
        if (block instanceof BlockSlab) {
            return block.damageDropped(blockState) & 7;
        }
        return block.damageDropped(blockState);
    }

    public static boolean isPathBlock(Block block) {
        return block == Blocks.GRAVEL || block == Blocks.STONEBRICK;
    }
}

