/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.coremod.entity.ai.item.handling.ItemStorage;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.util.InventoryFunctions;
import com.minecolonies.coremod.util.Log;
import com.minecolonies.coremod.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    public static final int FREE_TOOL_CHOICE_LEVEL = 4;
    public static final int EFFECT_TOOL_CHOICE_LEVEL = 2;

    private InventoryUtils() {
    }

    @NotNull
    public static List<ItemStack> getInventoryAsList(@NotNull IInventory inventory) {
        ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        for (int slot = 0; slot < inventory.getSizeInventory(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack == null) continue;
            filtered.add(inventory.getStackInSlot(slot));
        }
        return filtered;
    }

    @NotNull
    public static List<ItemStack> filterInventory(@NotNull IInventory inventory, Block block, int itemDamage) {
        return InventoryUtils.filterInventory(inventory, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    @NotNull
    public static List<ItemStack> filterInventory(@NotNull IInventory inventory, @Nullable Item targetItem, int itemDamage) {
        ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        if (targetItem == null) {
            return filtered;
        }
        for (int slot = 0; slot < inventory.getSizeInventory(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (!InventoryUtils.compareItems(stack, targetItem, itemDamage)) continue;
            filtered.add(stack);
        }
        return filtered;
    }

    public static Item getItemFromBlock(Block block) {
        return new ItemStack(block).getItem();
    }

    private static boolean compareItems(@Nullable ItemStack itemStack, Item targetItem, int itemDamage) {
        return itemStack != null && itemStack.getItem() == targetItem && (itemStack.getItemDamage() == itemDamage || itemDamage == -1);
    }

    public static int findFirstSlotInInventoryWith(@NotNull IInventory inventory, Block block, int itemDamage) {
        return InventoryUtils.findFirstSlotInInventoryWith(inventory, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int findFirstSlotInInventoryWith(@NotNull IInventory inventory, Item targetItem, int itemDamage) {
        for (int slot = 0; slot < inventory.getSizeInventory(); ++slot) {
            if (!InventoryUtils.compareItems(inventory.getStackInSlot(slot), targetItem, itemDamage)) continue;
            return slot;
        }
        return -1;
    }

    public static int getItemCountInInventory(@NotNull IInventory inventory, Block block, int itemDamage) {
        return InventoryUtils.getItemCountInInventory(inventory, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int getItemCountInInventory(@NotNull IInventory inventory, Item targetitem, int itemDamage) {
        int count = 0;
        for (ItemStack is : InventoryUtils.filterInventory(inventory, targetitem, itemDamage)) {
            count += is.stackSize;
        }
        return count;
    }

    public static boolean hasitemInInventory(@NotNull IInventory inventory, Block block, int itemDamage) {
        return InventoryUtils.hasitemInInventory(inventory, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static boolean hasitemInInventory(@NotNull IInventory inventory, Item item, int itemDamage) {
        return InventoryUtils.getItemCountInInventory(inventory, item, itemDamage) > 0;
    }

    public static boolean isInventoryFull(@NotNull IInventory inventory) {
        return InventoryUtils.getOpenSlot(inventory) == -1;
    }

    public static int getOpenSlot(@NotNull IInventory inventory) {
        for (int slot = 0; slot < inventory.getSizeInventory(); ++slot) {
            if (inventory.getStackInSlot(slot) != null) continue;
            return slot;
        }
        return -1;
    }

    public static boolean isToolInTileEntity(IInventory entity, String tool, int toolLevel) {
        return InventoryFunctions.matchFirstInInventoryWithInventory(entity, stack -> Utils.isTool(stack, tool) && InventoryUtils.hasToolLevel(tool, stack, toolLevel), xva$0 -> InventoryFunctions.doNothing(xva$0));
    }

    public static boolean isPickaxeInTileEntity(TileEntityChest entity, int minlevel) {
        return InventoryFunctions.matchFirstInInventoryWithInventory((IInventory)entity, stack -> stack != null && Utils.checkIfPickaxeQualifies(minlevel, Utils.getMiningLevel(stack, "pickaxe")), xva$0 -> InventoryFunctions.doNothing(xva$0));
    }

    public static boolean isPickaxeInTileEntity(IInventory entity, int minlevel, int maxLevel) {
        return InventoryFunctions.matchFirstInInventoryWithInventory(entity, stack -> stack != null && Utils.checkIfPickaxeQualifies(minlevel, Utils.getMiningLevel(stack, "pickaxe")) && InventoryUtils.hasToolLevel("pickaxe", stack, maxLevel), xva$0 -> InventoryFunctions.doNothing(xva$0));
    }

    public static boolean isPickaxeInTileEntity(InventoryCitizen entity, int minlevel) {
        return InventoryFunctions.matchFirstInInventoryWithInventory(entity, stack -> Utils.checkIfPickaxeQualifies(minlevel, Utils.getMiningLevel(stack, "pickaxe")), xva$0 -> InventoryFunctions.doNothing(xva$0));
    }

    public static boolean isToolInTileEntity(InventoryCitizen inventoryCitizen, String tool) {
        return InventoryFunctions.matchFirstInInventoryWithInventory(inventoryCitizen, stack -> Utils.isTool(stack, tool), xva$0 -> InventoryFunctions.doNothing(xva$0));
    }

    public static boolean takeStackInSlot(IInventory sendingInv, IInventory receivingInv, int slotID) {
        return InventoryUtils.takeStackInSlot(sendingInv, receivingInv, slotID, 1, true);
    }

    public static boolean takeStackInSlot(@Nullable IInventory sendingInv, @Nullable IInventory receivingInv, int slotID, int amount, boolean takeAll) {
        ItemStack stack;
        if (receivingInv != null && sendingInv != null && slotID >= 0 && amount >= 0 && (stack = sendingInv.decrStackSize(slotID, amount)) != null) {
            if ((stack = InventoryUtils.setStack(receivingInv, stack)) == null) {
                if (takeAll && (stack = sendingInv.getStackInSlot(slotID)) != null) {
                    stack = sendingInv.decrStackSize(slotID, stack.stackSize);
                    stack = InventoryUtils.setStack(receivingInv, stack);
                    InventoryUtils.setStack(sendingInv, stack);
                }
                return true;
            }
            InventoryUtils.setStack(sendingInv, stack);
            return false;
        }
        return false;
    }

    @Nullable
    public static ItemStack setStack(@NotNull IInventory inventory, @Nullable ItemStack stack) {
        if (stack != null && stack.stackSize > stack.getMaxStackSize()) {
            Log.getLogger().warn("InventoryUtils.setStack: stack size bigger than the max stack size. Please contact a minecolonnies developer.");
        }
        if (stack != null && stack.stackSize != 0 && stack.getItem() != null) {
            int slot;
            ItemStack returnStack = stack.copy();
            while ((slot = InventoryUtils.containsPartialStack(inventory, stack)) != -1 && returnStack != null) {
                ItemStack current = inventory.getStackInSlot(slot);
                int spaceLeft = current.getMaxStackSize() - current.stackSize;
                if (spaceLeft <= 0) continue;
                ItemStack toBeAdded = returnStack.splitStack(Math.min(returnStack.stackSize, spaceLeft));
                if (returnStack.stackSize == 0) {
                    returnStack = null;
                }
                current.stackSize += toBeAdded.stackSize;
                inventory.setInventorySlotContents(slot, current);
            }
            while ((slot = InventoryUtils.getOpenSlot(inventory)) != -1 && returnStack != null) {
                inventory.setInventorySlotContents(slot, returnStack);
                if (returnStack.stackSize > inventory.getInventoryStackLimit()) {
                    returnStack.stackSize -= inventory.getInventoryStackLimit();
                    continue;
                }
                returnStack = null;
            }
            return returnStack;
        }
        return null;
    }

    @Nullable
    public static ItemStack setOverSizedStack(@NotNull IInventory inventory, @Nullable ItemStack stack) {
        int stackSize = stack.stackSize;
        while (stackSize > 0) {
            int itemCount = Math.min(stackSize, stack.getMaxStackSize());
            ItemStack items = new ItemStack(stack.getItem(), itemCount, stack.getItemDamage());
            stackSize -= itemCount;
            ItemStack remainingItems = InventoryUtils.setStack(inventory, items);
            if (remainingItems == null) continue;
            stackSize += remainingItems.stackSize;
            if (items.stackSize != remainingItems.stackSize) continue;
            break;
        }
        return new ItemStack(stack.getItem(), stackSize, stack.getItemDamage());
    }

    public static int containsPartialStack(@NotNull IInventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack testStack = inventory.getStackInSlot(i);
            if (testStack == null || !testStack.isItemEqual(stack) || testStack.stackSize == testStack.getMaxStackSize()) continue;
            return i;
        }
        return -1;
    }

    public static boolean takeStackInSlot(IInventory sendingInv, IInventory receivingInv, int slotID, int amount) {
        return InventoryUtils.takeStackInSlot(sendingInv, receivingInv, slotID, amount, false);
    }

    @NotNull
    public static ItemStack[] getAllItemStacks(@NotNull IInventory inventory) {
        ItemStack[] itemStack = new ItemStack[inventory.getSizeInventory()];
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            itemStack[i] = inventory.getStackInSlot(i);
        }
        return itemStack;
    }

    public static int getAmountOfStacks(@NotNull IInventory inventory) {
        int count = 0;
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack is = inventory.getStackInSlot(i);
            if (is == null) continue;
            ++count;
        }
        return count;
    }

    public static void clear(@NotNull IInventory inventory) {
        for (int slot = 0; slot < inventory.getSizeInventory(); ++slot) {
            inventory.setInventorySlotContents(slot, null);
        }
    }

    public static int getFirstSlotContainingTool(@NotNull IInventory inventory, @NotNull String tool) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack item = inventory.getStackInSlot(i);
            if (item == null || !item.getItem().getToolClasses(item).contains(tool) && (!"hoe".equals(tool) || !item.getUnlocalizedName().contains("hoe")) && (!"rod".equals(tool) || !item.getUnlocalizedName().contains("fishingRod"))) continue;
            return i;
        }
        return -1;
    }

    public static boolean addItemStackToInventory(@NotNull IInventory inventory, @Nullable ItemStack itemStack) {
        if (itemStack != null && itemStack.stackSize != 0 && itemStack.getItem() != null) {
            int stackSize;
            if (itemStack.isItemDamaged()) {
                int stackSize2 = InventoryUtils.getOpenSlot(inventory);
                if (stackSize2 >= 0) {
                    ItemStack copy = ItemStack.copyItemStack((ItemStack)itemStack);
                    copy.animationsToGo = 5;
                    inventory.setInventorySlotContents(stackSize2, copy);
                    itemStack.stackSize = 0;
                    return true;
                }
                return false;
            }
            do {
                stackSize = itemStack.stackSize;
                itemStack.stackSize = InventoryUtils.storePartialItemStack(inventory, itemStack);
            } while (itemStack.stackSize > 0 && itemStack.stackSize < stackSize);
            return itemStack.stackSize < stackSize;
        }
        return false;
    }

    private static int storePartialItemStack(@NotNull IInventory inventory, @NotNull ItemStack itemStack) {
        Item item = itemStack.getItem();
        int stackSize = itemStack.stackSize;
        if (itemStack.getMaxStackSize() == 1) {
            int slot = InventoryUtils.getOpenSlot(inventory);
            if (slot < 0) {
                return stackSize;
            }
            if (inventory.getStackInSlot(slot) == null) {
                inventory.setInventorySlotContents(slot, ItemStack.copyItemStack((ItemStack)itemStack));
            }
            return 0;
        }
        int slot = InventoryUtils.findSlotForItemStack(inventory, itemStack);
        if (slot < 0) {
            slot = InventoryUtils.getOpenSlot(inventory);
        }
        if (slot < 0) {
            return stackSize;
        }
        ItemStack stack = inventory.getStackInSlot(slot);
        if (stack == null) {
            stack = new ItemStack(item, 0, itemStack.getItemDamage());
            if (itemStack.hasTagCompound()) {
                stack.setTagCompound(itemStack.getTagCompound().copy());
            }
        }
        int inventoryStackSpace = stackSize;
        if (stackSize > stack.getMaxStackSize() - stack.stackSize) {
            inventoryStackSpace = stack.getMaxStackSize() - stack.stackSize;
        }
        if (inventoryStackSpace > inventory.getInventoryStackLimit() - stack.stackSize) {
            inventoryStackSpace = inventory.getInventoryStackLimit() - stack.stackSize;
        }
        if (inventoryStackSpace == 0) {
            return stackSize;
        }
        stack.stackSize += inventoryStackSpace;
        stack.animationsToGo = 5;
        inventory.setInventorySlotContents(slot, stack);
        return stackSize -= inventoryStackSpace;
    }

    private static int findSlotForItemStack(@NotNull IInventory inventory, @NotNull ItemStack itemStack) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack inventoryItem = inventory.getStackInSlot(i);
            if (inventoryItem == null || inventoryItem.getItem() != itemStack.getItem() || !inventoryItem.isStackable() || inventoryItem.stackSize >= inventoryItem.getMaxStackSize() || inventoryItem.stackSize >= inventory.getInventoryStackLimit() || inventoryItem.getHasSubtypes() && inventoryItem.getItemDamage() != itemStack.getItemDamage() || !ItemStack.areItemStackTagsEqual((ItemStack)inventoryItem, (ItemStack)itemStack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasToolLevel(String tool, @NotNull IInventory inventory, int hutLevel) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack item = inventory.getStackInSlot(i);
            int level = Utils.getMiningLevel(item, tool);
            if (!Utils.isTool(item, tool) || !InventoryUtils.verifyToolLevel(item, level, hutLevel)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasToolLevel(String tool, @Nullable ItemStack stack, int hutLevel) {
        if (stack == null) {
            return false;
        }
        int level = Utils.getMiningLevel(stack, tool);
        return Utils.isTool(stack, tool) && InventoryUtils.verifyToolLevel(stack, level, hutLevel);
    }

    public static boolean verifyToolLevel(ItemStack item, int level, int hutLevel) {
        if (item == null || hutLevel > 4) {
            return true;
        }
        if (item.isItemEnchanted() && hutLevel <= 2) {
            return false;
        }
        return hutLevel >= level;
    }

    public static String swapToolGrade(int toolGrade) {
        switch (toolGrade) {
            case 0: {
                return "Wood or Gold";
            }
            case 1: {
                return "Stone";
            }
            case 2: {
                return "Iron";
            }
            case 3: {
                return "Diamond";
            }
        }
        return "Better than Diamond";
    }

    @Nullable
    public static ItemStack forceItemStackToInventory(@NotNull IInventory inventory, @NotNull ItemStack itemStack, @NotNull AbstractBuilding building) {
        if (!InventoryUtils.addItemStackToInventory(inventory, itemStack)) {
            ArrayList<ItemStorage> localAlreadyKept = new ArrayList<ItemStorage>();
            for (int i = 0; i < inventory.getSizeInventory(); ++i) {
                ItemStack localStack = inventory.getStackInSlot(i);
                if (EntityAIWorkDeliveryman.workerRequiresItem(building, localStack, localAlreadyKept)) continue;
                ItemStack removedStack = inventory.removeStackFromSlot(i);
                inventory.setInventorySlotContents(i, itemStack.copy());
                return removedStack.copy();
            }
        }
        return null;
    }
}

