/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks;

import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.inventory.InventoryField;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.util.LanguageHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockHutField
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static final float HARDNESS = 10.0f;
    private static final float RESISTANCE = 10.0f;
    private static final double BOTTOM_COLLISION = 0.0;
    private static final double START_COLLISION = 0.1;
    private static final double END_COLLISION = 0.9;
    private static final double HEIGHT_COLLISION = 2.5;
    private static final String REGISTRY_NAME = "blockHutField";

    BlockHutField() {
        super(Material.WOOD);
        this.initBlock();
    }

    private void initBlock() {
        this.setRegistryName(REGISTRY_NAME);
        this.setUnlocalizedName("minecolonies".toLowerCase() + "." + REGISTRY_NAME);
        this.setCreativeTab(ModCreativeTabs.MINECOLONIES);
        this.setResistance(10.0f);
        this.setHardness(10.0f);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public int getMetaFromState(@NotNull IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isPassable(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, 2.5, (double)0.9f);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.SOLID;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        Colony colony;
        if (!worldIn.isRemote && (colony = ColonyManager.getColony(worldIn, pos)) != null) {
            playerIn.openGui((Object)MineColonies.instance, 0, worldIn, pos.getX(), pos.getY(), pos.getZ());
            return true;
        }
        return false;
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nullable EntityLivingBase placer) {
        EnumFacing enumFacing = placer == null ? EnumFacing.NORTH : EnumFacing.fromAngle((double)placer.rotationYaw);
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumFacing);
    }

    public void onBlockPlacedBy(@NotNull World worldIn, @NotNull BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        Colony colony;
        if (worldIn.isRemote) {
            return;
        }
        if (placer instanceof EntityPlayer && (colony = ColonyManager.getColony(worldIn, pos)) != null) {
            InventoryField inventoryField = new InventoryField(LanguageHandler.format("com.minecolonies.coremod.gui.inventory.scarecrow", new Object[0]));
            ((ScarecrowTileEntity)worldIn.getTileEntity(pos)).setInventoryField(inventoryField);
            colony.addNewField((ScarecrowTileEntity)worldIn.getTileEntity(pos), ((EntityPlayer)placer).inventory, pos, worldIn);
        }
    }

    @NotNull
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @NotNull
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new ScarecrowTileEntity();
    }
}

