/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.coremod.client.model.ModelEntityBuilderFemale;
import com.minecolonies.coremod.client.model.ModelEntityCitizenFemaleAristocrat;
import com.minecolonies.coremod.client.model.ModelEntityCitizenFemaleCitizen;
import com.minecolonies.coremod.client.model.ModelEntityCitizenFemaleNoble;
import com.minecolonies.coremod.client.model.ModelEntityDeliverymanFemale;
import com.minecolonies.coremod.client.model.ModelEntityDeliverymanMale;
import com.minecolonies.coremod.client.model.ModelEntityFarmerFemale;
import com.minecolonies.coremod.client.model.ModelEntityFarmerMale;
import com.minecolonies.coremod.client.model.ModelEntityFishermanFemale;
import com.minecolonies.coremod.client.model.ModelEntityFishermanMale;
import com.minecolonies.coremod.client.model.ModelEntityLumberjackFemale;
import com.minecolonies.coremod.client.model.ModelEntityLumberjackMale;
import com.minecolonies.coremod.client.model.ModelEntityMinerFemale;
import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RenderBipedCitizen
extends RenderBiped<EntityCitizen> {
    private static final ModelBiped defaultModelMale = new ModelBiped();
    private static final ModelBiped defaultModelFemale = new ModelEntityCitizenFemaleCitizen();
    private static final Map<Model, ModelBiped> idToMaleModelMap = new EnumMap<Model, ModelBiped>(Model.class);
    private static final Map<Model, ModelBiped> idToFemaleModelMap = new EnumMap<Model, ModelBiped>(Model.class);
    private static final double SHADOW_SIZE = 0.5;

    public RenderBipedCitizen(RenderManager renderManagerIn) {
        super(renderManagerIn, defaultModelMale, 0.5f);
        this.addLayer((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
    }

    public void doRender(@NotNull EntityCitizen citizen, double d, double d1, double d2, float f, float f1) {
        ModelBiped modelBiped = this.modelBipedMain = citizen.isFemale() ? idToFemaleModelMap.get((Object)citizen.getModelID()) : idToMaleModelMap.get((Object)citizen.getModelID());
        if (this.modelBipedMain == null) {
            this.modelBipedMain = citizen.isFemale() ? defaultModelFemale : defaultModelMale;
        }
        this.mainModel = this.modelBipedMain;
        super.doRender((EntityLiving)citizen, d, d1, d2, f, f1);
    }

    protected ResourceLocation getEntityTexture(@NotNull EntityCitizen entity) {
        return entity.getTexture();
    }

    static {
        idToMaleModelMap.put(Model.DELIVERYMAN, new ModelEntityDeliverymanMale());
        idToMaleModelMap.put(Model.LUMBERJACK, new ModelEntityLumberjackMale());
        idToMaleModelMap.put(Model.FARMER, new ModelEntityFarmerMale());
        idToMaleModelMap.put(Model.FISHERMAN, new ModelEntityFishermanMale());
        idToFemaleModelMap.put(Model.NOBLE, new ModelEntityCitizenFemaleNoble());
        idToFemaleModelMap.put(Model.ARISTOCRAT, new ModelEntityCitizenFemaleAristocrat());
        idToFemaleModelMap.put(Model.BUILDER, new ModelEntityBuilderFemale());
        idToFemaleModelMap.put(Model.DELIVERYMAN, new ModelEntityDeliverymanFemale());
        idToFemaleModelMap.put(Model.MINER, new ModelEntityMinerFemale());
        idToFemaleModelMap.put(Model.LUMBERJACK, new ModelEntityLumberjackFemale());
        idToFemaleModelMap.put(Model.FARMER, new ModelEntityFarmerFemale());
        idToFemaleModelMap.put(Model.FISHERMAN, new ModelEntityFishermanFemale());
        idToFemaleModelMap.put(Model.ARCHER_GUARD, new ModelBiped());
        idToFemaleModelMap.put(Model.KNIGHT_GUARD, new ModelBiped());
    }

    public static enum Model {
        SETTLER("Settler", 3),
        CITIZEN("Citizen", 3),
        NOBLE("Noble", 3),
        ARISTOCRAT("Aristocrat", 3),
        BUILDER("Builder", 1),
        DELIVERYMAN("Deliveryman", 1),
        MINER("Miner", 1),
        LUMBERJACK("Lumberjack", 1),
        FARMER("Farmer", 1),
        FISHERMAN("Fisherman", 1),
        ARCHER_GUARD("Archer", 1),
        KNIGHT_GUARD("Knight", 1);

        public final String textureBase;
        public final int numTextures;

        private Model(String textureBase, int numTextures) {
            this.textureBase = textureBase;
            this.numTextures = numTextures;
        }
    }
}

