/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyList;
import com.minecolonies.coremod.colony.ColonyManagerWorldAccess;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.IColony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.configuration.Configurations;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.AchievementUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyManager {
    private static final String FILENAME_MINECOLONIES_PATH = "minecolonies";
    private static final String FILENAME_MINECOLONIES = "colonies.dat";
    private static final String FILENAME_MINECOLONIES_BACKUP = "colonies-%s.dat";
    private static final String TAG_COLONIES = "colonies";
    private static final DamageSource CONSOLE_DAMAGE_SOURCE = new DamageSource("Console");
    @NotNull
    private static final ColonyList<Colony> colonies = new ColonyList();
    @NotNull
    private static final Map<Integer, List<Colony>> coloniesByWorld = new HashMap<Integer, List<Colony>>();
    @NotNull
    private static final ColonyList<ColonyView> colonyViews = new ColonyList();
    private static final int BUFFER = 10;
    private static int numWorldsLoaded;
    private static boolean saveNeeded;

    private ColonyManager() {
    }

    @NotNull
    public static Colony createColony(@NotNull World w, BlockPos pos, @NotNull EntityPlayer player) {
        Colony colony = colonies.create(w, pos);
        ColonyManager.addColonyByWorld(colony);
        String colonyName = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.defaultName", player.getDisplayNameString());
        colony.setName(colonyName);
        colony.getPermissions().setPlayerRank(player.getGameProfile().getId(), Permissions.Rank.OWNER, w);
        colony.triggerAchievement(ModAchievements.achievementGetSupply);
        colony.triggerAchievement(ModAchievements.achievementTownhall);
        ColonyManager.markDirty();
        Log.getLogger().info(String.format("New Colony Id: %d by %s", colony.getID(), player.getName()));
        return colony;
    }

    public static void markDirty() {
        saveNeeded = true;
    }

    public static void deleteColony(int id) {
        try {
            Colony colony = ColonyManager.getColony(id);
            Log.getLogger().info("Deleting colony " + id);
            colonies.remove(id);
            coloniesByWorld.get(colony.getDimension()).remove(colony);
            HashSet<World> colonyWorlds = new HashSet<World>();
            Log.getLogger().info("Removing citizens for " + id);
            for (CitizenData citizenData : new ArrayList<CitizenData>(colony.getCitizens().values())) {
                Log.getLogger().info("Kill Citizen " + citizenData.getName());
                EntityCitizen entityCitizen = citizenData.getCitizenEntity();
                if (entityCitizen == null) continue;
                World world = entityCitizen.getEntityWorld();
                citizenData.getCitizenEntity().onDeath(CONSOLE_DAMAGE_SOURCE);
                colonyWorlds.add(world);
            }
            Log.getLogger().info("Removing buildings for " + id);
            for (AbstractBuilding building : new ArrayList<AbstractBuilding>(colony.getBuildings().values())) {
                BlockPos location = building.getLocation();
                Log.getLogger().info("Delete Building at " + location);
                building.destroy();
                for (World world : colonyWorlds) {
                    if (!(world.getBlockState(location).getBlock() instanceof AbstractBlockHut)) continue;
                    Log.getLogger().info("Found Block, deleting " + world.getBlockState(location).getBlock());
                    world.setBlockToAir(location);
                }
            }
            Log.getLogger().info("Done with " + id);
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Deleting Colony " + id + " errored:", (Throwable)e);
        }
    }

    public static Colony getColony(int id) {
        return colonies.get(id);
    }

    public static void syncAllColoniesAchievements() {
        colonies.forEach(AchievementUtils::syncAchievements);
    }

    public static AbstractBuilding getBuilding(@NotNull World w, @NotNull BlockPos pos) {
        AbstractBuilding building;
        Colony colony = ColonyManager.getColony(w, pos);
        if (colony != null && (building = colony.getBuilding(pos)) != null) {
            return building;
        }
        for (Colony otherColony : ColonyManager.getColonies(w)) {
            AbstractBuilding building2 = otherColony.getBuilding(pos);
            if (building2 == null) continue;
            return building2;
        }
        return null;
    }

    public static Colony getColony(@NotNull World w, @NotNull BlockPos pos) {
        List<Colony> coloniesInWorld = coloniesByWorld.get(w.provider.getDimension());
        if (coloniesInWorld == null) {
            return null;
        }
        for (Colony c : coloniesInWorld) {
            if (!c.isCoordInColony(w, pos)) continue;
            return c;
        }
        return null;
    }

    @NotNull
    public static List<Colony> getColonies(@NotNull World w) {
        List<Colony> coloniesInWorld = coloniesByWorld.get(w.provider.getDimension());
        if (coloniesInWorld == null) {
            return Collections.emptyList();
        }
        return coloniesInWorld;
    }

    @NotNull
    public static List<Colony> getColonies() {
        return colonies.getCopyAsList();
    }

    public static AbstractBuilding.View getBuildingView(BlockPos pos) {
        for (ColonyView colony : colonyViews) {
            AbstractBuilding.View building = colony.getBuilding(pos);
            if (building == null) continue;
            return building;
        }
        return null;
    }

    @Nullable
    public static IColony getIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.isRemote ? ColonyManager.getColonyView(w, pos) : ColonyManager.getColony(w, pos);
    }

    private static ColonyView getColonyView(@NotNull World w, @NotNull BlockPos pos) {
        for (ColonyView c : colonyViews) {
            if (!c.isCoordInColony(w, pos)) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public static IColony getClosestIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.isRemote ? ColonyManager.getClosestColonyView(w, pos) : ColonyManager.getClosestColony(w, pos);
    }

    @Nullable
    public static ColonyView getClosestColonyView(@NotNull World w, @NotNull BlockPos pos) {
        ColonyView closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (ColonyView c : colonyViews) {
            long dist;
            if (c.getDimension() != w.provider.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    public static Colony getClosestColony(@NotNull World w, @NotNull BlockPos pos) {
        Colony closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (Colony c : ColonyManager.getColonies(w)) {
            long dist;
            if (c.getDimension() != w.provider.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    @Nullable
    public static IColony getIColonyByOwner(@NotNull World w, @NotNull EntityPlayer owner) {
        return ColonyManager.getIColonyByOwner(w, w.isRemote ? owner.getUniqueID() : owner.getGameProfile().getId());
    }

    @Nullable
    public static IColony getIColonyByOwner(@NotNull World w, UUID owner) {
        return w.isRemote ? ColonyManager.getColonyViewByOwner(owner) : ColonyManager.getColonyByOwner(owner);
    }

    private static IColony getColonyViewByOwner(UUID owner) {
        for (ColonyView c : colonyViews) {
            Permissions.Player p = c.getPlayers().get(owner);
            if (p == null || !p.getRank().equals((Object)Permissions.Rank.OWNER)) continue;
            return c;
        }
        return null;
    }

    @Nullable
    private static IColony getColonyByOwner(@Nullable UUID owner) {
        if (owner == null) {
            return null;
        }
        return colonies.stream().filter(c -> owner.equals(c.getPermissions().getOwner())).findFirst().orElse(null);
    }

    public static int getMinimumDistanceBetweenTownHalls() {
        return 2 * Configurations.workingRangeTownHall + Configurations.townHallPadding;
    }

    public static void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        for (Colony c : colonies) {
            c.onServerTick(event);
        }
        if (saveNeeded) {
            ColonyManager.saveColonies();
        }
    }

    private static void saveColonies() {
        NBTTagCompound compound = new NBTTagCompound();
        ColonyManager.writeToNBT(compound);
        File file = ColonyManager.getSaveLocation();
        ColonyManager.saveNBTToPath(file, compound);
        saveNeeded = false;
    }

    public static boolean backupColonyData() {
        if (numWorldsLoaded > 0 && saveNeeded) {
            ColonyManager.saveColonies();
        }
        File file = ColonyManager.getSaveLocation();
        File targetFile = ColonyManager.getBackupSaveLocation(new Date());
        if (!file.exists()) {
            return true;
        }
        if (targetFile.exists()) {
            return false;
        }
        try {
            Files.copy(file.toPath(), targetFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return targetFile.exists();
    }

    public static void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList colonyTagList = new NBTTagList();
        for (Colony colony : colonies) {
            NBTTagCompound colonyTagCompound = new NBTTagCompound();
            colony.writeToNBT(colonyTagCompound);
            colonyTagList.appendTag((NBTBase)colonyTagCompound);
        }
        compound.setTag(TAG_COLONIES, (NBTBase)colonyTagList);
    }

    @NotNull
    private static File getSaveLocation() {
        File saveDir = new File(DimensionManager.getWorld((int)0).getSaveHandler().getWorldDirectory(), FILENAME_MINECOLONIES_PATH);
        return new File(saveDir, FILENAME_MINECOLONIES);
    }

    @NotNull
    private static File getBackupSaveLocation(Date date) {
        File saveDir = new File(DimensionManager.getWorld((int)0).getSaveHandler().getWorldDirectory(), FILENAME_MINECOLONIES_PATH);
        return new File(saveDir, String.format(FILENAME_MINECOLONIES_BACKUP, new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(date)));
    }

    private static void saveNBTToPath(@Nullable File file, @NotNull NBTTagCompound compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdir();
                CompressedStreamTools.safeWrite((NBTTagCompound)compound, (File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when saving ColonyManager", (Throwable)exception);
        }
    }

    public static void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.getMinecraft().theWorld == null && !colonyViews.isEmpty()) {
            colonyViews.clear();
        }
    }

    public static void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        ColonyManager.getColonies(event.world).forEach(c -> c.onWorldTick(event));
    }

    public static void onWorldLoad(@NotNull World world) {
        if (!world.isRemote) {
            if (numWorldsLoaded == 0) {
                File file;
                NBTTagCompound data;
                if (!ColonyManager.backupColonyData()) {
                    MineColonies.getLogger().error("Failed to save colonies.dat backup!");
                }
                if ((data = ColonyManager.loadNBTFromPath(file = ColonyManager.getSaveLocation())) != null) {
                    ColonyManager.readFromNBT(data);
                }
            }
            ++numWorldsLoaded;
            for (Colony c : ColonyManager.getColonies(world)) {
                c.onWorldLoad(world);
            }
            world.addEventListener((IWorldEventListener)new ColonyManagerWorldAccess());
        }
    }

    private static NBTTagCompound loadNBTFromPath(@Nullable File file) {
        try {
            if (file != null && file.exists()) {
                return CompressedStreamTools.read((File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when loading ColonyManger", (Throwable)exception);
        }
        return null;
    }

    public static void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList colonyTags = compound.getTagList(TAG_COLONIES, 10);
        for (int i = 0; i < colonyTags.tagCount(); ++i) {
            Colony colony = Colony.loadColony(colonyTags.getCompoundTagAt(i));
            colonies.add(colony);
            ColonyManager.addColonyByWorld(colony);
        }
        Log.getLogger().info(String.format("Loaded %d colonies", colonies.size()));
    }

    private static void addColonyByWorld(Colony colony) {
        coloniesByWorld.computeIfAbsent(colony.getDimension(), ArrayList::new).add(colony);
    }

    public static void onWorldSave(@NotNull World world) {
        if (!world.isRemote && world.provider.getDimension() == 0) {
            ColonyManager.saveColonies();
        }
    }

    public static void onWorldUnload(@NotNull World world) {
        if (!world.isRemote) {
            for (Colony c : ColonyManager.getColonies(world)) {
                c.onWorldUnload(world);
            }
            if (--numWorldsLoaded == 0) {
                colonies.clear();
                coloniesByWorld.clear();
            }
        }
    }

    @Nullable
    public static IMessage handleColonyViewMessage(int colonyId, @NotNull ByteBuf colonyData, boolean isNewSubscription) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            view = ColonyView.createFromNetwork(colonyId);
            colonyViews.add(view);
        }
        return view.handleColonyViewMessage(colonyData, isNewSubscription);
    }

    public static ColonyView getColonyView(int id) {
        return colonyViews.get(id);
    }

    public static IMessage handlePermissionsViewMessage(int colonyID, @NotNull ByteBuf data) {
        ColonyView view = ColonyManager.getColonyView(colonyID);
        if (view == null) {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyID));
            return null;
        }
        return view.handlePermissionsViewMessage(data);
    }

    public static IMessage handleColonyViewCitizensMessage(int colonyId, int citizenId, ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            return null;
        }
        return view.handleColonyViewCitizensMessage(citizenId, buf);
    }

    public static IMessage handleColonyViewWorkOrderMessage(int colonyId, ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            return null;
        }
        return view.handleColonyViewWorkOrderMessage(buf);
    }

    public static IMessage handleColonyViewRemoveCitizenMessage(int colonyId, int citizenId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveCitizenMessage(citizenId);
        }
        return null;
    }

    public static IMessage handleColonyBuildingViewMessage(int colonyId, BlockPos buildingId, @NotNull ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyBuildingViewMessage(buildingId, buf);
        }
        Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyId));
        return null;
    }

    public static IMessage handleColonyViewRemoveBuildingMessage(int colonyId, BlockPos buildingId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveBuildingMessage(buildingId);
        }
        return null;
    }

    public static IMessage handleColonyViewRemoveWorkOrderMessage(int colonyId, int workOrderId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveWorkOrderMessage(workOrderId);
        }
        return null;
    }

    public static boolean isCoordinateInAnyColony(@NotNull World world, BlockPos pos) {
        for (ColonyView c : colonyViews) {
            long dist;
            if (c.getDimension() != world.provider.getDimension() || (dist = c.getDistanceSquared(pos)) >= (long)(Configurations.workingRangeTownHall + Configurations.townHallPadding + 10)) continue;
            return true;
        }
        return false;
    }
}

