/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.BlockHutBaker;
import com.minecolonies.coremod.blocks.BlockHutBlacksmith;
import com.minecolonies.coremod.blocks.BlockHutBuilder;
import com.minecolonies.coremod.blocks.BlockHutCitizen;
import com.minecolonies.coremod.blocks.BlockHutDeliveryman;
import com.minecolonies.coremod.blocks.BlockHutFarmer;
import com.minecolonies.coremod.blocks.BlockHutFisherman;
import com.minecolonies.coremod.blocks.BlockHutGuardTower;
import com.minecolonies.coremod.blocks.BlockHutLumberjack;
import com.minecolonies.coremod.blocks.BlockHutMiner;
import com.minecolonies.coremod.blocks.BlockHutStonemason;
import com.minecolonies.coremod.blocks.BlockHutTownHall;
import com.minecolonies.coremod.blocks.BlockHutWareHouse;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.BuildingBaker;
import com.minecolonies.coremod.colony.buildings.BuildingBlacksmith;
import com.minecolonies.coremod.colony.buildings.BuildingBuilder;
import com.minecolonies.coremod.colony.buildings.BuildingDeliveryman;
import com.minecolonies.coremod.colony.buildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.BuildingFisherman;
import com.minecolonies.coremod.colony.buildings.BuildingGuardTower;
import com.minecolonies.coremod.colony.buildings.BuildingHome;
import com.minecolonies.coremod.colony.buildings.BuildingLumberjack;
import com.minecolonies.coremod.colony.buildings.BuildingMiner;
import com.minecolonies.coremod.colony.buildings.BuildingStonemason;
import com.minecolonies.coremod.colony.buildings.BuildingTownHall;
import com.minecolonies.coremod.colony.buildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.buildings.views.BuildingBuilderView;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.coremod.entity.ai.item.handling.ItemStorage;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.InventoryUtils;
import com.minecolonies.coremod.util.LanguageHandler;
import com.minecolonies.coremod.util.Log;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuilding {
    private static final String TAG_CONTAINERS = "Containers";
    private static final String TAG_BUILDING_TYPE = "type";
    private static final String TAG_LOCATION = "location";
    private static final String TAG_BUILDING_LEVEL = "level";
    private static final String TAG_ROTATION = "rotation";
    private static final String TAG_MIRROR = "mirror";
    private static final String TAG_STYLE = "style";
    private static final int NO_WORK_ORDER = 0;
    @NotNull
    private List<ItemStack> itemsCurrentlyNeeded = new ArrayList<ItemStack>();
    private final List<BlockPos> containerList = new ArrayList<BlockPos>();
    private boolean needsShovel = false;
    private boolean needsAxe = false;
    private boolean needsHoe = false;
    private boolean needsPickaxe = false;
    private boolean needsWeapon = false;
    private int needsPickaxeLevel = -1;
    private boolean onGoingDelivery = false;
    @NotNull
    private static final Map<String, Class<?>> nameToClassMap = new HashMap();
    @NotNull
    private static final Map<Class<?>, String> classToNameMap = new HashMap();
    @NotNull
    private static final Map<Class<?>, Class<?>> blockClassToBuildingClassMap = new HashMap();
    @NotNull
    private static final Map<Integer, Class<?>> classNameHashToViewClassMap = new HashMap();
    private final BlockPos location;
    @NotNull
    private final Colony colony;
    private TileEntityColonyBuilding tileEntity;
    private int buildingLevel = 0;
    private int rotation = 0;
    private boolean isMirrored = false;
    private String style = "wooden";
    private boolean dirty = false;

    protected AbstractBuilding(@NotNull Colony colony, BlockPos pos) {
        this.location = pos;
        this.colony = colony;
    }

    private static void addMapping(String name, @NotNull Class<? extends AbstractBuilding> buildingClass, @NotNull Class<? extends View> viewClass, @NotNull Class<? extends AbstractBlockHut> parentBlock) {
        int buildingHashCode = buildingClass.getName().hashCode();
        if (nameToClassMap.containsKey(name) || classNameHashToViewClassMap.containsKey(buildingHashCode)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding AbstractBuilding class mapping");
        }
        try {
            if (buildingClass.getDeclaredConstructor(Colony.class, BlockPos.class) != null) {
                nameToClassMap.put(name, buildingClass);
                classToNameMap.put(buildingClass, name);
                classNameHashToViewClassMap.put(buildingHashCode, viewClass);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding AbstractBuilding class mapping", exception);
        }
        if (blockClassToBuildingClassMap.containsKey(parentBlock)) {
            throw new IllegalArgumentException("AbstractBuilding type '" + name + "' uses TileEntity '" + parentBlock.getClass().getName() + "' which is already in use.");
        }
        blockClassToBuildingClassMap.put(parentBlock, buildingClass);
    }

    @Nullable
    public static AbstractBuilding createFromNBT(Colony colony, @NotNull NBTTagCompound compound) {
        AbstractBuilding building = null;
        Class<?> oclass = null;
        try {
            oclass = nameToClassMap.get(compound.getString(TAG_BUILDING_TYPE));
            if (oclass != null) {
                BlockPos pos = BlockPosUtil.readFromNBT(compound, TAG_LOCATION);
                Constructor<?> constructor = oclass.getDeclaredConstructor(Colony.class, BlockPos.class);
                building = (AbstractBuilding)constructor.newInstance(colony, pos);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Log.getLogger().error((Object)exception);
        }
        if (building == null) {
            Log.getLogger().warn(String.format("Unknown Building type '%s' or missing constructor of proper format.", compound.getString(TAG_BUILDING_TYPE)));
            return null;
        }
        try {
            building.readFromNBT(compound);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A Building %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.getString(TAG_BUILDING_TYPE), oclass.getName()), (Throwable)ex);
            building = null;
        }
        return building;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.buildingLevel = compound.getInteger(TAG_BUILDING_LEVEL);
        this.rotation = compound.getInteger(TAG_ROTATION);
        this.style = compound.getString(TAG_STYLE);
        if (this.style.isEmpty()) {
            Log.getLogger().warn("Loaded empty style, setting to wooden");
            this.style = "wooden";
        }
        NBTTagList containerTagList = compound.getTagList(TAG_CONTAINERS, 10);
        for (int i = 0; i < containerTagList.tagCount(); ++i) {
            NBTTagCompound containerCompound = containerTagList.getCompoundTagAt(i);
            this.containerList.add(NBTUtil.getPosFromTag((NBTTagCompound)containerCompound));
        }
        this.isMirrored = compound.getBoolean(TAG_MIRROR);
    }

    @Nullable
    public static AbstractBuilding create(Colony colony, @NotNull TileEntityColonyBuilding parent) {
        AbstractBuilding building = null;
        try {
            Class<?> oclass = blockClassToBuildingClassMap.get(parent.getBlockType().getClass());
            if (oclass == null) {
                Log.getLogger().error(String.format("TileEntity %s does not have an associated Building.", ((Object)((Object)parent)).getClass().getName()));
                return null;
            }
            BlockPos loc = parent.getPosition();
            Constructor<?> constructor = oclass.getDeclaredConstructor(Colony.class, BlockPos.class);
            building = (AbstractBuilding)constructor.newInstance(colony, loc);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Log.getLogger().error(String.format("Unknown Building type '%s' or missing constructor of proper format.", ((Object)((Object)parent)).getClass().getName()), (Throwable)exception);
        }
        if (building != null && parent.getWorld() != null) {
            ConstructionTapeHelper.placeConstructionTape(building, parent.getWorld());
        }
        return building;
    }

    @Nullable
    public static View createBuildingView(ColonyView colony, BlockPos id, @NotNull ByteBuf buf) {
        View view = null;
        Class<?> oclass = null;
        try {
            int typeHash = buf.readInt();
            oclass = classNameHashToViewClassMap.get(typeHash);
            if (oclass != null) {
                Constructor<?> constructor = oclass.getDeclaredConstructor(ColonyView.class, BlockPos.class);
                view = (View)constructor.newInstance(colony, id);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Log.getLogger().error((Object)exception);
        }
        if (view == null) {
            Log.getLogger().warn("Unknown AbstractBuilding type, missing View subclass, or missing constructor of proper format.");
            return null;
        }
        try {
            view.deserialize(buf);
        }
        catch (IndexOutOfBoundsException ex) {
            Log.getLogger().error(String.format("A AbstractBuilding View (%s) has thrown an exception during deserializing, its state cannot be restored. Report this to the mod author", oclass.getName()), (Throwable)ex);
            return null;
        }
        return view;
    }

    public abstract String getSchematicName();

    public boolean isMatchingBlock(@NotNull Block block) {
        Class<?> c = blockClassToBuildingClassMap.get(block.getClass());
        return this.getClass().equals(c);
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        String s = classToNameMap.get(this.getClass());
        if (s == null) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compound.setString(TAG_BUILDING_TYPE, s);
        BlockPosUtil.writeToNBT(compound, TAG_LOCATION, this.location);
        compound.setInteger(TAG_BUILDING_LEVEL, this.buildingLevel);
        compound.setInteger(TAG_ROTATION, this.rotation);
        compound.setString(TAG_STYLE, this.style);
        NBTTagList containerTagList = new NBTTagList();
        for (BlockPos pos : this.containerList) {
            containerTagList.appendTag((NBTBase)NBTUtil.createPosTag((BlockPos)pos));
        }
        compound.setTag(TAG_CONTAINERS, (NBTBase)containerTagList);
        compound.setBoolean(TAG_MIRROR, this.isMirrored);
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void clearDirty() {
        this.dirty = false;
    }

    public final void destroy() {
        this.onDestroyed();
        this.colony.removeBuilding(this);
    }

    public void onDestroyed() {
        TileEntityColonyBuilding tileEntityNew = this.getTileEntity();
        World world = this.colony.getWorld();
        Block block = world.getBlockState(this.location).getBlock();
        if (tileEntityNew != null) {
            InventoryHelper.dropInventoryItems((World)world, (BlockPos)this.location, (IInventory)tileEntityNew);
            world.updateComparatorOutputLevel(this.location, block);
            ConstructionTapeHelper.removeConstructionTape(this, world);
        }
        ConstructionTapeHelper.removeConstructionTape(this, world);
    }

    public TileEntityColonyBuilding getTileEntity() {
        TileEntity te;
        if ((this.tileEntity == null || this.tileEntity.isInvalid()) && this.colony.getWorld().getBlockState(this.location).getBlock() != null && (te = this.getColony().getWorld().getTileEntity(this.location)) instanceof TileEntityColonyBuilding) {
            this.tileEntity = (TileEntityColonyBuilding)te;
            if (this.tileEntity.getBuilding() == null) {
                this.tileEntity.setColony(this.colony);
                this.tileEntity.setBuilding(this);
            }
        }
        return this.tileEntity;
    }

    public void setTileEntity(TileEntityColonyBuilding te) {
        this.tileEntity = te;
    }

    @NotNull
    public Colony getColony() {
        return this.colony;
    }

    public void removeCitizen(CitizenData citizen) {
    }

    public void onServerTick(TickEvent.ServerTickEvent event) {
    }

    public void onWorldTick(TickEvent.WorldTickEvent event) {
    }

    public void requestUpgrade() {
        if (this.buildingLevel < this.getMaxBuildingLevel()) {
            this.requestWorkOrder(this.buildingLevel + 1);
        }
    }

    private int getCurrentWorkOrderLevel() {
        for (WorkOrderBuild o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuild.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            return o.getUpgradeLevel();
        }
        return 0;
    }

    public boolean hasWorkOrder() {
        return this.getCurrentWorkOrderLevel() != 0;
    }

    public abstract int getMaxBuildingLevel();

    private void requestWorkOrder(int level) {
        for (WorkOrderBuild o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuild.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            return;
        }
        this.colony.getWorkManager().addWorkOrder(new WorkOrderBuild(this, level));
        LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.workOrderAdded", new Object[0]);
        this.markDirty();
    }

    public BlockPos getID() {
        return this.location;
    }

    public void requestRepair() {
        if (this.buildingLevel > 0) {
            this.requestWorkOrder(this.buildingLevel);
        }
    }

    public void removeWorkOrder() {
        for (WorkOrderBuild o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuild.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            this.colony.getWorkManager().removeWorkOrder(o.getID());
            this.markDirty();
            return;
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void onUpgradeComplete(int newLevel) {
    }

    public void serializeToView(@NotNull ByteBuf buf) {
        buf.writeInt(this.getClass().getName().hashCode());
        buf.writeInt(this.getBuildingLevel());
        buf.writeInt(this.getMaxBuildingLevel());
        buf.writeInt(this.getCurrentWorkOrderLevel());
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    public void setBuildingLevel(int level) {
        if (level > this.getMaxBuildingLevel()) {
            return;
        }
        this.buildingLevel = level;
        this.markDirty();
        ColonyManager.markDirty();
    }

    public final void markDirty() {
        this.dirty = true;
        if (this.colony != null) {
            this.colony.markBuildingsDirty();
        }
    }

    public void addContainerPosition(BlockPos pos) {
        this.containerList.add(pos);
    }

    public void removeContainerPosition(BlockPos pos) {
        this.containerList.remove(pos);
    }

    public List<BlockPos> getAdditionalCountainers() {
        return new ArrayList<BlockPos>(this.containerList);
    }

    public Map<ItemStorage, Integer> getRequiredItemsAndAmount() {
        return Collections.emptyMap();
    }

    public boolean hasOnGoingDelivery() {
        return this.onGoingDelivery;
    }

    public void setOnGoingDelivery(boolean valueToSet) {
        this.onGoingDelivery = valueToSet;
    }

    public boolean needsAnything() {
        return !this.itemsCurrentlyNeeded.isEmpty() || this.needsShovel || this.needsAxe || this.needsHoe || this.needsWeapon || this.needsPickaxe;
    }

    public boolean areItemsNeeded() {
        return !this.itemsCurrentlyNeeded.isEmpty();
    }

    public boolean needsShovel() {
        return this.needsShovel;
    }

    public boolean needsAxe() {
        return this.needsAxe;
    }

    public boolean needsHoe() {
        return this.needsHoe;
    }

    public boolean needsPickaxe() {
        return this.needsPickaxe;
    }

    public boolean needsWeapon() {
        return this.needsWeapon;
    }

    public int getNeededPickaxeLevel() {
        return this.needsPickaxeLevel;
    }

    public void setNeedsShovel(boolean needsShovel) {
        this.needsShovel = needsShovel;
    }

    public void setNeedsAxe(boolean needsAxe) {
        this.needsAxe = needsAxe;
    }

    public void setNeedsHoe(boolean needsHoe) {
        this.needsHoe = needsHoe;
    }

    public void setNeedsPickaxe(boolean needsPickaxe) {
        this.needsPickaxe = needsPickaxe;
    }

    public void setNeedsWeapon(boolean needsWeapon) {
        this.needsWeapon = needsWeapon;
    }

    public void addNeededItems(@Nullable ItemStack stack) {
        if (stack != null) {
            this.itemsCurrentlyNeeded.add(stack);
        }
    }

    public List<ItemStack> getNeededItems() {
        return Collections.unmodifiableList(this.itemsCurrentlyNeeded);
    }

    @Nullable
    public ItemStack getFirstNeededItem() {
        if (this.itemsCurrentlyNeeded.isEmpty()) {
            return null;
        }
        return this.itemsCurrentlyNeeded.get(0).copy();
    }

    public void clearNeededItems() {
        this.itemsCurrentlyNeeded.clear();
    }

    public void setItemsCurrentlyNeeded(@NotNull List<ItemStack> newList) {
        this.itemsCurrentlyNeeded = new ArrayList<ItemStack>(newList);
    }

    public void setNeedsPickaxeLevel(int needsPickaxeLevel) {
        this.needsPickaxeLevel = needsPickaxeLevel;
    }

    public String getRequiredTool() {
        if (this.needsHoe) {
            return "hoe";
        }
        if (this.needsAxe) {
            return "axe";
        }
        if (this.needsPickaxe) {
            return "pickaxe";
        }
        if (this.needsShovel) {
            return "shovel";
        }
        if (this.needsWeapon) {
            return "weapon";
        }
        return "";
    }

    public boolean transferStack(@NotNull ItemStack stack, @NotNull World world) {
        if (this.tileEntity == null || InventoryUtils.isProviderFull((ICapabilityProvider)this.tileEntity)) {
            for (BlockPos pos : this.containerList) {
                TileEntity tempTileEntity = world.getTileEntity(pos);
                if (!(tempTileEntity instanceof TileEntityChest) || InventoryUtils.isProviderFull((ICapabilityProvider)tempTileEntity)) continue;
                return InventoryUtils.addItemStackToProvider((ICapabilityProvider)tempTileEntity, stack);
            }
        } else {
            return InventoryUtils.addItemStackToProvider((ICapabilityProvider)this.tileEntity, stack);
        }
        return false;
    }

    @Nullable
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        if (this.tileEntity == null) {
            for (BlockPos pos : this.containerList) {
                TileEntity tempTileEntity = world.getTileEntity(pos);
                if (!(tempTileEntity instanceof TileEntityChest) || InventoryUtils.isProviderFull((ICapabilityProvider)tempTileEntity)) continue;
                return this.forceItemStackToProvider((ICapabilityProvider)tempTileEntity, stack);
            }
        } else {
            return this.forceItemStackToProvider((ICapabilityProvider)this.tileEntity, stack);
        }
        return null;
    }

    public boolean isMirrored() {
        return this.isMirrored;
    }

    public void setMirror() {
        this.isMirrored = !this.isMirrored;
    }

    @Nullable
    private ItemStack forceItemStackToProvider(@NotNull ICapabilityProvider provider, @NotNull ItemStack itemStack) {
        ArrayList localAlreadyKept = new ArrayList();
        return InventoryUtils.forceItemStackToProvider(provider, itemStack, stack -> EntityAIWorkDeliveryman.workerRequiresItem(this, stack, localAlreadyKept));
    }

    static {
        AbstractBuilding.addMapping("Baker", BuildingBaker.class, BuildingBaker.View.class, BlockHutBaker.class);
        AbstractBuilding.addMapping("Blacksmith", BuildingBlacksmith.class, BuildingBlacksmith.View.class, BlockHutBlacksmith.class);
        AbstractBuilding.addMapping("Builder", BuildingBuilder.class, BuildingBuilderView.class, BlockHutBuilder.class);
        AbstractBuilding.addMapping("Home", BuildingHome.class, BuildingHome.View.class, BlockHutCitizen.class);
        AbstractBuilding.addMapping("Farmer", BuildingFarmer.class, BuildingFarmer.View.class, BlockHutFarmer.class);
        AbstractBuilding.addMapping("Lumberjack", BuildingLumberjack.class, BuildingLumberjack.View.class, BlockHutLumberjack.class);
        AbstractBuilding.addMapping("Miner", BuildingMiner.class, BuildingMiner.View.class, BlockHutMiner.class);
        AbstractBuilding.addMapping("Stonemason", BuildingStonemason.class, BuildingStonemason.View.class, BlockHutStonemason.class);
        AbstractBuilding.addMapping("TownHall", BuildingTownHall.class, BuildingTownHall.View.class, BlockHutTownHall.class);
        AbstractBuilding.addMapping("Deliveryman", BuildingDeliveryman.class, BuildingDeliveryman.View.class, BlockHutDeliveryman.class);
        AbstractBuilding.addMapping("Fisherman", BuildingFisherman.class, BuildingFisherman.View.class, BlockHutFisherman.class);
        AbstractBuilding.addMapping("GuardTower", BuildingGuardTower.class, BuildingGuardTower.View.class, BlockHutGuardTower.class);
        AbstractBuilding.addMapping("WareHouse", BuildingWareHouse.class, BuildingWareHouse.View.class, BlockHutWareHouse.class);
    }

    public static class View {
        private final ColonyView colony;
        @NotNull
        private final BlockPos location;
        private int buildingLevel = 0;
        private int buildingMaxLevel = 0;
        private int workOrderLevel = 0;

        protected View(ColonyView c, @NotNull BlockPos l) {
            this.colony = c;
            this.location = new BlockPos((Vec3i)l);
        }

        @NotNull
        public BlockPos getID() {
            return this.location;
        }

        @NotNull
        public BlockPos getLocation() {
            return this.location;
        }

        public ColonyView getColony() {
            return this.colony;
        }

        public int getBuildingLevel() {
            return this.buildingLevel;
        }

        public int getBuildingMaxLevel() {
            return this.buildingMaxLevel;
        }

        public boolean isBuildingMaxLevel() {
            return this.buildingLevel >= this.buildingMaxLevel;
        }

        public int getCurrentWorkOrderLevel() {
            return this.workOrderLevel;
        }

        public boolean hasWorkOrder() {
            return this.workOrderLevel != 0;
        }

        public boolean isBuilding() {
            return this.workOrderLevel != 0 && this.workOrderLevel > this.buildingLevel;
        }

        public boolean isRepairing() {
            return this.workOrderLevel != 0 && this.workOrderLevel == this.buildingLevel;
        }

        public void openGui() {
            Window window = this.getWindow();
            if (window != null) {
                window.open();
            }
        }

        @Nullable
        public Window getWindow() {
            return null;
        }

        public void deserialize(@NotNull ByteBuf buf) {
            this.buildingLevel = buf.readInt();
            this.buildingMaxLevel = buf.readInt();
            this.workOrderLevel = buf.readInt();
        }
    }
}

